// License: GPL. Copyright 2011 by Josh Doe and others

/*
 * ConflationPanel.java
 *
 * Created on Apr 26, 2011, 10:47:18 PM
 */

package org.openstreetmap.josm.plugins.conflation;

import java.awt.Component;
import java.util.*;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

import static org.openstreetmap.josm.tools.I18n.tr;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.conflict.ConflictCollection;
import org.openstreetmap.josm.data.conflict.IConflictListener;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.data.osm.event.*;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.OsmPrimitivRenderer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;

import utilsplugin2.dumbutils.ReplaceGeometryAction;

/**
 *
 * @author Josh
 */
public class ConflationOptionsPanel extends javax.swing.JPanel implements DataSetListener {
    ConflationOptionsDialog dlg = null;
    ConflationLayer conflationLayer = null;
    DataSet targetDataSet = null;
    DataSet sourceDataSet = null;
    ArrayList<OsmPrimitive> targetSelection = null;
    ArrayList<OsmPrimitive> sourceSelection = null;
    OsmDataLayer targetLayer = null;
    OsmDataLayer sourceLayer = null;
    MatchTableModel tableModel;
    List<ConflationCandidate> candidates = null;

    /** Creates new form ConflationPanel */
    public ConflationOptionsPanel(ConflationOptionsDialog dlg, List<OsmDataLayer> layers) {
        initComponents();

        // add selection handler, to center/zoom view
        resultsTable.getSelectionModel().addListSelectionListener(
                new MatchListSelectionHandler());
        resultsTable.getColumnModel().getSelectionModel().addListSelectionListener(
                new MatchListSelectionHandler());

        // FIXME: doesn't work right now
        resultsTable.getColumnModel().getColumn(0).setCellRenderer(new OsmPrimitivRenderer());
        resultsTable.getColumnModel().getColumn(1).setCellRenderer(new OsmPrimitivRenderer());
        resultsTable.getColumnModel().getColumn(4).setCellRenderer(new ColorTableCellRenderer("Tags"));

        this.dlg = dlg;

        // set layer names to comboboxes
//        if (layers != null && layers.size() > 0) {
//            refLayerComboBox.setModel(new javax.swing.DefaultComboBoxModel(layers.toArray()));
//            refLayerComboBox.setRenderer(new LayerListCellRenderer());
//            nonRefLayerComboBox.setModel(new javax.swing.DefaultComboBoxModel(layers.toArray()));
//            nonRefLayerComboBox.setRenderer(new LayerListCellRenderer());
//        }

    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        resultsTabPanel = new javax.swing.JTabbedPane();
        objectTabPanel = new javax.swing.JPanel();
        refSetPanel = new javax.swing.JPanel();
        freezeMySetButton = new javax.swing.JButton();
        jPanel3 = new javax.swing.JPanel();
        jLabel2 = new javax.swing.JLabel();
        myLayerLabel = new javax.swing.JLabel();
        jLabel1 = new javax.swing.JLabel();
        myNodeCountLabel = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        myWayCountLabel = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        myRelationCountLabel = new javax.swing.JLabel();
        restoreMySetButton = new javax.swing.JButton();
        nonRefSetPanel = new javax.swing.JPanel();
        freezeTheirSelectionButton = new javax.swing.JButton();
        jPanel4 = new javax.swing.JPanel();
        jLabel6 = new javax.swing.JLabel();
        theirLayerLabel = new javax.swing.JLabel();
        jLabel7 = new javax.swing.JLabel();
        theirNodeCountLabel = new javax.swing.JLabel();
        jLabel9 = new javax.swing.JLabel();
        theirWayCountLabel = new javax.swing.JLabel();
        jLabel5 = new javax.swing.JLabel();
        theirRelationCountLabel = new javax.swing.JLabel();
        restoreTheirSetButton = new javax.swing.JButton();
        objectTabCancelButton = new javax.swing.JButton();
        objectTabNextButton = new javax.swing.JButton();
        criteriaTabPanel = new javax.swing.JPanel();
        jPanel2 = new javax.swing.JPanel();
        jCheckBox1 = new javax.swing.JCheckBox();
        criteriaTabConflateButton = new javax.swing.JButton();
        resultsPanel = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        resultsTable = new javax.swing.JTable();
        jPanel1 = new javax.swing.JPanel();
        replaceGeometryButton = new javax.swing.JButton();
        jLabel8 = new javax.swing.JLabel();
        useTheirTagsButton = new javax.swing.JButton();
        jButton1 = new javax.swing.JButton();
        resolveButton = new javax.swing.JButton();

        setLayout(new javax.swing.BoxLayout(this, javax.swing.BoxLayout.LINE_AXIS));

        objectTabPanel.setLayout(new javax.swing.BoxLayout(objectTabPanel, javax.swing.BoxLayout.PAGE_AXIS));

        refSetPanel.setBorder(javax.swing.BorderFactory.createTitledBorder("Target Selection"));
        refSetPanel.setLayout(new javax.swing.BoxLayout(refSetPanel, javax.swing.BoxLayout.LINE_AXIS));

        freezeMySetButton.setText("Freeze Selection");
        freezeMySetButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                freezeTargetSelectionActionPerformed(evt);
            }
        });
        refSetPanel.add(freezeMySetButton);

        jPanel3.setLayout(new java.awt.GridLayout(0, 2, 2, 0));

        jLabel2.setText("Layer");
        jPanel3.add(jLabel2);

        myLayerLabel.setText("(invalid)");
        jPanel3.add(myLayerLabel);

        jLabel1.setText("Nodes");
        jPanel3.add(jLabel1);

        myNodeCountLabel.setText("0");
        jPanel3.add(myNodeCountLabel);

        jLabel3.setText("Ways");
        jPanel3.add(jLabel3);

        myWayCountLabel.setText("0");
        jPanel3.add(myWayCountLabel);

        jLabel4.setText("Relations");
        jPanel3.add(jLabel4);

        myRelationCountLabel.setText("0");
        jPanel3.add(myRelationCountLabel);

        refSetPanel.add(jPanel3);

        restoreMySetButton.setText("Restore Selection");
        restoreMySetButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                restoreMySetButtonActionPerformed(evt);
            }
        });
        refSetPanel.add(restoreMySetButton);

        objectTabPanel.add(refSetPanel);

        nonRefSetPanel.setBorder(javax.swing.BorderFactory.createTitledBorder("Source Selection"));
        nonRefSetPanel.setLayout(new javax.swing.BoxLayout(nonRefSetPanel, javax.swing.BoxLayout.LINE_AXIS));

        freezeTheirSelectionButton.setText("Freeze Selection");
        freezeTheirSelectionButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                freezeSourceSelectionActionPerformed(evt);
            }
        });
        nonRefSetPanel.add(freezeTheirSelectionButton);

        jPanel4.setLayout(new java.awt.GridLayout(0, 2, 2, 0));

        jLabel6.setText("Layer");
        jPanel4.add(jLabel6);

        theirLayerLabel.setText("(invalid)");
        jPanel4.add(theirLayerLabel);

        jLabel7.setText("Nodes");
        jPanel4.add(jLabel7);

        theirNodeCountLabel.setText("0");
        jPanel4.add(theirNodeCountLabel);

        jLabel9.setText("Ways");
        jPanel4.add(jLabel9);

        theirWayCountLabel.setText("0");
        jPanel4.add(theirWayCountLabel);

        jLabel5.setText("Relations");
        jPanel4.add(jLabel5);

        theirRelationCountLabel.setText("0");
        jPanel4.add(theirRelationCountLabel);

        nonRefSetPanel.add(jPanel4);

        restoreTheirSetButton.setText("Restore Selection");
        restoreTheirSetButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                restoreTheirSetButtonActionPerformed(evt);
            }
        });
        nonRefSetPanel.add(restoreTheirSetButton);

        objectTabPanel.add(nonRefSetPanel);

        objectTabCancelButton.setText("Cancel");
        objectTabCancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                objectTabCancelButtonActionPerformed(evt);
            }
        });
        objectTabPanel.add(objectTabCancelButton);

        objectTabNextButton.setMnemonic('N');
        objectTabNextButton.setText("Next");
        objectTabNextButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                objectTabNextButtonActionPerformed(evt);
            }
        });
        objectTabPanel.add(objectTabNextButton);

        resultsTabPanel.addTab("Object selection", objectTabPanel);

        criteriaTabPanel.setLayout(new javax.swing.BoxLayout(criteriaTabPanel, javax.swing.BoxLayout.PAGE_AXIS));

        jPanel2.setBorder(javax.swing.BorderFactory.createEtchedBorder());

        jCheckBox1.setSelected(true);
        jCheckBox1.setText("Distance");
        jCheckBox1.setEnabled(false);
        jCheckBox1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBox1ActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jCheckBox1)
                .addContainerGap(350, Short.MAX_VALUE))
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jCheckBox1)
                .addContainerGap(195, Short.MAX_VALUE))
        );

        criteriaTabPanel.add(jPanel2);

        criteriaTabConflateButton.setMnemonic('f');
        criteriaTabConflateButton.setText("Conflate");
        criteriaTabConflateButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                criteriaTabConflateButtonActionPerformed(evt);
            }
        });
        criteriaTabPanel.add(criteriaTabConflateButton);

        resultsTabPanel.addTab("Matching criteria", criteriaTabPanel);

        resultsPanel.setLayout(new javax.swing.BoxLayout(resultsPanel, javax.swing.BoxLayout.PAGE_AXIS));

        resultsTable.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, null, null, null, null},
                {null, null, null, null, null},
                {null, null, null, null, null},
                {null, null, null, null, null}
            },
            new String [] {
                "Mine", "Theirs", "Distance (m)", "Cost", "Tags"
            }
        ));
        resultsTable.setSelectionMode(javax.swing.ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        jScrollPane1.setViewportView(resultsTable);

        resultsPanel.add(jScrollPane1);

        jPanel1.setBorder(javax.swing.BorderFactory.createEtchedBorder());

        replaceGeometryButton.setText("Replace Geometry");
        replaceGeometryButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                replaceGeometryButtonActionPerformed(evt);
            }
        });

        jLabel8.setText("Resolve using:");

        useTheirTagsButton.setText("Merge tags");
        useTheirTagsButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                useTheirTagsButtonActionPerformed(evt);
            }
        });

        jButton1.setText("Not a match");
        jButton1.setEnabled(false);

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel8)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(replaceGeometryButton)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(useTheirTagsButton)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jButton1)
                .addContainerGap(14, Short.MAX_VALUE))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel8)
                    .addComponent(replaceGeometryButton)
                    .addComponent(useTheirTagsButton)
                    .addComponent(jButton1))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        resultsPanel.add(jPanel1);

        resolveButton.setText("Resolve");
        resolveButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                resolveButtonActionPerformed(evt);
            }
        });
        resultsPanel.add(resolveButton);

        resultsTabPanel.addTab("Results", resultsPanel);

        add(resultsTabPanel);
    }// </editor-fold>//GEN-END:initComponents

    private void objectTabCancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_objectTabCancelButtonActionPerformed
        dlg.setCanceled(true);
        dlg.setVisible(false);
    }//GEN-LAST:event_objectTabCancelButtonActionPerformed

    private void criteriaTabConflateButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_criteriaTabConflateButtonActionPerformed

        // some initialization
        int n = targetSelection.size();
        int m = sourceSelection.size();
        int maxLen = Math.max(n, m);
        double cost[][] = new double[maxLen][maxLen];

        // calculate cost matrix
        for (int i = 0; i < n; i++) {
            for (int j = 0; j < m; j++) {
                cost[i][j] = calcCost(targetSelection.get(i), sourceSelection.get(j));
            }
        }

        // perform assignment using Hungarian algorithm
        int[][] assignment = HungarianAlgorithm.hgAlgorithm(cost, "min");
        OsmPrimitive target, source;
        candidates = new LinkedList<ConflationCandidate>();
        for (int i = 0; i < maxLen; i++) {
            int tgtIdx = assignment[i][0];
            int srcIdx = assignment[i][1];
            if (tgtIdx < n)
                target = targetSelection.get(tgtIdx);
            else
                target = null;
            if (srcIdx < m)
                source = sourceSelection.get(srcIdx);
            else
                source = null;

            if (target != null && source != null) {
                // TODO: do something!
                candidates.add(new ConflationCandidate(source, target, cost[tgtIdx][srcIdx]));
            }
        }

        // add conflation layer
        try {
            conflationLayer = new ConflationLayer(targetLayer.data, candidates);
            Main.main.addLayer(conflationLayer);
        } catch (Exception ex) {
            JOptionPane.showMessageDialog(Main.parent, ex.toString(),
                    "Error adding conflation layer", JOptionPane.ERROR_MESSAGE);
        }
        tableModel = new MatchTableModel();
        resultsTable.setModel(tableModel);

        // print list of matched pairsalong with distance
        // upon selection of one pair, highlight them and draw arrow
        
        if (resultsPanel != null)
            resultsTabPanel.setSelectedComponent(resultsPanel);
    }//GEN-LAST:event_criteriaTabConflateButtonActionPerformed

    private void objectTabNextButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_objectTabNextButtonActionPerformed
        if (criteriaTabPanel != null)
            resultsTabPanel.setSelectedComponent(criteriaTabPanel);
    }//GEN-LAST:event_objectTabNextButtonActionPerformed

    private void restoreMySetButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_restoreMySetButtonActionPerformed
        if (targetLayer != null && targetDataSet != null && targetSelection != null && !targetSelection.isEmpty()) {
            Main.map.mapView.setActiveLayer(targetLayer);
            targetLayer.setVisible(true);
            targetDataSet.setSelected(targetSelection);
        }
    }//GEN-LAST:event_restoreMySetButtonActionPerformed

    private void restoreTheirSetButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_restoreTheirSetButtonActionPerformed
        if (sourceLayer != null && sourceDataSet != null && sourceSelection != null && !sourceSelection.isEmpty()) {
            Main.map.mapView.setActiveLayer(sourceLayer);
            sourceLayer.setVisible(true);
            sourceDataSet.setSelected(sourceSelection);
        }
    }//GEN-LAST:event_restoreTheirSetButtonActionPerformed

    private void freezeTargetSelectionActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_freezeTargetSelectionActionPerformed
        if (targetDataSet != null && targetDataSet == Main.main.getCurrentDataSet()) {
            targetDataSet.removeDataSetListener(this);
        }
        targetDataSet = Main.main.getCurrentDataSet();
        targetDataSet.addDataSetListener(this);
        targetLayer = Main.main.getEditLayer();
        if (targetDataSet == null || targetLayer == null) {
            JOptionPane.showMessageDialog(Main.parent, tr("No valid OSM data layer present."),
                    tr("Error freezing selection"), JOptionPane.ERROR_MESSAGE);
            return;
        }
        targetSelection = new ArrayList<OsmPrimitive>(targetDataSet.getSelected());
        if (targetSelection.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, tr("Nothing is selected, please try again."),
                    tr("Empty selection"), JOptionPane.ERROR_MESSAGE);
            return;
        }

        int numNodes = 0;
        int numWays = 0;
        int numRelations = 0;
        for (OsmPrimitive p: targetSelection) {
            switch(p.getType()) {
            case NODE: numNodes++; break;
            case WAY: numWays++; break;
            case RELATION: numRelations++; break;
            }
        }

        myLayerLabel.setText(targetLayer.getName());
        myNodeCountLabel.setText(Integer.toString(numNodes));
        myWayCountLabel.setText(Integer.toString(numWays));
        myRelationCountLabel.setText(Integer.toString(numRelations));
    }//GEN-LAST:event_freezeTargetSelectionActionPerformed

    private void freezeSourceSelectionActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_freezeSourceSelectionActionPerformed
        if (sourceDataSet != null && sourceDataSet == Main.main.getCurrentDataSet()) {
            sourceDataSet.removeDataSetListener(this);
        }
        sourceDataSet = Main.main.getCurrentDataSet();
        sourceDataSet.addDataSetListener(this);
        sourceLayer = Main.main.getEditLayer();
        if (sourceDataSet == null || sourceLayer == null) {
            JOptionPane.showMessageDialog(Main.parent, tr("No valid OSM data layer present."),
                    tr("Error freezing selection"), JOptionPane.ERROR_MESSAGE);
            return;
        }
        sourceSelection = new ArrayList<OsmPrimitive>(sourceDataSet.getSelected());
        if (sourceSelection.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, tr("Nothing is selected, please try again."),
                    tr("Empty selection"), JOptionPane.ERROR_MESSAGE);
            return;
        }

        int numNodes = 0;
        int numWays = 0;
        int numRelations = 0;
        for (OsmPrimitive p: sourceSelection) {
            switch(p.getType()) {
            case NODE: numNodes++; break;
            case WAY: numWays++; break;
            case RELATION: numRelations++; break;
            }
        }

        theirLayerLabel.setText(sourceLayer.getName());
        theirNodeCountLabel.setText(Integer.toString(numNodes));
        theirWayCountLabel.setText(Integer.toString(numWays));
        theirRelationCountLabel.setText(Integer.toString(numRelations));
    }//GEN-LAST:event_freezeSourceSelectionActionPerformed

    private void jCheckBox1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBox1ActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_jCheckBox1ActionPerformed

    private void resolveButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_resolveButtonActionPerformed
        // FIXME: perform replace geometry
        //Main.main.undoRedo.add(cmd);
    }//GEN-LAST:event_resolveButtonActionPerformed

    private void replaceGeometryButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_replaceGeometryButtonActionPerformed
        ReplaceGeometryAction rg = new ReplaceGeometryAction();
        ConflationCandidate c = conflationLayer.getSelectedCandidate();
        rg.replace(c.getSource(), c.getTarget());
    }//GEN-LAST:event_replaceGeometryButtonActionPerformed

    private void useTheirTagsButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_useTheirTagsButtonActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_useTheirTagsButtonActionPerformed

    static public class LayerListCellRenderer extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected,
                boolean cellHasFocus) {
            Layer layer = (Layer) value;
            JLabel label = (JLabel) super.getListCellRendererComponent(list, layer.getName(), index, isSelected,
                    cellHasFocus);
            Icon icon = layer.getIcon();
            label.setIcon(icon);
            label.setToolTipText(layer.getToolTipText());
            return label;
        }
    }


    public static EastNorth getCenter(OsmPrimitive prim) {
            LatLon center = prim.getBBox().getTopLeft().getCenter(prim.getBBox().getBottomRight());
            return Main.map.mapView.getProjection().latlon2eastNorth(center);
    }

    /**
     * Calculate the cost of a pair of <code>OsmPrimitive</code>'s. A
     * simple cost consisting of the Euclidean distance is used
     * now, later we can also use dissimilarity between tags.
     *
     * @param   source      the reference <code>OsmPrimitive</code>.
     * @param   target   the non-reference <code>OsmPrimitive</code>.
     */
    public double calcCost(OsmPrimitive source, OsmPrimitive target) {
        double dist;
        try {
            dist = getCenter(source).distance(getCenter(target));
        } catch (Exception e) {
            dist = 1000; // FIXME: what number to use?
        }

        // TODO: use other "distance" measures, i.e. matching tags
        return dist;
    }

    class MatchTableModel extends AbstractTableModel {

        private String[] columnNames = {"Mine", "Theirs", "Distance (m)", "Cost", "Tags"};

        public int getColumnCount() {
            return columnNames.length;
        }

        public int getRowCount() {
            return candidates.size();
        }

        @Override
        public String getColumnName(int col) {
            return columnNames[col];
        }

        public Object getValueAt(int row, int col) {
            ConflationCandidate c = candidates.get(row);
            if (col == 0)
                return c.getSource();
            else if (col == 1)
                return c.getTarget();
            else if (col == 2)
                return c.getDistance();
            else if (col == 3)
                return c.getCost();
            if (col == 4) {
                HashSet<OsmPrimitive> set = new HashSet<OsmPrimitive>();
                set.add(c.getSource());
                set.add(c.getTarget());
                TagCollection tags = TagCollection.unionOfAllPrimitives(set);
                Set<String> keys = tags.getKeysWithMultipleValues();
                if (keys.isEmpty())
                    return "No conflicts!";
                else
                    return "Conflicts!";

            }
            else
                return 0;
        }

        @Override
        public Class getColumnClass(int c) {
            return getValueAt(0, c).getClass();
        }
    }

    class ColorTableCellRenderer extends JLabel implements TableCellRenderer {
        private String columnName;

        public ColorTableCellRenderer(String column) {
            this.columnName = column;
            setOpaque(true);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Object columnValue = table.getValueAt(row, table.getColumnModel().getColumnIndex(columnName));

            if (value != null) {
                setText(value.toString());
            }
            if (isSelected) {
                setBackground(table.getSelectionBackground());
                setForeground(table.getSelectionForeground());
            } else {
                setBackground(table.getBackground());
                setForeground(table.getForeground());
                if (columnValue.equals("Conflicts!")) {
                    setBackground(java.awt.Color.red);
                }
                else {
                    setBackground(java.awt.Color.green);
                }
            }
            return this;
        }
    }

    class MatchListSelectionHandler implements ListSelectionListener {

        public void valueChanged(ListSelectionEvent e) {
            ListSelectionModel lsm = (ListSelectionModel) e.getSource();

            int firstIndex = lsm.getMinSelectionIndex();
            int lastIndex = lsm.getMaxSelectionIndex();
            boolean isAdjusting = e.getValueIsAdjusting();
            if (isAdjusting)
                return;

            // only one item selected, show tags and zoom/center map
            if (!lsm.isSelectionEmpty() && firstIndex == lastIndex && firstIndex < candidates.size()) {
                ConflationCandidate c = candidates.get(firstIndex);
                
                conflationLayer.setSelectedCandidate(c);
                
                targetDataSet.setSelected(Arrays.asList(c.getTarget(), c.getSource()));
                
                ArrayList<OsmPrimitive> sel = new ArrayList<OsmPrimitive>();
                sel.add(c.getSource());
                sel.add(c.getTarget());

                BoundingXYVisitor box = new BoundingXYVisitor();
                box.computeBoundingBox(sel);
                if (box.getBounds() == null) {
                    return;
                }
                box.enlargeBoundingBox();
                Main.map.mapView.recalculateCenterScale(box);
            }

        }
    }

    public final void refreshView() {
        // TODO: should tell what rows changed
        tableModel.fireTableDataChanged();
    }

    @Override
    public void primitivesAdded(PrimitivesAddedEvent event) {
    }

    @Override
    public void primitivesRemoved(PrimitivesRemovedEvent event) {
        List<? extends OsmPrimitive> prims = event.getPrimitives();
        for (OsmPrimitive p : prims) {
            for (ConflationCandidate c : candidates) {
                if (c.getSource().equals(p) || c.getTarget().equals(p)) {
                    candidates.remove(c);
                    break;
                }
            }
        }
        refreshView();
    }
    
    @Override
    public void tagsChanged(TagsChangedEvent event) {}
    
    @Override
    public void nodeMoved(NodeMovedEvent event) {}
        
    @Override
    public void wayNodesChanged(WayNodesChangedEvent event) {}

    @Override
    public void relationMembersChanged(RelationMembersChangedEvent event) {}

    @Override
    public void otherDatasetChange(AbstractDatasetChangedEvent event) {}

    @Override
    public void dataChanged(DataChangedEvent event) {}

    public class ConflationCandidate {
        protected OsmPrimitive source;
        protected OsmPrimitive target;
        protected double cost;
        protected double distance;
        
        public ConflationCandidate(OsmPrimitive source, OsmPrimitive target, double cost) {
            if (source == null || target == null) {
                throw new IllegalArgumentException("Invalid source or target");
            }
            this.source = source;
            this.target = target;
            this.cost = cost;
            // TODO: use distance calculated in cost function, and make sure it's in meters?
            this.distance = getCenter(source).distance(getCenter(target));
        }
        
        public OsmPrimitive getSource() {
            return source;
        }
        
        public OsmPrimitive getTarget() {
            return target;
        }

        private Object getCost() {
            return cost;
        }

        private Object getDistance() {
            return distance;
        }
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton criteriaTabConflateButton;
    private javax.swing.JPanel criteriaTabPanel;
    private javax.swing.JButton freezeMySetButton;
    private javax.swing.JButton freezeTheirSelectionButton;
    private javax.swing.JButton jButton1;
    private javax.swing.JCheckBox jCheckBox1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JLabel myLayerLabel;
    private javax.swing.JLabel myNodeCountLabel;
    private javax.swing.JLabel myRelationCountLabel;
    private javax.swing.JLabel myWayCountLabel;
    private javax.swing.JPanel nonRefSetPanel;
    private javax.swing.JButton objectTabCancelButton;
    private javax.swing.JButton objectTabNextButton;
    private javax.swing.JPanel objectTabPanel;
    private javax.swing.JPanel refSetPanel;
    private javax.swing.JButton replaceGeometryButton;
    private javax.swing.JButton resolveButton;
    private javax.swing.JButton restoreMySetButton;
    private javax.swing.JButton restoreTheirSetButton;
    private javax.swing.JPanel resultsPanel;
    private javax.swing.JTabbedPane resultsTabPanel;
    private javax.swing.JTable resultsTable;
    private javax.swing.JLabel theirLayerLabel;
    private javax.swing.JLabel theirNodeCountLabel;
    private javax.swing.JLabel theirRelationCountLabel;
    private javax.swing.JLabel theirWayCountLabel;
    private javax.swing.JButton useTheirTagsButton;
    // End of variables declaration//GEN-END:variables

}
