/*
 * Decompiled with CFR 0.152.
 */
package imageryadjust;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.Timer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageryAdjustMapMode
extends MapMode
implements MouseListener,
MouseMotionListener,
AWTEventListener,
MapFrame.MapModeChangeListener {
    boolean mouseDown;
    EastNorth prevEastNorth;
    private ImageryLayer adjustingLayer;
    private MapMode oldMapMode;
    private final TreeSet<Integer> set = new TreeSet();
    private Timer timer;
    private KeyEvent releaseEvent;

    public ImageryAdjustMapMode(MapFrame mapFrame) {
        super(I18n.tr((String)"Adjust imagery", (Object[])new Object[0]), "adjustimg", I18n.tr((String)"Adjust the position of the selected imagery layer", (Object[])new Object[0]), Shortcut.registerShortcut((String)"imageryadjust:adjustmode", (String)I18n.tr((String)"imageryadjust", (Object[])new Object[0]), (int)89, (int)3), mapFrame, ImageProvider.getCursor((String)"normal", (String)"move"));
        MapFrame.addMapModeChangeListener((MapFrame.MapModeChangeListener)this);
    }

    private List<? extends Layer> getVisibleLayers() {
        ArrayList all = new ArrayList(Main.map.mapView.getLayersOfType(ImageryLayer.class));
        Iterator it = all.iterator();
        while (it.hasNext()) {
            if (((Layer)it.next()).isVisible()) continue;
            it.remove();
        }
        return all;
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
    }

    public void enterMode() {
        super.enterMode();
        if (!this.hasImageryLayersToAdjust()) {
            this.warnNoImageryLayers();
            return;
        }
        List layers = Main.map.mapView.getLayersOfType(ImageryLayer.class);
        this.adjustingLayer = layers.size() == 1 ? (ImageryLayer)layers.get(0) : (ImageryLayer)this.askAdjustLayer(this.getVisibleLayers());
        if (this.adjustingLayer == null) {
            return;
        }
        if (!this.adjustingLayer.isVisible()) {
            this.adjustingLayer.setVisible(true);
        }
        Main.map.mapView.addMouseListener((MouseListener)this);
        Main.map.mapView.addMouseMotionListener((MouseMotionListener)this);
        this.timer = new Timer(0, new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ImageryAdjustMapMode.this.timer.stop();
                if (ImageryAdjustMapMode.this.set.remove(ImageryAdjustMapMode.this.releaseEvent.getKeyCode())) {
                    ImageryAdjustMapMode.this.doKeyReleaseEvent(ImageryAdjustMapMode.this.releaseEvent);
                }
            }
        });
        try {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public void exitMode() {
        super.exitMode();
        Main.map.mapView.removeMouseListener((MouseListener)this);
        Main.map.mapView.removeMouseMotionListener((MouseMotionListener)this);
        this.adjustingLayer = null;
        try {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        if (this.adjustingLayer.isVisible()) {
            this.prevEastNorth = Main.map.mapView.getEastNorth(e.getX(), e.getY());
            Main.map.mapView.setCursor(Cursor.getPredefinedCursor(13));
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.adjustingLayer == null || this.prevEastNorth == null) {
            return;
        }
        EastNorth eastNorth = Main.map.mapView.getEastNorth(e.getX(), e.getY());
        this.adjustingLayer.displace(eastNorth.east() - this.prevEastNorth.east(), eastNorth.north() - this.prevEastNorth.north());
        this.prevEastNorth = eastNorth;
        Main.map.mapView.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        Main.map.mapView.repaint();
        Main.map.mapView.setCursor(Cursor.getDefaultCursor());
        this.prevEastNorth = null;
    }

    private void doKeyEvent(KeyEvent keyEvent) {
    }

    private void doKeyReleaseEvent(KeyEvent releaseEvent) {
        if (releaseEvent.getKeyCode() == this.getShortcut().getKeyStroke().getKeyCode() && this.oldMapMode != null && !(this.oldMapMode instanceof ImageryAdjustMapMode)) {
            Main.map.selectMapMode(this.oldMapMode);
        }
    }

    public boolean layerIsSupported(Layer l) {
        return true;
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        if (event instanceof KeyEvent) {
            KeyEvent e = (KeyEvent)event;
            if (event.getID() == 401) {
                if (this.timer.isRunning()) {
                    this.timer.stop();
                } else if (this.set.add(e.getKeyCode())) {
                    this.doKeyEvent((KeyEvent)event);
                }
            }
            if (event.getID() == 402) {
                if (this.timer.isRunning()) {
                    this.timer.stop();
                    if (this.set.remove(e.getKeyCode())) {
                        this.doKeyReleaseEvent(e);
                    }
                } else {
                    this.releaseEvent = e;
                    this.timer.restart();
                }
            }
        }
    }

    public void mapModeChange(MapMode oldMapMode, MapMode newMapMode) {
        this.oldMapMode = oldMapMode;
    }

    protected Layer askAdjustLayer(List<? extends Layer> adjustableLayers) {
        if (adjustableLayers.size() == 0) {
            return null;
        }
        if (adjustableLayers.size() == 1) {
            return adjustableLayers.get(0);
        }
        JComboBox<Object> layerList = new JComboBox<Object>();
        layerList.setRenderer(new LayerListCellRenderer());
        layerList.setModel(new DefaultComboBoxModel<Object>(adjustableLayers.toArray()));
        layerList.setSelectedIndex(0);
        JPanel pnl = new JPanel();
        pnl.setLayout(new GridBagLayout());
        pnl.add((Component)new JLabel(I18n.tr((String)"Please select the imagery layer to adjust.", (Object[])new Object[0])), GBC.eol());
        pnl.add(layerList, GBC.eol());
        ExtendedDialog diag = new ExtendedDialog(Main.parent, I18n.tr((String)"Select imagery layer", (Object[])new Object[0]), new String[]{I18n.tr((String)"Start adjusting", (Object[])new Object[0]), I18n.tr((String)"Cancel", (Object[])new Object[0])});
        diag.setContent((Component)pnl);
        diag.setButtonIcons(new String[]{"mapmode/adjustimg", "cancel"});
        diag.showDialog();
        int decision = diag.getValue();
        if (decision != 1) {
            return null;
        }
        Layer adjustLayer = (Layer)layerList.getSelectedItem();
        return adjustLayer;
    }

    protected void warnNoImageryLayers() {
        JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"There are currently no imagery layer to adjust.", (Object[])new Object[0]), I18n.tr((String)"No layers to adjust", (Object[])new Object[0]), 2);
    }

    protected boolean hasImageryLayersToAdjust() {
        if (Main.map == null) {
            return false;
        }
        if (Main.map.mapView == null) {
            return false;
        }
        boolean b = !Main.map.mapView.getLayersOfType(ImageryLayer.class).isEmpty();
        return b;
    }

    protected void updateEnabledState() {
        this.setEnabled(this.hasImageryLayersToAdjust());
    }

    public static class LayerListCellRenderer
    extends DefaultListCellRenderer {
        protected boolean isActiveLayer(Layer layer) {
            if (Main.map == null) {
                return false;
            }
            if (Main.map.mapView == null) {
                return false;
            }
            return Main.map.mapView.getActiveLayer() == layer;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Layer layer = (Layer)value;
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, layer.getName(), index, isSelected, cellHasFocus);
            Icon icon = layer.getIcon();
            label.setIcon(icon);
            label.setToolTipText(layer.getToolTipText());
            return label;
        }
    }
}

