/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.xml;

import junit.extensions.jfcunit.JFCTestCase;
import junit.extensions.jfcunit.xml.JFCXMLConstants;
import junit.extensions.xml.IXMLTestCase;
import junit.extensions.xml.XMLException;
import junit.extensions.xml.elements.AbstractTagHandler;
import org.w3c.dom.Element;

public class AWTEventQueueTagHandler
extends AbstractTagHandler
implements JFCXMLConstants {
    public AWTEventQueueTagHandler(Element element, IXMLTestCase testCase) {
        super(element, testCase);
    }

    public void processElement() throws XMLException {
        this.validateElement();
        String action = this.getString("action");
        if ("flush".equals(action)) {
            ((JFCTestCase)this.getTestCase()).flushAWT();
        } else if ("pause".equals(action)) {
            ((JFCTestCase)this.getTestCase()).pauseAWT();
        } else if ("resume".equals(action)) {
            ((JFCTestCase)this.getTestCase()).resumeAWT();
        } else if ("sleep".equals(action)) {
            long sleep = this.getSleepTime();
            if (sleep > 0L) {
                ((JFCTestCase)this.getTestCase()).sleep(sleep);
            } else {
                while (true) {
                    ((JFCTestCase)this.getTestCase()).sleep(10000L);
                }
            }
        }
    }

    public void validateElement() throws XMLException {
        super.validateElement();
        this.checkElementTagName("awteventqueue");
        this.checkRequiredAttribute("action");
        if ("sleep".equals(this.getString("action"))) {
            this.checkRequiredAttribute("duration");
        }
    }

    protected long getSleepTime() {
        if ("forever".equals(this.getString("duration"))) {
            return -1L;
        }
        return this.getLong("duration", 300L);
    }
}

