/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.eventdata;

import java.awt.Point;
import java.text.MessageFormat;
import java.util.Vector;
import junit.extensions.jfcunit.eventdata.AbstractMouseEventData;
import junit.extensions.jfcunit.eventdata.BaseEventDataTagHandler;
import junit.extensions.jfcunit.eventdata.DragEventData;
import junit.extensions.jfcunit.xml.JFCXMLConstants;
import junit.extensions.jfcunit.xml.JFCXMLTestCase;
import junit.extensions.xml.IXMLTestCase;
import junit.extensions.xml.XMLException;
import junit.extensions.xml.XMLTagResourceBundle;
import junit.extensions.xml.XMLUtil;
import junit.extensions.xml.elements.AbstractTagHandler;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DragTagHandler
extends AbstractTagHandler
implements JFCXMLConstants {
    public DragTagHandler(Element element, IXMLTestCase testCase) {
        super(element, testCase);
    }

    public void processElement() throws XMLException {
        this.validateElement();
        AbstractMouseEventData source = null;
        AbstractMouseEventData dest = null;
        Vector<Point> points = new Vector<Point>();
        JFCXMLTestCase tc = (JFCXMLTestCase)this.getTestCase();
        NodeList children = this.getElement().getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            BaseEventDataTagHandler th;
            String type;
            if (!(children.item(i) instanceof Element)) continue;
            Element child = (Element)children.item(i);
            String name = child.getTagName();
            if (name.equals("point")) {
                String data = XMLUtil.getAttribute(child, "reference");
                MessageFormat mf = new MessageFormat("{0},{1}");
                int x = 0;
                int y = 0;
                try {
                    Object[] obs = mf.parse(data);
                    x = Integer.parseInt((String)obs[0]);
                    y = Integer.parseInt((String)obs[1]);
                }
                catch (Exception ex) {
                    throw new XMLException("Could not parse the point:" + data, (Throwable)ex, this.getElement(), this.getXMLTestCase().getPropertyCache());
                }
                points.add(new Point(x, y));
            }
            if (name.equals("destination")) {
                if (dest != null) {
                    throw new XMLException("Destination specified twice", null, this.getElement(), this.getXMLTestCase().getPropertyCache());
                }
                type = XMLUtil.getAttribute(child, "type");
                th = (BaseEventDataTagHandler)XMLTagResourceBundle.getTagHandler(child, this.getXMLTestCase(), type);
                dest = th.getEventData();
            }
            if (!name.equals("source")) continue;
            if (source != null) {
                throw new XMLException("Source specified twice", null, this.getElement(), this.getXMLTestCase().getProcedureCache());
            }
            type = XMLUtil.getAttribute(child, "type");
            th = (BaseEventDataTagHandler)XMLTagResourceBundle.getTagHandler(child, this.getXMLTestCase(), type);
            source = th.getEventData();
        }
        if (source == null) {
            throw new XMLException("Source not specified in drag.", null, this.getElement(), this.getXMLTestCase().getPropertyCache());
        }
        DragEventData dragEvent = new DragEventData(tc, source, dest);
        if (points.size() > 0) {
            dragEvent.setPoints(points.toArray(new Point[0]));
        }
        tc.getHelper().enterDragAndLeave(dragEvent);
    }

    public void validateElement() throws XMLException {
        super.validateElement();
    }

    protected final String getType() {
        return this.getString("type");
    }
}

