/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.xml.elements;

import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ListModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import junit.extensions.jfcunit.tools.Operator;
import junit.extensions.xml.IXMLTestCase;
import junit.extensions.xml.XMLException;
import junit.extensions.xml.elements.AbstractTagHandler;
import junit.framework.Assert;
import org.w3c.dom.Element;

public class IndexOfTagHandler
extends AbstractTagHandler {
    public IndexOfTagHandler(Element element, IXMLTestCase testcase) {
        super(element, testcase);
    }

    public void processElement() throws XMLException {
        this.validateElement();
        boolean debug = this.getXMLTestCase().getDebug();
        int op = this.getOperation();
        String id = this.getString("id");
        int findcount = this.getInt("index", 1);
        if (findcount <= 0) {
            findcount = 1;
        }
        String refid = this.getString("refid");
        Object o = ((IXMLTestCase)this.getTestCase()).getProperty(refid);
        String expectedval = this.getString("value");
        boolean useRegExp = this.getBoolean("useRE");
        if (useRegExp) {
            op = 0;
            if (debug) {
                System.err.println("Index of regular expression:" + expectedval + " in " + o);
            }
        } else if (debug) {
            System.err.println("Index of:" + expectedval + " in " + o);
        }
        Assert.assertNotNull((String)("Error: Unable to locate object id:" + refid), (Object)o);
        String type = this.getString("type");
        Assert.assertNotNull((String)"indexof 'type' is null", (Object)type);
        if (type.equals("tablecolumn")) {
            if (o instanceof JTable) {
                JTable table = (JTable)o;
                TableColumnModel model = table.getColumnModel();
                int columns = model.getColumnCount();
                for (int i = 0; i < columns; ++i) {
                    TableColumn tc = model.getColumn(i);
                    Object value = tc.getHeaderValue();
                    if (value == null) {
                        value = tc.getIdentifier();
                    }
                    String s = null;
                    if (value != null) {
                        s = value.toString();
                    }
                    if (!this.evaluate(op, s, expectedval)) continue;
                    if (debug) {
                        System.err.println("Match." + (findcount - 1) + " more items to find");
                    }
                    if (--findcount != 0) continue;
                    this.getXMLTestCase().addProperty(id, value);
                    this.getXMLTestCase().addProperty(id + ".index", new Integer(i));
                    return;
                }
                this.getXMLTestCase().addProperty(id, null);
                this.getXMLTestCase().addProperty(id + ".index", new Integer(-1));
                if (debug) {
                    System.err.println("No match found");
                }
            } else {
                Assert.fail((String)"refid must point to a JTable");
            }
        } else if (type.equals("tab")) {
            if (o instanceof JTabbedPane) {
                JTabbedPane tab = (JTabbedPane)o;
                int count = tab.getTabCount();
                for (int i = 0; i < count; ++i) {
                    String title = tab.getTitleAt(i);
                    if (!this.evaluate(op, title, expectedval)) continue;
                    if (debug) {
                        System.err.println("Match." + (findcount - 1) + " more items to find");
                    }
                    if (--findcount != 0) continue;
                    this.getXMLTestCase().addProperty(id, title);
                    this.getXMLTestCase().addProperty(id + ".index", new Integer(i));
                    return;
                }
                this.getXMLTestCase().addProperty(id, null);
                this.getXMLTestCase().addProperty(id + ".index", new Integer(-1));
                if (debug) {
                    System.err.println("No match found");
                }
            } else {
                Assert.fail((String)"refid must point to JTabbedPane");
            }
        } else if (type.equals("tablecell")) {
            if (o instanceof JTable) {
                int endcol;
                int endrow;
                JTable table = (JTable)o;
                int startrow = this.getInt("row", -1);
                int startcol = this.getInt("column", -1);
                if (startrow == -1) {
                    startrow = 0;
                    endrow = table.getRowCount();
                } else {
                    endrow = startrow + 1;
                }
                if (startcol == -1) {
                    startcol = 0;
                    endcol = table.getColumnCount();
                } else {
                    endcol = startcol + 1;
                }
                int rowindex = 0;
                int colindex = 0;
                for (rowindex = startrow; rowindex < endrow; ++rowindex) {
                    for (colindex = startcol; colindex < endcol; ++colindex) {
                        Object cell = table.getValueAt(rowindex, colindex);
                        String tableval = null;
                        if (cell != null) {
                            tableval = cell.toString();
                        }
                        if (debug) {
                            System.err.println("Evaluate row=" + rowindex + " column=" + colindex + " value=" + tableval);
                        }
                        if (!this.evaluate(op, tableval, expectedval)) continue;
                        if (debug) {
                            System.err.println("Match " + (findcount - 1) + "more items to find");
                        }
                        if (--findcount != 0) continue;
                        this.getXMLTestCase().addProperty(id, cell);
                        this.getXMLTestCase().addProperty(id + ".row", new Integer(rowindex));
                        this.getXMLTestCase().addProperty(id + ".column", new Integer(colindex));
                        return;
                    }
                }
                if (debug) {
                    System.err.println("No match found");
                }
                this.getXMLTestCase().addProperty(id, null);
                this.getXMLTestCase().addProperty(id + ".column", new Integer(-1));
                this.getXMLTestCase().addProperty(id + ".row", new Integer(-1));
            } else {
                Assert.fail((String)("Invalid Table type:" + o.toString()));
            }
        } else if (type.equals("listitem")) {
            ListModel model = null;
            if (o instanceof JList) {
                model = ((JList)o).getModel();
            } else if (o instanceof JComboBox) {
                model = ((JComboBox)o).getModel();
            }
            boolean found = false;
            int rowindex = 0;
            for (rowindex = 0; rowindex < model.getSize() && !found; ++rowindex) {
                Object item = model.getElementAt(rowindex);
                String listitem = null;
                if (item != null) {
                    listitem = item.toString();
                }
                if (debug) {
                    System.err.println("Evaluate index=" + rowindex + " value=" + listitem);
                }
                if (!this.evaluate(op, listitem, expectedval)) continue;
                if (debug) {
                    System.err.println("Match." + (findcount - 1) + " more items to find");
                }
                if (--findcount != 0) continue;
                this.getXMLTestCase().addProperty(id, item);
                this.getXMLTestCase().addProperty(id + ".index", new Integer(rowindex));
                return;
            }
            if (debug) {
                System.err.println("List item match not found.");
            }
            this.getXMLTestCase().addProperty(id, null);
            this.getXMLTestCase().addProperty(id + ".index", new Integer(-1));
        } else {
            Assert.fail((String)("Unknown object type: " + o));
        }
    }

    public void validateElement() throws XMLException {
        super.validateElement();
        this.checkRequiredAttribute("id");
        this.checkRequiredAttribute("refid");
        this.checkRequiredAttribute("type");
        this.checkRequiredAttribute("value");
    }

    protected boolean getCaseIndependent() {
        return this.getBoolean("caseindependent", true);
    }

    protected int getOperation() {
        String operation = this.getString("operation");
        if (operation == null) {
            return 3;
        }
        return Operator.Operation.getOperation(operation);
    }

    private boolean evaluate(int operation, String tableval, String expectedval) {
        return Operator.evaluate(tableval, expectedval, operation, this.getCaseIndependent());
    }
}

