/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.lang.reflect.Constructor;
import junit.extensions.jfcunit.TestHelper;
import junit.extensions.jfcunit.keyboard.JFCKeyStroke;

public final class JFCTestHelper
extends TestHelper {
    private static Point s_last = new Point(0, 0);
    private EventQueue m_queue = Toolkit.getDefaultToolkit().getSystemEventQueue();
    private boolean m_lastPopup = false;
    private int m_lastClicks;
    private int m_lastMouseModifiers = 0;
    private long m_lastPressed = 0L;
    static /* synthetic */ Class class$java$awt$Component;

    protected void keyPressed(Component ultimate, JFCKeyStroke stroke) {
        this.postEvent(new KeyEvent(ultimate, 401, System.currentTimeMillis(), stroke.getModifiers(), stroke.getKeyCode(), stroke.getKeyChar()));
    }

    protected void keyReleased(Component ultimate, JFCKeyStroke stroke) {
        if (stroke.isTyped()) {
            this.postEvent(new KeyEvent(ultimate, 400, System.currentTimeMillis(), stroke.getModifiers(), 0, stroke.getKeyChar()));
        }
        this.postEvent(new KeyEvent(ultimate, 402, System.currentTimeMillis(), stroke.getModifiers(), stroke.getKeyCode(), stroke.getKeyChar()));
    }

    protected void mouseMoved(Component ultimate, int x, int y) {
        Point dest = new Point(x, y);
        dest.translate(-ultimate.getLocationOnScreen().x, -ultimate.getLocationOnScreen().y);
        int mouseEventType = 503;
        if (this.m_lastPressed != 0L) {
            mouseEventType = 506;
        }
        while (JFCTestHelper.s_last.x != dest.x || JFCTestHelper.s_last.y != dest.y) {
            s_last = JFCTestHelper.calcNextPoint(s_last, dest, this.getStep());
            this.postEvent(new MouseEvent(ultimate, mouseEventType, System.currentTimeMillis(), this.m_lastMouseModifiers, JFCTestHelper.s_last.x, JFCTestHelper.s_last.y, 0, this.m_lastPopup));
        }
    }

    protected void mousePressed(Component ultimate, int modifiers, int click, boolean isPopupTrigger) {
        this.m_lastPressed = System.currentTimeMillis();
        this.m_lastPopup = isPopupTrigger;
        this.m_lastMouseModifiers = modifiers;
        if (modifiers != 0) {
            this.postEvent(new MouseEvent(ultimate, 501, this.m_lastPressed, modifiers, JFCTestHelper.s_last.x, JFCTestHelper.s_last.y, click, isPopupTrigger));
        }
    }

    protected void mouseReleased(Component ultimate, int modifiers, int click, boolean isPopupTrigger) {
        this.m_lastMouseModifiers = modifiers;
        this.m_lastPopup = isPopupTrigger;
        this.m_lastClicks = click;
        if (modifiers != 0) {
            this.postEvent(new MouseEvent(ultimate, 502, System.currentTimeMillis(), modifiers, JFCTestHelper.s_last.x, JFCTestHelper.s_last.y, click, isPopupTrigger));
            long delta = this.m_lastPressed - System.currentTimeMillis();
            if (click > 0 && delta < 100L) {
                this.postEvent(new MouseEvent(ultimate, 500, System.currentTimeMillis(), modifiers, JFCTestHelper.s_last.x, JFCTestHelper.s_last.y, click, isPopupTrigger));
            }
        }
        this.m_lastPressed = 0L;
    }

    protected void mouseWheel(Component ultimate, int amount, int wheelRotation) {
        try {
            Class<?> mouseWheelEventClass = Class.forName("java.awt.event.MouseWheelEvent");
            Constructor<?> constructor = mouseWheelEventClass.getConstructor(class$java$awt$Component == null ? (class$java$awt$Component = JFCTestHelper.class$("java.awt.Component")) : class$java$awt$Component, Integer.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            int scrollType = 0;
            int eventId = mouseWheelEventClass.getField("MOUSE_WHEEL").getInt(null);
            scrollType = (this.m_lastMouseModifiers & 1) > 1 ? mouseWheelEventClass.getField("WHEEL_BLOCK_SCROLL").getInt(null) : mouseWheelEventClass.getField("WHEEL_UNIT_SCROLL").getInt(null);
            this.postEvent((AWTEvent)constructor.newInstance(ultimate, new Integer(eventId), new Long(System.currentTimeMillis()), new Integer(this.m_lastMouseModifiers), new Integer(JFCTestHelper.s_last.x), new Integer(JFCTestHelper.s_last.y), new Integer(this.m_lastClicks), new Boolean(this.m_lastPopup), new Integer(scrollType), new Integer(amount), new Integer(wheelRotation)));
        }
        catch (Exception ex) {
            throw new RuntimeException("Mouse Wheel not supported" + ex.toString());
        }
    }

    private void postEvent(AWTEvent evt) {
        this.m_queue.postEvent(evt);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

