/*
 * Decompiled with CFR 0.152.
 */
package wmsturbochallenge;

import java.util.Timer;
import java.util.TimerTask;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;

class engine {
    protected double speed;
    protected double rpm = 0.0;
    protected int n;
    protected SourceDataLine output = null;
    protected long frames_written;
    protected Timer tick = new Timer();
    protected static final int S_RATE = 44100;
    protected static final int MIN_BUFFER = 4096;
    protected static final double volume = 0.3;

    public void start() {
        this.rpm = 0.3;
        this.speed = 0.0;
        this.n = 0;
        if (this.output != null) {
            this.stop();
        }
        AudioFormat output_format = new AudioFormat(44100.0f, 16, 1, true, true);
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, output_format);
        try {
            this.output = (SourceDataLine)AudioSystem.getLine(info);
            this.output.open(output_format);
            this.output.start();
            this.frames_written = 0L;
            this.reschedule(0L);
        }
        catch (Exception e) {
            this.output = null;
            System.out.println("Audio not available: " + e.getClass().getSimpleName());
        }
    }

    public void stop() {
        this.rpm = 0.0;
        this.n = 0;
        if (this.output == null) {
            return;
        }
        this.tick.cancel();
        this.tick.purge();
        this.output.stop();
        this.output.flush();
        this.output.close();
        this.output = null;
    }

    public void set_speed(double speed) {
        double new_speed = Math.abs(speed);
        double accel = new_speed - this.speed;
        this.speed = new_speed;
        if (accel > 0.05) {
            accel = 0.05;
        } else if (accel < -0.05) {
            accel = -0.05;
        }
        this.rpm += accel;
        if (accel > 0.0 && this.rpm > 1.0 + (double)this.n * 0.2 && speed > 0.0) {
            this.rpm = 0.3 + (double)this.n * 0.2;
            ++this.n;
        } else if (accel < 0.0 && this.rpm < 0.3) {
            if (this.n > 0) {
                this.rpm = 0.7 + (double)this.n * 0.1;
                --this.n;
            } else {
                this.rpm = 0.2;
            }
        }
        if (speed < 2.0) {
            this.n = 0;
        }
    }

    public boolean is_on() {
        return this.output != null;
    }

    protected void reschedule(long frames) {
        long delay = (this.frames_written - frames - 2048L) * 1000L / 44100L;
        if (delay < 0L) {
            delay = 0L;
        }
        this.tick.schedule((TimerTask)new audio_task(), delay);
    }

    protected class audio_task
    extends TimerTask {
        protected audio_task() {
        }

        public void run() {
            if (engine.this.output == null) {
                return;
            }
            long frames_current = engine.this.output.getLongFramePosition();
            if (frames_current < engine.this.frames_written - 8192L) {
                engine.this.reschedule(frames_current);
                return;
            }
            double freq = (engine.this.rpm - 0.1) * 160.0;
            int wavelen = (int)(44100.0 / freq);
            int bufferlen = 4096 - 4096 % wavelen + wavelen;
            int value = 9830;
            byte[] buffer = new byte[bufferlen *= 2];
            int b = 0;
            while (b < bufferlen) {
                int j;
                for (j = wavelen / 2; j > 0; --j) {
                    buffer[b++] = (byte)(value >> 8);
                    buffer[b++] = (byte)(value & 0xFF);
                }
                value = 65536 - value;
                for (j = wavelen - wavelen / 2; j > 0; --j) {
                    buffer[b++] = (byte)(value >> 8);
                    buffer[b++] = (byte)(value & 0xFF);
                }
                value = 65536 - value;
            }
            engine.this.frames_written += (long)(engine.this.output.write(buffer, 0, bufferlen) / 2);
            engine.this.reschedule(frames_current);
        }
    }
}

