/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.housenumbertool;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionManager;
import org.openstreetmap.josm.plugins.housenumbertool.CancelDialogListener;
import org.openstreetmap.josm.plugins.housenumbertool.Dto;
import org.openstreetmap.josm.plugins.housenumbertool.MyFocusListener;
import org.openstreetmap.josm.plugins.housenumbertool.OkDialogListener;
import org.openstreetmap.josm.plugins.housenumbertool.SimpleTagTableModel;
import org.openstreetmap.josm.plugins.housenumbertool.TopPanel;

public class TagDialog
extends JDialog {
    public static final String TAG_BUILDING = "building";
    public static final String TAG_ADDR_COUNTRY = "addr:country";
    public static final String TAG_ADDR_STATE = "addr:state";
    public static final String TAG_ADDR_CITY = "addr:city";
    public static final String TAG_ADDR_POSTCODE = "addr:postcode";
    public static final String TAG_ADDR_HOUSENUMBER = "addr:housenumber";
    public static final String TAG_ADDR_STREET = "addr:street";
    private static final long serialVersionUID = 6414385452106276923L;
    private static final Logger logger = Logger.getLogger(TagDialog.class.getName());
    private SimpleTagTableModel model;
    private String pluginDir;
    private AutoCompletionManager acm;
    private OsmPrimitive selection;
    public static final String TEMPLATE_DATA = "/template.data";
    private JTextField country;
    private JTextField city;
    private JTextField postcode;
    private JTextField street;
    private JTextField housnumber;
    private JCheckBox buildingEnabled;
    private JCheckBox countryEnabled;
    private JCheckBox cityEnabled;
    private JCheckBox zipEnabled;
    private JCheckBox streetEnabled;
    private JCheckBox housenumberEnabled;
    private JTextField state;
    private JCheckBox stateEnabled;

    public TagDialog(String pluginDir, OsmPrimitive p_selection) {
        this.pluginDir = pluginDir;
        this.selection = p_selection;
        this.model = new SimpleTagTableModel();
        this.acm = this.selection.getDataSet().getAutoCompletionManager();
        Dto dto = this.loadDto();
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setLayout(new BorderLayout(5, 5));
        JPanel centerPanel = new JPanel();
        JPanel editPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.buildingEnabled = new JCheckBox(TAG_BUILDING);
        this.buildingEnabled.setSelected(dto.isSaveBuilding());
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        editPanel.add((Component)this.buildingEnabled, c);
        JTextField building = new JTextField();
        building.setPreferredSize(new Dimension(200, 20));
        building.setText("yes");
        building.setEditable(false);
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        editPanel.add((Component)building, c);
        this.countryEnabled = new JCheckBox(TAG_ADDR_COUNTRY);
        this.countryEnabled.setSelected(dto.isSaveCountry());
        c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 0.0;
        editPanel.add((Component)this.countryEnabled, c);
        this.country = new JTextField();
        this.country.addFocusListener(new MyFocusListener(this.acm, this.model, TAG_ADDR_COUNTRY));
        this.country.setPreferredSize(new Dimension(200, 20));
        this.country.setText(dto.getCountry());
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 1;
        c.weightx = 1.0;
        editPanel.add((Component)this.country, c);
        this.stateEnabled = new JCheckBox(TAG_ADDR_STATE);
        this.stateEnabled.setSelected(dto.isSaveState());
        c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 2;
        c.weightx = 0.0;
        editPanel.add((Component)this.stateEnabled, c);
        this.state = new JTextField();
        this.state.addFocusListener(new MyFocusListener(this.acm, this.model, TAG_ADDR_STATE));
        this.state.setPreferredSize(new Dimension(200, 20));
        this.state.setText(dto.getState());
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 2;
        c.weightx = 1.0;
        editPanel.add((Component)this.state, c);
        this.cityEnabled = new JCheckBox(TAG_ADDR_CITY);
        this.cityEnabled.setSelected(dto.isSaveCity());
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 3;
        c.weightx = 0.0;
        editPanel.add((Component)this.cityEnabled, c);
        this.city = new JTextField();
        this.city.addFocusListener(new MyFocusListener(this.acm, this.model, TAG_ADDR_CITY));
        this.city.setPreferredSize(new Dimension(200, 20));
        this.city.setText(dto.getCity());
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 3;
        c.weightx = 1.0;
        editPanel.add((Component)this.city, c);
        this.zipEnabled = new JCheckBox(TAG_ADDR_POSTCODE);
        this.zipEnabled.setSelected(dto.isSavePostcode());
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 4;
        c.weightx = 0.0;
        editPanel.add((Component)this.zipEnabled, c);
        this.postcode = new JTextField();
        this.postcode.addFocusListener(new MyFocusListener(this.acm, this.model, TAG_ADDR_POSTCODE));
        this.postcode.setPreferredSize(new Dimension(200, 20));
        this.postcode.setText(dto.getPostcode());
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 4;
        c.weightx = 1.0;
        editPanel.add((Component)this.postcode, c);
        this.streetEnabled = new JCheckBox(TAG_ADDR_STREET);
        this.streetEnabled.setSelected(dto.isSaveStreet());
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 5;
        c.weightx = 0.0;
        editPanel.add((Component)this.streetEnabled, c);
        this.street = new JTextField();
        this.street.setPreferredSize(new Dimension(200, 20));
        this.street.addFocusListener(new MyFocusListener(this.acm, this.model, TAG_ADDR_STREET));
        this.street.setText(dto.getStreet());
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 5;
        c.weightx = 1.0;
        editPanel.add((Component)this.street, c);
        this.housenumberEnabled = new JCheckBox(TAG_ADDR_HOUSENUMBER);
        this.housenumberEnabled.setSelected(dto.isSaveHousenumber());
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 6;
        c.weightx = 0.0;
        editPanel.add((Component)this.housenumberEnabled, c);
        this.housnumber = new JTextField();
        this.housnumber.addFocusListener(new MyFocusListener(this.acm, this.model, TAG_ADDR_HOUSENUMBER));
        this.housnumber.setPreferredSize(new Dimension(200, 20));
        this.housnumber.setText(dto.getHousenumber());
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 6;
        c.weightx = 1.0;
        editPanel.add((Component)this.housnumber, c);
        JPanel panelEast = new JPanel(new GridLayout(0, 1));
        JTable table = new JTable(this.model);
        table.setPreferredScrollableViewportSize(new Dimension(300, 200));
        table.addMouseListener(new MouseListener(){

            public void mouseReleased(MouseEvent e) {
                JTable target = (JTable)e.getSource();
                int row = target.getSelectedRow();
                String selectedValue = (String)TagDialog.this.model.getValueAt(row, 0);
                String tag = TagDialog.this.model.getDisplayTag();
                if (tag.equals(TagDialog.TAG_ADDR_COUNTRY)) {
                    TagDialog.this.country.setText(selectedValue);
                }
                if (tag.equals(TagDialog.TAG_ADDR_STATE)) {
                    TagDialog.this.state.setText(selectedValue);
                } else if (tag.equals(TagDialog.TAG_ADDR_CITY)) {
                    TagDialog.this.city.setText(selectedValue);
                } else if (tag.equals(TagDialog.TAG_ADDR_POSTCODE)) {
                    TagDialog.this.postcode.setText(selectedValue);
                } else if (tag.equals(TagDialog.TAG_ADDR_HOUSENUMBER)) {
                    TagDialog.this.housnumber.setText(selectedValue);
                } else if (tag.equals(TagDialog.TAG_ADDR_STREET)) {
                    TagDialog.this.street.setText(selectedValue);
                }
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseClicked(MouseEvent e) {
            }
        });
        JScrollPane scrollPane = new JScrollPane(table);
        table.setFillsViewportHeight(true);
        panelEast.add(scrollPane);
        JButton btnOk = new JButton("OK");
        btnOk.addActionListener(new OkDialogListener(this, pluginDir){

            public void actionPerformed(ActionEvent e) {
                Dto dto = new Dto();
                dto.setSaveBuilding(TagDialog.this.buildingEnabled.isSelected());
                dto.setSaveCity(TagDialog.this.cityEnabled.isSelected());
                dto.setSaveCountry(TagDialog.this.countryEnabled.isSelected());
                dto.setSaveState(TagDialog.this.stateEnabled.isSelected());
                dto.setSaveHousenumber(TagDialog.this.housenumberEnabled.isSelected());
                dto.setSavePostcode(TagDialog.this.zipEnabled.isSelected());
                dto.setSaveStreet(TagDialog.this.streetEnabled.isSelected());
                dto.setCity(TagDialog.this.city.getText());
                dto.setCountry(TagDialog.this.country.getText());
                dto.setHousenumber(TagDialog.this.housnumber.getText());
                dto.setPostcode(TagDialog.this.postcode.getText());
                dto.setStreet(TagDialog.this.street.getText());
                dto.setState(TagDialog.this.state.getText());
                this.updateJOSMSelection(TagDialog.this.selection, dto);
                this.saveDto(dto);
                this.tagDialog.setVisible(false);
            }
        });
        JButton btnCancel = new JButton("Cancel");
        btnCancel.addActionListener(new CancelDialogListener(this));
        JPanel bp = new JPanel();
        bp.add(btnOk);
        bp.add(btnCancel);
        centerPanel.add(editPanel);
        this.getContentPane().add((Component)new TopPanel(), "North");
        this.getContentPane().add((Component)centerPanel, "Center");
        this.getContentPane().add((Component)panelEast, "East");
        this.getContentPane().add((Component)bp, "Last");
        ActionListener listener = new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                TagDialog.this.setVisible(false);
                TagDialog.this.dispose();
            }
        };
        KeyStroke keyStrokeESC = KeyStroke.getKeyStroke(27, 0, true);
        this.getRootPane().registerKeyboardAction(listener, keyStrokeESC, 1);
        this.pack();
        this.setLocationRelativeTo(null);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TagDialog.this.housnumber.requestFocus();
                TagDialog.this.housnumber.selectAll();
            }
        });
    }

    private Dto loadDto() {
        Dto dto = new Dto();
        try {
            File fileName = new File(this.pluginDir + TEMPLATE_DATA);
            if (fileName.exists()) {
                FileInputStream file = new FileInputStream(fileName);
                ObjectInputStream o = new ObjectInputStream(file);
                dto = (Dto)o.readObject();
                o.close();
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage());
        }
        return dto;
    }
}

