/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.housenumbertool;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.plugins.housenumbertool.Dto;
import org.openstreetmap.josm.plugins.housenumbertool.TagDialog;
import org.openstreetmap.josm.tools.I18n;

class OkDialogListener
implements ActionListener {
    private static final Logger logger = Logger.getLogger(OkDialogListener.class.getName());
    TagDialog tagDialog;
    String pluginDir;

    public OkDialogListener(TagDialog tagDialog, String pluginDir) {
        this.tagDialog = tagDialog;
        this.pluginDir = pluginDir;
    }

    public void actionPerformed(ActionEvent e) {
    }

    protected void saveDto(Dto dto) {
        try {
            File path = new File(this.pluginDir);
            path.mkdirs();
            File fileName = new File(this.pluginDir + "/template.data");
            FileOutputStream file = new FileOutputStream(fileName);
            ObjectOutputStream o = new ObjectOutputStream(file);
            o.writeObject(dto);
            o.close();
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage());
        }
    }

    protected void updateJOSMSelection(OsmPrimitive selection, Dto dto) {
        ChangePropertyCommand command;
        String value;
        ArrayList<ChangePropertyCommand> commands = new ArrayList<ChangePropertyCommand>();
        if (dto.isSaveBuilding() && ((value = selection.get("building")) == null || value != null && !value.equals("yes"))) {
            command = new ChangePropertyCommand(selection, "building", "yes");
            commands.add(command);
        }
        if (dto.isSaveCity() && ((value = selection.get("addr:city")) == null || value != null && !value.equals(dto.getCity()))) {
            command = new ChangePropertyCommand(selection, "addr:city", dto.getCity());
            commands.add(command);
        }
        if (dto.isSaveCountry() && ((value = selection.get("addr:country")) == null || value != null && !value.equals(dto.getCountry()))) {
            command = new ChangePropertyCommand(selection, "addr:country", dto.getCountry());
            commands.add(command);
        }
        if (dto.isSaveHousenumber() && ((value = selection.get("addr:housenumber")) == null || value != null && !value.equals(dto.getHousenumber()))) {
            command = new ChangePropertyCommand(selection, "addr:housenumber", dto.getHousenumber());
            commands.add(command);
        }
        if (dto.isSavePostcode() && ((value = selection.get("addr:postcode")) == null || value != null && !value.equals(dto.getPostcode()))) {
            command = new ChangePropertyCommand(selection, "addr:postcode", dto.getPostcode());
            commands.add(command);
        }
        if (dto.isSaveStreet() && ((value = selection.get("addr:street")) == null || value != null && !value.equals(dto.getStreet()))) {
            command = new ChangePropertyCommand(selection, "addr:street", dto.getStreet());
            commands.add(command);
        }
        if (dto.isSaveState() && ((value = selection.get("addr:state")) == null || value != null && !value.equals(dto.getState()))) {
            command = new ChangePropertyCommand(selection, "addr:state", dto.getState());
            commands.add(command);
        }
        if (commands.size() > 0) {
            SequenceCommand sequenceCommand = new SequenceCommand(I18n.trn((String)"Updating properties of up to {0} object", (String)"Updating properties of up to {0} objects", (long)commands.size(), (Object[])new Object[]{commands.size()}), commands);
            Main.main.undoRedo.add((Command)sequenceCommand);
        }
    }
}

