/*
 * Decompiled with CFR 0.152.
 */
package net.boplicity.xmleditor;

import java.awt.Color;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.PlainView;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;

public class XmlView
extends PlainView {
    private static HashMap<Pattern, Color> patternColors;
    private static String GENERIC_XML_NAME;
    private static String TAG_PATTERN;
    private static String TAG_END_PATTERN;
    private static String TAG_ATTRIBUTE_PATTERN;
    private static String TAG_ATTRIBUTE_VALUE;
    private static String TAG_COMMENT;
    private static String TAG_CDATA;

    public XmlView(Element element) {
        super(element);
        this.getDocument().putProperty("tabSize", 4);
    }

    @Override
    protected int drawUnselectedText(Graphics graphics, int x, int y, int p0, int p1) throws BadLocationException {
        Document doc = this.getDocument();
        String text = doc.getText(p0, p1 - p0);
        Segment segment = this.getLineBuffer();
        TreeMap<Integer, Integer> startMap = new TreeMap<Integer, Integer>();
        TreeMap<Integer, Color> colorMap = new TreeMap<Integer, Color>();
        for (Map.Entry<Pattern, Color> entry : patternColors.entrySet()) {
            Matcher matcher = entry.getKey().matcher(text);
            while (matcher.find()) {
                startMap.put(matcher.start(1), matcher.end());
                colorMap.put(matcher.start(1), entry.getValue());
            }
        }
        int i = 0;
        for (Map.Entry entry : startMap.entrySet()) {
            int start = (Integer)entry.getKey();
            int end = (Integer)entry.getValue();
            if (i < start) {
                graphics.setColor(Color.black);
                doc.getText(p0 + i, start - i, segment);
                x = Utilities.drawTabbedText(segment, x, y, graphics, (TabExpander)this, i);
            }
            graphics.setColor((Color)colorMap.get(start));
            i = end;
            doc.getText(p0 + start, i - start, segment);
            x = Utilities.drawTabbedText(segment, x, y, graphics, (TabExpander)this, start);
        }
        if (i < text.length()) {
            graphics.setColor(Color.black);
            doc.getText(p0 + i, text.length() - i, segment);
            x = Utilities.drawTabbedText(segment, x, y, graphics, (TabExpander)this, i);
        }
        return x;
    }

    static {
        GENERIC_XML_NAME = "[A-Za-z]+[A-Za-z0-9\\-_]*(:[A-Za-z]+[A-Za-z0-9\\-_]+)?";
        TAG_PATTERN = "(</?" + GENERIC_XML_NAME + ")";
        TAG_END_PATTERN = "(>|/>)";
        TAG_ATTRIBUTE_PATTERN = "(" + GENERIC_XML_NAME + ")\\w*\\=";
        TAG_ATTRIBUTE_VALUE = "\\w*\\=\\w*(\"[^\"]*\")";
        TAG_COMMENT = "(<\\!--[\\w ]*-->)";
        TAG_CDATA = "(<\\!\\[CDATA\\[.*\\]\\]>)";
        patternColors = new LinkedHashMap<Pattern, Color>();
        patternColors.put(Pattern.compile(TAG_PATTERN), new Color(63, 127, 127));
        patternColors.put(Pattern.compile(TAG_CDATA), Color.GRAY);
        patternColors.put(Pattern.compile(TAG_ATTRIBUTE_PATTERN), new Color(127, 0, 127));
        patternColors.put(Pattern.compile(TAG_END_PATTERN), new Color(63, 127, 127));
        patternColors.put(Pattern.compile(TAG_ATTRIBUTE_VALUE), new Color(42, 0, 255));
        patternColors.put(Pattern.compile(TAG_COMMENT), Color.BLUE);
    }
}

