/*
 * Decompiled with CFR 0.152.
 */
package public_transport;

import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;
import public_transport.RoutePatternAction;

public class ItineraryTableModel
extends DefaultTableModel
implements TableModelListener {
    public Vector<Way> ways = new Vector();
    public boolean inEvent = false;

    public boolean isCellEditable(int row, int column) {
        if (column != 1) {
            return false;
        }
        return this.ways.elementAt(row) != null;
    }

    public void addRow(Object[] obj) {
        this.ways.addElement(null);
        super.addRow(obj);
    }

    public void insertRow(int insPos, Object[] obj) {
        if (insPos == -1) {
            this.ways.addElement(null);
            super.addRow(obj);
        } else {
            this.ways.insertElementAt(null, insPos);
            super.insertRow(insPos, obj);
        }
    }

    public void addRow(Way way, String role) {
        this.insertRow(-1, way, role);
    }

    public void insertRow(int insPos, Way way, String role) {
        Object[] buf = new String[]{"", ""};
        String curName = way.get("name");
        buf[0] = way.isIncomplete() ? I18n.tr((String)"[incomplete]", (Object[])new Object[0]) : (way.getNodesCount() < 1 ? I18n.tr((String)"[empty way]", (Object[])new Object[0]) : (curName != null ? curName : I18n.tr((String)"[ID] {0}", (Object[])new Object[]{new Long(way.getId()).toString()})));
        buf[1] = role;
        if (insPos == -1) {
            this.ways.addElement(way);
            super.addRow(buf);
        } else {
            this.ways.insertElementAt(way, insPos);
            super.insertRow(insPos, buf);
        }
    }

    public void clear() {
        this.ways.clear();
        super.setRowCount(0);
    }

    public void cleanupGaps() {
        this.inEvent = true;
        Node lastNode = null;
        for (int i = 0; i < this.getRowCount() && (this.ways.elementAt(i) != null || ++i < this.getRowCount()); ++i) {
            while (this.ways.elementAt(i) == null && (i == 0 || this.ways.elementAt(i - 1) == null)) {
                this.ways.removeElementAt(i);
                this.removeRow(i);
                if (i < this.getRowCount()) continue;
            }
            if (i >= this.getRowCount()) break;
            boolean gapRequired = this.gapNecessary(this.ways.elementAt(i), (String)this.getValueAt(i, 1), lastNode);
            if (i > 0 && !gapRequired && this.ways.elementAt(i - 1) == null) {
                this.ways.removeElementAt(i - 1);
                this.removeRow(i - 1);
                --i;
            } else if (i > 0 && gapRequired && this.ways.elementAt(i - 1) != null) {
                Object[] buf = new String[]{"", ""};
                buf[0] = I18n.tr((String)"[gap]", (Object[])new Object[0]);
                this.insertRow(i, buf);
                ++i;
            }
            lastNode = this.getLastNode(this.ways.elementAt(i), (String)this.getValueAt(i, 1));
        }
        while (this.getRowCount() > 0 && this.ways.elementAt(this.getRowCount() - 1) == null) {
            this.ways.removeElementAt(this.getRowCount() - 1);
            this.removeRow(this.getRowCount() - 1);
        }
        this.inEvent = false;
    }

    public void tableChanged(TableModelEvent e) {
        if (e.getType() == 0) {
            if (this.inEvent) {
                return;
            }
            this.cleanupGaps();
            RoutePatternAction.rebuildWays();
        }
    }

    private Node getLastNode(Way way, String role) {
        if (way == null || way.isIncomplete() || way.getNodesCount() < 1) {
            return null;
        }
        if ("backward".equals(role)) {
            return way.getNode(0);
        }
        return way.getNode(way.getNodesCount() - 1);
    }

    private boolean gapNecessary(Way way, String role, Node lastNode) {
        if (way != null && !way.isIncomplete() && way.getNodesCount() >= 1) {
            Node firstNode = null;
            firstNode = "backward".equals(role) ? way.getNode(way.getNodesCount() - 1) : way.getNode(0);
            if (lastNode != null && !lastNode.equals((Object)firstNode)) {
                return true;
            }
        }
        return false;
    }
}

