/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapdust.gui.component.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.plugins.mapdust.gui.component.panel.MapdustAddressPanel;
import org.openstreetmap.josm.plugins.mapdust.gui.component.panel.MapdustBugDetailsPanel;
import org.openstreetmap.josm.plugins.mapdust.gui.component.panel.MapdustCommentsPanel;
import org.openstreetmap.josm.plugins.mapdust.gui.component.panel.MapdustDescriptionPanel;
import org.openstreetmap.josm.plugins.mapdust.gui.component.panel.MapdustHelpPanel;
import org.openstreetmap.josm.plugins.mapdust.gui.component.util.ComponentUtil;
import org.openstreetmap.josm.plugins.mapdust.gui.observer.MapdustBugDetailsObserver;
import org.openstreetmap.josm.plugins.mapdust.service.MapdustServiceHandler;
import org.openstreetmap.josm.plugins.mapdust.service.MapdustServiceHandlerException;
import org.openstreetmap.josm.plugins.mapdust.service.value.Address;
import org.openstreetmap.josm.plugins.mapdust.service.value.MapdustBug;
import org.openstreetmap.josm.plugins.mapdust.service.value.MapdustComment;
import org.openstreetmap.josm.tools.I18n;

public class MapdustBugPropertiesPanel
extends JPanel
implements MapdustBugDetailsObserver {
    private static final long serialVersionUID = 5320232823004570279L;
    private MapdustBugDetailsPanel detailsPanel;
    private MapdustAddressPanel addressPanel;
    private MapdustDescriptionPanel descriptionPanel;
    private MapdustCommentsPanel commentsPanel;
    private MapdustHelpPanel helpPanel;
    private JScrollPane cmpAddress;
    private JScrollPane cmpDetails;
    private JTabbedPane mainPanel;

    public MapdustBugPropertiesPanel(MapdustBug mapdustBug) {
        this.setLayout(new BorderLayout());
        this.setName("Bug Details");
        this.addComponents(mapdustBug);
    }

    public void showDetails(MapdustBug mapdustBug) {
        MapdustBug selectedBug = mapdustBug;
        if (mapdustBug != null && mapdustBug.getNumberOfComments() > 0) {
            Long id = mapdustBug.getId();
            selectedBug = this.getBug(id);
        }
        int index = -1;
        if (this.mainPanel != null) {
            index = this.mainPanel.getSelectedIndex();
        }
        this.createPanels(selectedBug);
        if (index != -1) {
            this.mainPanel.setSelectedIndex(index);
        }
    }

    private void addComponents(MapdustBug mapdustBug) {
        MapdustBug selectedBug = mapdustBug;
        if (mapdustBug != null && mapdustBug.getNumberOfComments() > 0) {
            Long id = mapdustBug.getId();
            selectedBug = this.getBug(id);
        }
        this.createPanels(selectedBug);
    }

    private void createPanels(MapdustBug mapdustBug) {
        MapdustComment[] comments;
        String description;
        LatLon coordinates;
        if (this.cmpDetails == null) {
            this.detailsPanel = new MapdustBugDetailsPanel(mapdustBug);
            this.cmpDetails = ComponentUtil.createJScrollPane(this.detailsPanel, this.getBounds(), this.getBackground(), true, true);
            this.cmpDetails.setPreferredSize(new Dimension(100, 100));
            this.cmpDetails.setName("Bug Details");
        } else {
            this.detailsPanel.updateComponents(mapdustBug);
        }
        Address address = mapdustBug != null ? mapdustBug.getAddress() : null;
        LatLon latLon = coordinates = mapdustBug != null ? mapdustBug.getLatLon() : null;
        if (this.cmpAddress == null) {
            this.addressPanel = new MapdustAddressPanel(address, coordinates);
            this.cmpAddress = ComponentUtil.createJScrollPane(this.addressPanel, this.getBounds(), this.getBackground(), true, true);
            this.cmpAddress.setName("Address");
            this.cmpAddress.setPreferredSize(new Dimension(100, 100));
        } else {
            this.addressPanel.updateComponents(address, coordinates);
        }
        String string = description = mapdustBug != null ? mapdustBug.getDescription() : "";
        if (this.descriptionPanel == null) {
            this.descriptionPanel = new MapdustDescriptionPanel(description);
        } else {
            this.descriptionPanel.updateComponents(description);
        }
        MapdustComment[] mapdustCommentArray = comments = mapdustBug != null ? mapdustBug.getComments() : new MapdustComment[]{};
        if (this.commentsPanel == null) {
            this.commentsPanel = new MapdustCommentsPanel(comments);
        } else {
            this.commentsPanel.updateComponents(comments);
            this.mainPanel.setTitleAt(3, this.commentsPanel.getName());
        }
        if (this.helpPanel == null) {
            this.helpPanel = new MapdustHelpPanel();
        }
        if (this.mainPanel == null) {
            this.mainPanel = new JTabbedPane();
            this.mainPanel.setIgnoreRepaint(true);
            this.mainPanel.add((Component)this.cmpDetails, 0);
            this.mainPanel.add((Component)this.cmpAddress, 1);
            this.mainPanel.add((Component)this.descriptionPanel, 2);
            this.mainPanel.add((Component)this.commentsPanel, 3);
            this.mainPanel.add(this.helpPanel);
            this.add((Component)this.mainPanel, "Center");
        } else {
            this.mainPanel.revalidate();
        }
    }

    private MapdustBug getBug(Long id) {
        MapdustBug bug = null;
        try {
            bug = new MapdustServiceHandler().getBug(id, null);
        }
        catch (MapdustServiceHandlerException e) {
            String errorMessage = "There was a MapDust service error durring ";
            errorMessage = errorMessage + " the MapDust bug retrieve process.";
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)errorMessage, (Object[])new Object[0]), I18n.tr((String)"Error", (Object[])new Object[0]), 0);
        }
        return bug;
    }
}

