/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.infomode;

import java.awt.AWTEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.HashSet;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.GpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.plugins.infomode.InfoPanel;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

class InfoMode
extends MapMode
implements MapViewPaintable,
AWTEventListener {
    private MapView mv;
    private String statusText;
    private boolean drawing;
    private boolean ctrl;
    private boolean shift;
    private boolean oldCtrl;
    private boolean oldShift;
    private EastNorth pos;
    private WayPoint wpOld;
    private Popup oldPopup;
    private InfoPanel infoPanel = new InfoPanel();

    InfoMode(MapFrame mapFrame) {
        super(I18n.tr((String)"InfoMode", (Object[])new Object[0]), "infomode.png", I18n.tr((String)"GPX info mode", (Object[])new Object[0]), Shortcut.registerShortcut((String)"mapmode:infomode", (String)I18n.tr((String)"Mode: {0}", (Object[])new Object[]{I18n.tr((String)"GPX info mode", (Object[])new Object[0])}), (int)92, (int)3), mapFrame, Cursor.getPredefinedCursor(0));
    }

    public void enterMode() {
        if (!this.isEnabled()) {
            return;
        }
        super.enterMode();
        this.mv = Main.map.mapView;
        Main.map.mapView.addMouseListener((MouseListener)((Object)this));
        Main.map.mapView.addMouseMotionListener((MouseMotionListener)((Object)this));
        Main.map.mapView.addTemporaryLayer((MapViewPaintable)this);
        Main.map.statusLine.setHelpText(I18n.tr((String)"Move the mouse to show trackpoint info for current layer. Hold shift to highlight tracks", (Object[])new Object[0]));
        Main.map.statusLine.repaint();
        try {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public void exitMode() {
        super.exitMode();
        Main.map.mapView.removeMouseListener((MouseListener)((Object)this));
        Main.map.mapView.removeMouseMotionListener((MouseMotionListener)((Object)this));
        Main.map.mapView.removeTemporaryLayer((MapViewPaintable)this);
        if (this.oldPopup != null) {
            this.oldPopup.hide();
        }
        try {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.repaint();
    }

    public boolean layerIsSupported(Layer l) {
        return true;
    }

    public void paint(Graphics2D g, MapView mv, Bounds bbox) {
        if (this.pos == null) {
            return;
        }
        Layer curL = Main.main.getActiveLayer();
        if (curL instanceof GpxLayer) {
            this.showLayerInfo(g, curL, mv);
        } else {
            for (Layer l : mv.getAllLayers()) {
                if (!(l instanceof GpxLayer) || !this.showLayerInfo(g, l, mv)) continue;
                return;
            }
        }
    }

    public void eventDispatched(AWTEvent event) {
        this.updateKeyModifiers((InputEvent)event);
        if (event.getID() == 401) {
            this.doKeyEvent((KeyEvent)event);
        }
        this.repaint();
    }

    public void mousePressed(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (e.getButton() != 1) {
            return;
        }
        this.repaint();
    }

    public void mouseReleased(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (e.getButton() != 1) {
            return;
        }
        if (this.oldPopup != null) {
            this.oldPopup.hide();
            this.oldPopup = null;
            this.wpOld = null;
        }
        this.repaint();
    }

    public void mouseDragged(MouseEvent e) {
        if (this.oldPopup != null) {
            this.oldPopup.hide();
            this.oldPopup = null;
            this.wpOld = null;
        }
    }

    public void mouseMoved(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        this.pos = this.mv.getEastNorth(e.getX(), e.getY());
        this.repaint();
    }

    private void doKeyEvent(KeyEvent e) {
        if (e.getKeyCode() == 8) {
            this.filterTracks();
            this.repaint();
        }
        if (e.getKeyCode() == 92 || e.getKeyCode() == 10 || e.getKeyCode() == 27) {
            Main.map.selectSelectTool(false);
        }
    }

    protected void updateKeyModifiers(InputEvent e) {
        this.oldCtrl = this.ctrl;
        this.oldShift = this.shift;
        this.ctrl = (e.getModifiers() & 2) != 0;
        this.shift = (e.getModifiers() & 1) != 0;
    }

    protected void updateStatusLine() {
        Main.map.statusLine.setHelpText(this.statusText);
        Main.map.statusLine.repaint();
    }

    private void repaint() {
        if (Main.map != null) {
            Main.map.mapView.repaint();
        }
    }

    private void setStatusLine(String tr) {
        this.statusText = tr;
        this.updateStatusLine();
    }

    private synchronized void filterTracks() {
        Layer l = Main.main.getActiveLayer();
        if (l instanceof GpxLayer && this.pos != null) {
            GpxLayer gpxL = (GpxLayer)l;
            HashSet<GpxTrack> toRemove = new HashSet<GpxTrack>();
            for (GpxTrack track : gpxL.data.tracks) {
                boolean f = true;
                block1: for (GpxTrackSegment seg : track.getSegments()) {
                    for (WayPoint S : seg.getWayPoints()) {
                        if (S.time == 0.0) continue;
                        f = false;
                        break block1;
                    }
                }
                if (!f) continue;
                toRemove.add(track);
            }
            gpxL.data.tracks.removeAll(toRemove);
        }
    }

    private boolean showLayerInfo(Graphics2D g, Layer l, MapView mv) {
        GpxLayer gpxL = (GpxLayer)l;
        double minDist = 1.0E9;
        WayPoint wp = null;
        WayPoint oldWp = null;
        WayPoint prevWp = null;
        GpxTrack trk = null;
        double maxD = mv.getDist100Pixel() / 3.0;
        for (GpxTrack track : gpxL.data.tracks) {
            for (GpxTrackSegment seg : track.getSegments()) {
                oldWp = null;
                for (WayPoint S : seg.getWayPoints()) {
                    double d = S.getEastNorth().distance(this.pos);
                    if (d < minDist && d < maxD) {
                        minDist = d;
                        prevWp = oldWp;
                        wp = S;
                        trk = track;
                    }
                    oldWp = S;
                }
            }
        }
        if (wp != null) {
            Point p = mv.getPoint(wp.getCoor());
            g.setColor(Color.RED);
            g.fillOval(p.x - 10, p.y - 10, 20, 20);
            if (this.shift) {
                g.setColor(new Color(255, 30, 0, 128));
                Stroke oldStroke = g.getStroke();
                g.setStroke(new BasicStroke(10.0f));
                for (GpxTrackSegment seg : trk.getSegments()) {
                    Point oldP = null;
                    Point curP = null;
                    for (WayPoint S : seg.getWayPoints()) {
                        curP = mv.getPoint(S.getEastNorth());
                        if (oldP != null) {
                            g.drawLine(oldP.x, oldP.y, curP.x, curP.y);
                        }
                        oldP = curP;
                    }
                }
                g.setStroke(oldStroke);
            }
            Point s = mv.getLocationOnScreen();
            int pcx = s.x + p.x - 40;
            int pcy = s.y + p.y + 30;
            if (this.shift) {
                pcx += 40;
                pcy -= 30;
            }
            if (wp != this.wpOld) {
                if (this.oldPopup != null) {
                    this.oldPopup.hide();
                }
                double vel = -1.0;
                if (prevWp != null && wp.time != prevWp.time) {
                    vel = wp.getCoor().greatCircleDistance(prevWp.getCoor()) / (wp.time - prevWp.time) * 3.6;
                }
                this.infoPanel.setData(wp, trk, vel, gpxL.data.tracks);
                Popup pp = PopupFactory.getSharedInstance().getPopup((Component)mv, this.infoPanel, pcx, pcy);
                pp.show();
                this.wpOld = wp;
                this.oldPopup = pp;
            }
            return true;
        }
        return false;
    }
}

