/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.JunctionChecker.junctionchecking;

import java.util.ArrayList;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.Channel;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.ChannelDiGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPrepare {
    private final ArrayList<Channel> entries = new ArrayList();
    private final ArrayList<Channel> exits = new ArrayList();
    private ArrayList<Channel> vertices;
    private final ChannelDiGraph digraph;

    public JPrepare(ChannelDiGraph digraph) {
        this.digraph = digraph;
    }

    public void jPrepare(ArrayList<Channel> vertices) {
        int i;
        this.vertices = vertices;
        this.entries.clear();
        this.exits.clear();
        for (i = 0; i < vertices.size(); ++i) {
            vertices.get(i).setSubgraph(true);
        }
        for (i = 0; i < vertices.size(); ++i) {
            int j;
            for (j = 0; j < vertices.get(i).getPredChannels().size(); ++j) {
                if (!vertices.get(i).getPredChannels().get(j).isSubgraph()) {
                    if (this.entries.contains(vertices.get(i))) continue;
                    this.entries.add(vertices.get(i));
                    continue;
                }
                vertices.get(i).countupIndegree();
            }
            for (j = 0; j < vertices.get(i).getLeadsTo().size(); ++j) {
                if (!vertices.get(i).getLeadsTo().get(j).getToChannel().isSubgraph()) {
                    if (this.exits.contains(vertices.get(i))) continue;
                    this.exits.add(vertices.get(i));
                    continue;
                }
                vertices.get(i).countupOutdegree();
            }
        }
    }

    public void resetSubgraph() {
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.vertices.get(i).setSubgraph(false);
            this.vertices.get(i).setIndegree(0);
            this.vertices.get(i).setOutdegree(0);
        }
    }

    public ArrayList<Channel> getEntries() {
        return this.entries;
    }

    public ArrayList<Channel> getExits() {
        return this.exits;
    }
}

