/*
 * Decompiled with CFR 0.152.
 */
package utilsplugin2.customurl;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import utilsplugin2.customurl.URLList;

public class ChooseURLAction
extends JosmAction {
    public ChooseURLAction() {
        super(I18n.tr((String)"Select custom URL", (Object[])new Object[0]), "selecturl", I18n.tr((String)"Select custom URL", (Object[])new Object[0]), null, true, true);
        this.putValue("toolbar", "action/selectURL");
    }

    public void actionPerformed(ActionEvent e) {
        ChooseURLAction.showConfigDialog(false);
    }

    protected void updateEnabledState() {
        if (ChooseURLAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }

    public static void showConfigDialog(boolean fast) {
        JPanel all = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        all.setLayout(layout);
        List<String> items = URLList.getURLList();
        String addr = URLList.getSelectedURL();
        int n = items.size() / 2;
        int idxToSelect = -1;
        String[] names = new String[n];
        final String[] vals = new String[n];
        for (int i = 0; i < n; ++i) {
            names[i] = items.get(i * 2);
            vals[i] = items.get(i * 2 + 1);
            if (!vals[i].equals(addr)) continue;
            idxToSelect = i;
        }
        JLabel label1 = new JLabel(I18n.tr((String)"Please select one of custom URLs (configured in Preferences)", (Object[])new Object[0]));
        final JList<String> list1 = new JList<String>(names);
        final JTextField editField = new JTextField();
        JCheckBox check1 = new JCheckBox(I18n.tr((String)"Ask every time", (Object[])new Object[0]));
        ExtendedDialog dialog = new ExtendedDialog(Main.parent, I18n.tr((String)"Configure custom URL", (Object[])new Object[0]), new String[]{I18n.tr((String)"OK", (Object[])new Object[0]), I18n.tr((String)"Cancel", (Object[])new Object[0])});
        list1.setSelectionMode(0);
        list1.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                int idx = list1.getSelectedIndex();
                if (idx >= 0) {
                    editField.setText(vals[idx]);
                }
            }
        });
        list1.setSelectedIndex(idxToSelect);
        check1.setSelected(Main.pref.getBoolean("utilsplugin2.askurl", false));
        editField.setEditable(false);
        all.add((Component)label1, GBC.eop().fill(2).insets(15, 5, 15, 0));
        all.add(list1, GBC.eop().fill(2).insets(5, 5, 0, 0));
        all.add((Component)editField, GBC.eop().fill(2).insets(5, 5, 0, 0));
        all.add((Component)check1, GBC.eop().fill(2).insets(5, 5, 0, 0));
        dialog.setContent((Component)all, false);
        dialog.setButtonIcons(new String[]{"ok.png", "cancel.png"});
        dialog.setDefaultButton(1);
        dialog.showDialog();
        int idx = list1.getSelectedIndex();
        if (dialog.getValue() == 1 && idx >= 0) {
            URLList.select(vals[idx]);
            Main.pref.put("utilsplugin2.askurl", check1.isSelected());
        }
    }
}

