/*
 * Decompiled with CFR 0.152.
 */
package com.tilusnet.josm.plugins.alignways;

import com.tilusnet.josm.plugins.alignways.AlignWaysCmdKeepLength;
import com.tilusnet.josm.plugins.alignways.geometry.AlignWaysGeomLine;
import com.tilusnet.josm.plugins.alignways.geometry.AlignWaysGeomPoint;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.tools.I18n;

public class AlignWaysCmdKeepAngles
extends AlignWaysCmdKeepLength {
    AlignWaysCmdKeepLength.AlignableStatus alignableStatKeepAngles = AlignWaysCmdKeepLength.AlignableStatus.ALGN_VALID;

    public AlignWaysCmdKeepAngles() {
        Map calcNodesKeepLength = this.calculatedNodes;
        Node[] nodeArr = this.algnSeg.getSegmentEndPoints().toArray(new Node[2]);
        EastNorth enCalc1 = (EastNorth)calcNodesKeepLength.get(nodeArr[0]);
        EastNorth enCalc2 = (EastNorth)calcNodesKeepLength.get(nodeArr[1]);
        AlignWaysGeomLine lineKeepLength = new AlignWaysGeomLine(enCalc1.getX(), enCalc1.getY(), enCalc2.getX(), enCalc2.getY());
        this.recalculateNodes(lineKeepLength, nodeArr[0]);
        this.recalculateNodes(lineKeepLength, nodeArr[1]);
    }

    void recalculateNodes(AlignWaysGeomLine alignedLineKeepLength, Node endpoint) {
        ArrayList<WaySegment> alws = this.algnSeg.getAdjacentWaySegments(endpoint);
        if (alws.size() == 1) {
            EastNorth enAdj1 = alws.get(0).getFirstNode().getEastNorth();
            EastNorth enAdj2 = alws.get(0).getSecondNode().getEastNorth();
            AlignWaysGeomPoint isectPnt = alignedLineKeepLength.getIntersection(new AlignWaysGeomLine(enAdj1.getX(), enAdj1.getY(), enAdj2.getX(), enAdj2.getY()));
            if (isectPnt != null) {
                this.calculatedNodes.put(endpoint, new EastNorth(isectPnt.getX(), isectPnt.getY()));
            } else if (alignedLineKeepLength.getIntersectionStatus() == AlignWaysGeomLine.IntersectionStatus.LINES_PARALLEL) {
                this.alignableStatKeepAngles = AlignWaysCmdKeepLength.AlignableStatus.ALGN_INV_ANGLE_PRESERVING_CONFLICT;
            }
        } else if (!endpoint.getEastNorth().equals((Object)this.pivot)) {
            this.alignableStatKeepAngles = AlignWaysCmdKeepLength.AlignableStatus.ALGN_INV_TOOMANY_CONNECTED_WS;
        }
    }

    void reportInvalidCommand(AlignWaysCmdKeepLength.AlignableStatus stat) {
        String statMsg;
        switch (stat) {
            case ALGN_INV_CONNECTED_UNSHARED_PIVOT: {
                statMsg = I18n.tr((String)"Please select two segments that don''t share any nodes.\nAlternatively put the pivot on their common node.\n", (Object[])new Object[0]);
                break;
            }
            case ALGN_INV_OUTSIDE_WORLD: {
                statMsg = I18n.tr((String)"Aligning would result nodes ''outside the world''.\nAlignment not possible.\n", (Object[])new Object[0]);
                break;
            }
            case ALGN_INV_TOOMANY_CONNECTED_WS: {
                statMsg = I18n.tr((String)"There is at least a non-pivot endpoint of the alignee that joins more than two way segments.\nPreserved angles type alignment is not possible.\n", (Object[])new Object[0]);
                break;
            }
            case ALGN_INV_ANGLE_PRESERVING_CONFLICT: {
                statMsg = I18n.tr((String)"The alignment is not possible with maintaining the angles of the joint segments.\nEither choose the ''keep length'' aligning method or select other segments.\n", (Object[])new Object[0]);
                break;
            }
            default: {
                statMsg = I18n.tr((String)"Undocumented problem occured.\n", (Object[])new Object[0]);
            }
        }
        JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)statMsg, (Object[])new Object[0]), I18n.tr((String)"AlignWayS: Alignment not possible", (Object[])new Object[0]), 2);
    }

    AlignWaysCmdKeepLength.AlignableStatus areSegsAlignable() {
        AlignWaysCmdKeepLength.AlignableStatus status = super.areSegsAlignable();
        if (this.alignableStatKeepAngles != AlignWaysCmdKeepLength.AlignableStatus.ALGN_VALID) {
            return this.alignableStatKeepAngles;
        }
        if (status != AlignWaysCmdKeepLength.AlignableStatus.ALGN_VALID) {
            return status;
        }
        for (Node nA : this.displaceableNodes) {
            if (nA.getEastNorth().equals((Object)this.pivot) || !this.isReferredByNOtherWaySegments(nA, 2)) continue;
            return AlignWaysCmdKeepLength.AlignableStatus.ALGN_INV_TOOMANY_CONNECTED_WS;
        }
        return AlignWaysCmdKeepLength.AlignableStatus.ALGN_VALID;
    }

    private boolean isReferredByNOtherWaySegments(Node node, int numWSeg) {
        ArrayList<WaySegment> coll_ws = this.algnSeg.getAdjacentWaySegments(node);
        if (coll_ws != null) {
            return coll_ws.size() >= numWSeg;
        }
        return false;
    }
}

