/*
 * Decompiled with CFR 0.152.
 */
package com.tilusnet.josm.plugins.alignways.geometry;

import com.tilusnet.josm.plugins.alignways.geometry.AlignWaysGeomPoint;

public class AlignWaysGeomLine {
    double coef_a;
    double coef_b;
    double coef_c;
    IntersectionStatus isectStat = IntersectionStatus.UNDEFINED;

    public AlignWaysGeomLine(double x1, double y1, double x2, double y2) {
        if (x1 == x2) {
            this.coef_a = 1.0;
            this.coef_b = 0.0;
            this.coef_c = -x1;
        } else {
            this.coef_a = (y2 - y1) / (x2 - x1);
            this.coef_b = -1.0;
            this.coef_c = y1 - this.coef_a * x1;
        }
    }

    public AlignWaysGeomLine(double a, double b, double c) {
        this.coef_a = a;
        this.coef_b = b;
        this.coef_c = c;
    }

    public AlignWaysGeomLine(double m, double b) {
        this.coef_a = m;
        this.coef_b = -1.0;
        this.coef_c = b;
    }

    public AlignWaysGeomLine(AlignWaysGeomLine line) {
        this(line.coef_a, line.coef_b, line.coef_c);
    }

    public AlignWaysGeomPoint getIntersection(AlignWaysGeomLine other_line) {
        AlignWaysGeomPoint result = null;
        double det1 = this.coef_a * other_line.coef_b - other_line.coef_a * this.coef_b;
        double det2 = -this.coef_c * other_line.coef_b - -other_line.coef_c * this.coef_b;
        double det3 = this.coef_a * -other_line.coef_c - other_line.coef_a * -this.coef_c;
        if (Math.abs(det1) < 0.01) {
            this.isectStat = Math.abs(det2) < 0.01 && Math.abs(det3) < 0.01 ? IntersectionStatus.LINES_OVERLAP : IntersectionStatus.LINES_PARALLEL;
        } else {
            result = new AlignWaysGeomPoint(det2 / det1, det3 / det1);
            this.isectStat = IntersectionStatus.INTERSECT_POINT;
        }
        return result;
    }

    public IntersectionStatus getIntersectionStatus() {
        return this.isectStat;
    }

    public Double getYonLine(double X) {
        Double Y = new Double((-this.coef_a * X - this.coef_c) / this.coef_b);
        if (Y.isInfinite() || Y.isNaN()) {
            return Double.NaN;
        }
        return Y;
    }

    public Double getXonLine(double Y) {
        Double X = new Double((-this.coef_b * Y - this.coef_c) / this.coef_a);
        if (X.isInfinite() || X.isNaN()) {
            return Double.NaN;
        }
        return X;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlignWaysGeomLine)) {
            return false;
        }
        AlignWaysGeomLine other = (AlignWaysGeomLine)obj;
        return Math.abs(this.coef_a - other.coef_a) < 0.01 && Math.abs(this.coef_b - other.coef_b) < 0.01 && Math.abs(this.coef_c - other.coef_c) < 0.01;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IntersectionStatus {
        UNDEFINED,
        INTERSECT_POINT,
        LINES_PARALLEL,
        LINES_OVERLAP;

    }
}

