/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.licensechange;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.plugins.licensechange.LicenseChangePlugin;
import org.openstreetmap.josm.plugins.licensechange.LicenseChangeVisitor;
import org.openstreetmap.josm.plugins.licensechange.LicenseProblem;
import org.openstreetmap.josm.plugins.licensechange.ProblemTreePanel;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LicenseChangeDialog
extends ToggleDialog
implements ActionListener {
    private LicenseChangePlugin plugin;
    protected ProblemTreePanel tree;
    private SideButton selectButton;
    private JPopupMenu popupMenu;
    private LicenseProblem popupMenuError = null;
    private DefaultMutableTreeNode lastSelectedNode = null;

    public LicenseChangeDialog(LicenseChangePlugin plugin) {
        super(I18n.tr((String)"Relicensing problems", (Object[])new Object[0]), "licensechange", I18n.tr((String)"Open the relicensing window.", (Object[])new Object[0]), Shortcut.registerShortcut((String)"subwindow:licensechange", (String)I18n.tr((String)"Toggle: {0}", (Object[])new Object[]{I18n.tr((String)"Relicensing problems", (Object[])new Object[0])}), (int)76, (int)4, (int)1), 150);
        this.plugin = plugin;
        this.popupMenu = new JPopupMenu();
        JMenuItem zoomTo = new JMenuItem(I18n.tr((String)"Zoom to problem", (Object[])new Object[0]));
        zoomTo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LicenseChangeDialog.this.zoomToProblem();
            }
        });
        this.popupMenu.add(zoomTo);
        this.tree = new ProblemTreePanel();
        this.tree.addMouseListener(new ClickWatch());
        this.tree.addTreeSelectionListener(new SelectionWatch());
        this.selectButton = new SideButton(I18n.marktr((String)"Select"), "select", "LicenseChange", I18n.tr((String)"Set the selected elements on the map to the selected items in the list above.", (Object[])new Object[0]), (ActionListener)this);
        this.selectButton.setEnabled(false);
        this.createLayout(this.tree, true, Arrays.asList(this.selectButton, new SideButton((Action)((Object)plugin.checkAction))));
    }

    public void showNotify() {
        DataSet ds = Main.main.getCurrentDataSet();
        if (ds != null) {
            this.updateSelection(ds.getSelected());
        }
    }

    public void setVisible(boolean v) {
        if (this.tree != null) {
            this.tree.setVisible(v);
        }
        super.setVisible(v);
        Main.map.repaint();
    }

    private void showPopupMenu(MouseEvent e) {
        if (!e.isPopupTrigger()) {
            return;
        }
        this.popupMenuError = null;
        TreePath selPath = this.tree.getPathForLocation(e.getX(), e.getY());
        if (selPath == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)selPath.getPathComponent(selPath.getPathCount() - 1);
        if (!(node.getUserObject() instanceof LicenseProblem)) {
            return;
        }
        this.popupMenuError = (LicenseProblem)node.getUserObject();
        this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
    }

    private void zoomToProblem() {
        if (this.popupMenuError == null) {
            return;
        }
        LicenseChangeBoundingXYVisitor bbox = new LicenseChangeBoundingXYVisitor();
        this.popupMenuError.visitHighlighted(bbox);
        if (bbox.getBounds() == null) {
            return;
        }
        bbox.enlargeBoundingBox();
        Main.map.mapView.recalculateCenterScale((BoundingXYVisitor)bbox);
    }

    private void setSelectedItems() {
        if (this.tree == null) {
            return;
        }
        HashSet<? extends OsmPrimitive> sel = new HashSet<OsmPrimitive>(40);
        TreePath[] selectedPaths = this.tree.getSelectionPaths();
        if (selectedPaths == null) {
            return;
        }
        for (TreePath path : selectedPaths) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Enumeration<TreeNode> children = node.breadthFirstEnumeration();
            while (children.hasMoreElements()) {
                DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)children.nextElement();
                Object nodeInfo = childNode.getUserObject();
                if (!(nodeInfo instanceof LicenseProblem)) continue;
                LicenseProblem problem = (LicenseProblem)nodeInfo;
                sel.addAll(problem.getPrimitives());
            }
        }
        Main.main.getCurrentDataSet().setSelected(sel);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand.equals("Select")) {
            this.setSelectedItems();
        }
    }

    private void setSelection(Collection<OsmPrimitive> sel, boolean addSelected) {
        LicenseProblem error;
        Object nodeInfo;
        DefaultMutableTreeNode childNode;
        Enumeration<TreeNode> children;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (this.lastSelectedNode != null && !this.lastSelectedNode.equals(node)) {
            children = this.lastSelectedNode.breadthFirstEnumeration();
            while (children.hasMoreElements()) {
                childNode = (DefaultMutableTreeNode)children.nextElement();
                nodeInfo = childNode.getUserObject();
                if (!(nodeInfo instanceof LicenseProblem)) continue;
                error = (LicenseProblem)nodeInfo;
                error.setSelected(false);
            }
        }
        this.lastSelectedNode = node;
        if (node == null) {
            return;
        }
        children = node.breadthFirstEnumeration();
        while (children.hasMoreElements()) {
            childNode = (DefaultMutableTreeNode)children.nextElement();
            nodeInfo = childNode.getUserObject();
            if (!(nodeInfo instanceof LicenseProblem)) continue;
            error = (LicenseProblem)nodeInfo;
            error.setSelected(true);
            if (!addSelected) continue;
            sel.addAll(error.getPrimitives());
        }
        this.selectButton.setEnabled(true);
    }

    public void updateSelection(Collection<? extends OsmPrimitive> newSelection) {
        if (newSelection.isEmpty()) {
            this.tree.setFilter(null);
        }
        HashSet<OsmPrimitive> filter = new HashSet<OsmPrimitive>(newSelection);
        this.tree.setFilter(filter);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LicenseChangeBoundingXYVisitor
    extends BoundingXYVisitor
    implements LicenseChangeVisitor {
        @Override
        public void visit(OsmPrimitive p) {
            if (p.isUsable()) {
                p.visit((Visitor)this);
            }
        }

        public void visit(WaySegment ws) {
            if (ws.lowerIndex < 0 || ws.lowerIndex + 1 >= ws.way.getNodesCount()) {
                return;
            }
            this.visit((Node)ws.way.getNodes().get(ws.lowerIndex));
            this.visit((Node)ws.way.getNodes().get(ws.lowerIndex + 1));
        }

        @Override
        public void visit(List<Node> nodes) {
            for (Node n : nodes) {
                this.visit(n);
            }
        }
    }

    public class SelectionWatch
    implements TreeSelectionListener {
        public void valueChanged(TreeSelectionEvent e) {
            LicenseChangeDialog.this.selectButton.setEnabled(false);
            if (e.getSource() instanceof JScrollPane) {
                System.out.println(e.getSource());
                return;
            }
            LicenseChangeDialog.this.setSelection(null, false);
            Main.map.repaint();
        }
    }

    public class ClickWatch
    extends MouseAdapter {
        public void mouseClicked(MouseEvent e) {
            LicenseChangeDialog.this.selectButton.setEnabled(false);
            boolean isDblClick = e.getClickCount() > 1;
            HashSet sel = isDblClick ? new HashSet(40) : null;
            LicenseChangeDialog.this.setSelection(sel, isDblClick);
            if (isDblClick) {
                Main.main.getCurrentDataSet().setSelected(sel);
                if (Main.pref.getBoolean("licensechange.autozoom", false)) {
                    AutoScaleAction.zoomTo(sel);
                }
            }
        }

        public void mousePressed(MouseEvent e) {
            LicenseChangeDialog.this.showPopupMenu(e);
        }

        public void mouseReleased(MouseEvent e) {
            LicenseChangeDialog.this.showPopupMenu(e);
        }
    }
}

