/*
 * Decompiled with CFR 0.152.
 */
package org.openaviationmap.josm.plugins.latlon;

import java.awt.event.ActionEvent;
import java.util.LinkedList;
import org.openaviationmap.josm.plugins.latlon.LatLonDialog;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public final class LatLonAction
extends JosmAction {
    private String textLatLon;

    public LatLonAction() {
        super(I18n.tr((String)"Lat Lon tool", (Object[])new Object[0]), "latlon", I18n.tr((String)"Create geometry by entering lat lon coordinates for it.", (Object[])new Object[0]), Shortcut.registerShortcut((String)"addnode", (String)I18n.tr((String)"Edit: {0}", (Object[])new Object[]{I18n.tr((String)"Add Node...", (Object[])new Object[0])}), (int)68, (int)3, (int)1), true);
        this.putValue("help", HelpUtil.ht((String)"/Action/AddNode"));
    }

    public void actionPerformed(ActionEvent e) {
        Way wnew;
        if (!this.isEnabled()) {
            return;
        }
        LatLonDialog dialog = new LatLonDialog(Main.parent, I18n.tr((String)"Add Node...", (Object[])new Object[0]), HelpUtil.ht((String)"/Action/AddNode"));
        if (this.textLatLon != null) {
            dialog.setLatLonText(this.textLatLon);
        }
        dialog.showDialog();
        if (dialog.getValue() != 1) {
            return;
        }
        LatLon[] coordinates = dialog.getCoordinates();
        String type = dialog.getGeomType();
        if (coordinates == null) {
            return;
        }
        this.textLatLon = dialog.getLatLonText();
        LinkedList<AddCommand> cmds = new LinkedList<AddCommand>();
        LinkedList<Object> nodes = new LinkedList<Object>();
        for (LatLon ll : coordinates) {
            Node nnew = new Node(ll);
            nodes.add(nnew);
            cmds.add(new AddCommand((OsmPrimitive)nnew));
        }
        if (type == "Nodes") {
            // empty if block
        }
        if (type == "Line") {
            wnew = new Way();
            wnew.setNodes(nodes);
            cmds.add(new AddCommand((OsmPrimitive)wnew));
        }
        if (type == "Area") {
            nodes.add(nodes.get(0));
            wnew = new Way();
            wnew.setNodes(nodes);
            cmds.add(new AddCommand((OsmPrimitive)wnew));
        }
        Main.main.undoRedo.add((Command)new SequenceCommand(I18n.tr((String)"Lat Lon tool", (Object[])new Object[0]), cmds));
        Main.map.mapView.repaint();
    }

    protected void updateEnabledState() {
        this.setEnabled(LatLonAction.getEditLayer() != null);
    }
}

