/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.licensechange;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParserFactory;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.licensechange.CheckAction;
import org.openstreetmap.josm.plugins.licensechange.LicenseChangeDialog;
import org.openstreetmap.josm.plugins.licensechange.LicenseProblem;
import org.openstreetmap.josm.plugins.licensechange.ProblemLayer;
import org.openstreetmap.josm.plugins.licensechange.Severity;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LicenseChangePlugin
extends Plugin
implements MapView.LayerChangeListener {
    protected static ProblemLayer problemLayer = null;
    CheckAction checkAction = new CheckAction(this);
    LicenseChangeDialog problemDialog;
    Map<Layer, List<LicenseProblem>> layerProblems = new HashMap<Layer, List<LicenseProblem>>();
    private final HashMap<Long, HashMap<User, Severity>> nodeUsers = new HashMap();
    private final HashMap<Long, HashMap<User, Severity>> wayUsers = new HashMap();
    private final HashMap<Long, HashMap<User, Severity>> relationUsers = new HashMap();

    public HashMap<User, Severity> getUsers(Node n) {
        return this.nodeUsers.get(n.getId());
    }

    public HashMap<User, Severity> getUsers(Way n) {
        return this.wayUsers.get(n.getId());
    }

    public HashMap<User, Severity> getUsers(Relation n) {
        return this.relationUsers.get(n.getId());
    }

    public LicenseChangePlugin(PluginInformation info) {
        super(info);
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (newFrame != null) {
            this.problemDialog = new LicenseChangeDialog(this);
            newFrame.addToggleDialog((ToggleDialog)this.problemDialog);
            MapView.addLayerChangeListener((MapView.LayerChangeListener)this);
        } else {
            MapView.removeLayerChangeListener((MapView.LayerChangeListener)this);
        }
    }

    public void initializeProblemLayer() {
        if (problemLayer == null) {
            problemLayer = new ProblemLayer(this);
            Main.main.addLayer((Layer)problemLayer);
        }
    }

    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
        if (newLayer instanceof OsmDataLayer) {
            List<LicenseProblem> errors = this.layerProblems.get(newLayer);
            this.problemDialog.tree.setErrorList(errors);
            Main.map.repaint();
        }
    }

    public void layerAdded(Layer newLayer) {
        if (newLayer instanceof OsmDataLayer) {
            this.layerProblems.put(newLayer, new ArrayList());
        }
    }

    public void layerRemoved(Layer oldLayer) {
        if (oldLayer == problemLayer) {
            problemLayer = null;
            return;
        }
        this.layerProblems.remove(oldLayer);
        if (Main.map.mapView.getLayersOfType(OsmDataLayer.class).isEmpty() && problemLayer != null) {
            Main.map.mapView.removeLayer((Layer)problemLayer);
        }
    }

    public void loadDataFromQuickHistoryService(Collection<OsmPrimitive> objectList) {
        final StringBuffer nodesToLoad = new StringBuffer();
        final StringBuffer waysToLoad = new StringBuffer();
        final StringBuffer relationsToLoad = new StringBuffer();
        Visitor v = new Visitor(){

            public void visit(Node n) {
                if (!LicenseChangePlugin.this.nodeUsers.containsKey(n.getId())) {
                    if ("clean".equals(n.get("odbl"))) {
                        LicenseChangePlugin.this.nodeUsers.put(new Long(n.getId()), new HashMap<User, Severity>(Collections.singletonMap(n.getUser(), Severity.CLEAN)));
                    } else {
                        nodesToLoad.append(",");
                        nodesToLoad.append(n.getId());
                    }
                }
            }

            public void visit(Way n) {
                if (!LicenseChangePlugin.this.wayUsers.containsKey(n.getId())) {
                    if ("clean".equals(n.get("odbl"))) {
                        LicenseChangePlugin.this.wayUsers.put(new Long(n.getId()), new HashMap<User, Severity>(Collections.singletonMap(n.getUser(), Severity.CLEAN)));
                    } else {
                        waysToLoad.append(",");
                        waysToLoad.append(n.getId());
                    }
                }
            }

            public void visit(Relation n) {
                if (!LicenseChangePlugin.this.relationUsers.containsKey(n.getId())) {
                    if ("clean".equals(n.get("odbl"))) {
                        LicenseChangePlugin.this.relationUsers.put(new Long(n.getId()), new HashMap<User, Severity>(Collections.singletonMap(n.getUser(), Severity.CLEAN)));
                    } else {
                        relationsToLoad.append(",");
                        relationsToLoad.append(n.getId());
                    }
                }
            }

            public void visit(Changeset c) {
            }
        };
        for (OsmPrimitive p : objectList) {
            if (p.getId() <= 0L) continue;
            p.visit(v);
        }
        if (nodesToLoad.length() == 0 && waysToLoad.length() == 0 && relationsToLoad.length() == 0) {
            return;
        }
        try {
            URL qhs = new URL("http://wtfe.gryph.de/api/0.6/problems");
            HttpURLConnection activeConnection = (HttpURLConnection)qhs.openConnection();
            activeConnection.setRequestMethod("POST");
            activeConnection.setDoOutput(true);
            activeConnection.setRequestProperty("Content-type", "text/xml");
            OutputStream out = activeConnection.getOutputStream();
            BufferedWriter bwr = new BufferedWriter(new OutputStreamWriter(out, "UTF-8"));
            if (nodesToLoad.length() > 0) {
                bwr.write("&nodes=0");
                bwr.write(nodesToLoad.toString());
            }
            if (waysToLoad.length() > 0) {
                bwr.write("&ways=0");
                bwr.write(waysToLoad.toString());
            }
            if (relationsToLoad.length() > 0) {
                bwr.write("&relations=0");
                bwr.write(relationsToLoad.toString());
            }
            bwr.flush();
            activeConnection.connect();
            System.out.println(activeConnection.getResponseMessage());
            int retCode = activeConnection.getResponseCode();
            InputStream i = null;
            try {
                i = activeConnection.getInputStream();
            }
            catch (IOException ioe) {
                i = activeConnection.getErrorStream();
            }
            StringBuffer responseBody = new StringBuffer();
            if (i != null) {
                InputSource inputSource = new InputSource(i);
                SAXParserFactory.newInstance().newSAXParser().parse(inputSource, (DefaultHandler)new QhsParser());
            }
            activeConnection.disconnect();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private class QhsParser
    extends DefaultHandler {
        HashMap<User, Severity> theMap = null;

        private QhsParser() {
        }

        public void startDocument() throws SAXException {
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if ("node".equals(qName) || "way".equals(qName) || "relation".equals(qName)) {
                HashMap userMap = "node".equals(qName) ? LicenseChangePlugin.this.nodeUsers : ("way".equals(qName) ? LicenseChangePlugin.this.wayUsers : LicenseChangePlugin.this.relationUsers);
                Long id = Long.decode(atts.getValue("id"));
                this.theMap = (HashMap)userMap.get(id);
                if (this.theMap == null) {
                    this.theMap = new HashMap();
                    userMap.put(id, this.theMap);
                }
            } else if ("user".equals(qName)) {
                String v = atts.getValue("version");
                String i = atts.getValue("id");
                String d = atts.getValue("decision");
                String s = atts.getValue("severity");
                if (!"undecided".equals(d) && !"no".equals(d)) {
                    return;
                }
                if ("normal".equals(s) && "first".equals(v)) {
                    s = "first";
                }
                User u = User.createOsmUser((long)Long.parseLong(i), null);
                u.setRelicensingStatus("undecided".equals(d) ? 0 : ("no".equals(d) ? 2 : -1));
                this.theMap.put(u, "first".equals(s) ? Severity.FIRST : ("normal".equals(s) ? Severity.NORMAL : ("harmless".equals(s) ? Severity.HARMLESS : Severity.NONE)));
            }
        }
    }
}

