/*
 * Decompiled with CFR 0.152.
 */
package smed.jide.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseListener;
import java.security.AccessControlException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class JideSwingUtilities {
    private static JavaVersion _currentVersion;

    public static void insertMouseListener(Component component, MouseListener l, int index) {
        MouseListener[] listeners;
        for (MouseListener listener : listeners = component.getMouseListeners()) {
            component.removeMouseListener(listener);
        }
        for (int i = 0; i < listeners.length; ++i) {
            MouseListener listener = listeners[i];
            if (index == i) {
                component.addMouseListener(l);
            }
            component.addMouseListener(listener);
        }
        if (index < 0 || index > listeners.length - 1) {
            component.addMouseListener(l);
        }
    }

    public static Dimension adjustPreferredScrollableViewportSize(JList list, Dimension defaultViewportSize) {
        Dimension preferredSize;
        Component c;
        ListCellRenderer<String> renderer;
        Rectangle cellBonds = list.getCellBounds(0, 0);
        if (cellBonds != null && cellBonds.height < 3 && (renderer = list.getCellRenderer()) != null && (c = renderer.getListCellRendererComponent(list, "DUMMY STRING", 0, false, false)) != null && (preferredSize = c.getPreferredSize()) != null) {
            int height = preferredSize.height;
            if (height < 3) {
                try {
                    height = list.getCellBounds((int)1, (int)1).height;
                }
                catch (Exception e) {
                    height = 16;
                }
            }
            list.setFixedCellHeight(height);
        }
        if (JideSwingUtilities.isJdk15Above()) {
            return defaultViewportSize;
        }
        ++defaultViewportSize.height;
        return defaultViewportSize;
    }

    public static String getProperty(String key, String defaultValue) {
        try {
            return System.getProperty(key, defaultValue);
        }
        catch (AccessControlException e) {
            return defaultValue;
        }
    }

    public static String getJavaVersion() {
        return JideSwingUtilities.getProperty("java.version", "1.4.2");
    }

    private static void checkJdkVersion() {
        if (_currentVersion == null) {
            _currentVersion = new JavaVersion(JideSwingUtilities.getJavaVersion());
        }
    }

    public static boolean isJdk15Above() {
        JideSwingUtilities.checkJdkVersion();
        return _currentVersion.compareVersion(1.5, 0, 0) >= 0;
    }

    public static class JavaVersion {
        private static Pattern SUN_JAVA_VERSION = Pattern.compile("(\\d+\\.\\d+)(\\.(\\d+))?(_([^-]+))?(.*)");
        private static Pattern SUN_JAVA_VERSION_SIMPLE = Pattern.compile("(\\d+\\.\\d+)(\\.(\\d+))?(.*)");
        private double _majorVersion;
        private int _minorVersion;
        private int _buildNumber;
        private String _patch;

        public JavaVersion(String version) {
            block11: {
                this._majorVersion = 1.4;
                this._minorVersion = 0;
                this._buildNumber = 0;
                try {
                    String s;
                    Matcher matcher = SUN_JAVA_VERSION.matcher(version);
                    if (!matcher.matches()) break block11;
                    int groups = matcher.groupCount();
                    this._majorVersion = Double.parseDouble(matcher.group(1));
                    if (groups >= 3 && matcher.group(3) != null) {
                        this._minorVersion = Integer.parseInt(matcher.group(3));
                    }
                    if (groups >= 5 && matcher.group(5) != null) {
                        try {
                            this._buildNumber = Integer.parseInt(matcher.group(5));
                        }
                        catch (NumberFormatException e) {
                            this._patch = matcher.group(5);
                        }
                    }
                    if (groups >= 6 && matcher.group(6) != null && (s = matcher.group(6)) != null && s.trim().length() > 0) {
                        this._patch = s;
                    }
                }
                catch (NumberFormatException e) {
                    try {
                        Matcher matcher = SUN_JAVA_VERSION_SIMPLE.matcher(version);
                        if (matcher.matches()) {
                            int groups = matcher.groupCount();
                            this._majorVersion = Double.parseDouble(matcher.group(1));
                            if (groups >= 3 && matcher.group(3) != null) {
                                this._minorVersion = Integer.parseInt(matcher.group(3));
                            }
                        }
                    }
                    catch (NumberFormatException e1) {
                        System.err.println("Please check the installation of your JDK. The version number " + version + " is not right.");
                    }
                }
            }
        }

        public JavaVersion(double major, int minor, int build) {
            this._majorVersion = major;
            this._minorVersion = minor;
            this._buildNumber = build;
        }

        public int compareVersion(double major, int minor, int build) {
            double majorResult = this._majorVersion - major;
            if (majorResult != 0.0) {
                return majorResult < 0.0 ? -1 : 1;
            }
            int result = this._minorVersion - minor;
            if (result != 0) {
                return result;
            }
            return this._buildNumber - build;
        }

        public double getMajorVersion() {
            return this._majorVersion;
        }

        public int getMinorVersion() {
            return this._minorVersion;
        }

        public int getBuildNumber() {
            return this._buildNumber;
        }

        public String getPatch() {
            return this._patch;
        }
    }
}

