/*
 * Decompiled with CFR 0.152.
 */
package utilsplugin2;

import java.awt.event.ActionEvent;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.Shortcut;
import utilsplugin2.ChooseURLAction;

public final class OpenPageAction
extends JosmAction {
    private final String defaultURL = "http://ru.wikipedia.org/w/index.php?search={name}&fulltext=Search";

    public OpenPageAction() {
        super(I18n.tr((String)"Open custom URL", (Object[])new Object[0]), "openurl", I18n.tr((String)"Opens specified URL browser", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:openurl", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Open custom URL", (Object[])new Object[0])}), (int)92, (int)3, (int)1), true);
        this.putValue("help", HelpUtil.ht((String)"/Action/OpenPage"));
    }

    public void actionPerformed(ActionEvent e) {
        Collection sel = OpenPageAction.getCurrentDataSet().getSelected();
        OsmPrimitive p = null;
        if (sel.size() >= 1) {
            p = (OsmPrimitive)sel.iterator().next();
        }
        if (Main.pref.getBoolean("utilsplugin2.askurl", false)) {
            ChooseURLAction.showConfigDialog(true);
        }
        LatLon center = Main.map.mapView.getLatLon(Main.map.mapView.getWidth() / 2, Main.map.mapView.getHeight() / 2);
        String addr = Main.pref.get("utilsplugin2.customurl", "http://ru.wikipedia.org/w/index.php?search={name}&fulltext=Search");
        Pattern pat = Pattern.compile("\\{([^\\}]*)\\}");
        Matcher m = pat.matcher(addr);
        String[] keys = new String[100];
        String[] vals = new String[100];
        int i = 0;
        try {
            while (m.find()) {
                String key = m.group(1);
                String val = null;
                if (key.equals("#id")) {
                    if (p != null) {
                        val = Long.toString(p.getId());
                    }
                } else if (key.equals("#type")) {
                    if (p != null) {
                        val = OsmPrimitiveType.from((IPrimitive)p).getAPIName();
                    }
                } else if (key.equals("#lat")) {
                    val = Double.toString(center.lat());
                } else if (key.equals("#lon")) {
                    val = Double.toString(center.lon());
                } else if (p != null) {
                    val = p.get(key);
                    if (val != null) {
                        val = URLEncoder.encode(p.get(key), "UTF-8");
                    } else {
                        return;
                    }
                }
                keys[i] = m.group();
                vals[i] = val != null ? val : "";
                ++i;
            }
        }
        catch (UnsupportedEncodingException ex) {
            System.err.println("Encoding error");
            return;
        }
        for (int j = 0; j < i; ++j) {
            addr = addr.replace(keys[j], vals[j]);
        }
        try {
            OpenBrowser.displayUrl((String)addr);
        }
        catch (Exception ex) {
            System.err.println("Can not open URL" + addr);
        }
    }

    protected void updateEnabledState() {
        if (OpenPageAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }
}

