/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tag2link.action;

import java.awt.event.ActionEvent;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.plugins.tag2link.Tag2LinkConstants;
import org.openstreetmap.josm.plugins.tag2link.data.Link;
import org.openstreetmap.josm.plugins.tag2link.data.LinkPost;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.OpenBrowser;

public class OpenLinkAction
extends JosmAction
implements Tag2LinkConstants {
    private Link link;

    public OpenLinkAction(Link link) {
        super(I18n.tr((String)link.name, (Object[])new Object[0]), "tag2linkv2_24x24.png", I18n.tr((String)"Launch browser with information about the selected object", (Object[])new Object[0]), null, false);
        this.link = link;
    }

    public void actionPerformed(ActionEvent e) {
        if (this.link instanceof LinkPost) {
            try {
                LinkPost lp = (LinkPost)this.link;
                System.out.println("Sending POST request to " + lp.url);
                HttpURLConnection conn = (HttpURLConnection)new URL(lp.url).openConnection();
                conn.setDoOutput(true);
                conn.setRequestMethod("POST");
                for (String header : lp.headers.keySet()) {
                    conn.setRequestProperty(header, lp.headers.get(header));
                }
                String data = "";
                for (String param : lp.params.keySet()) {
                    if (!data.isEmpty()) {
                        data = data + "&";
                    }
                    data = data + param + "=" + lp.params.get(param);
                }
                OutputStreamWriter osw = new OutputStreamWriter(conn.getOutputStream());
                osw.write(data);
                osw.flush();
                osw.close();
                String filename = "output.pdf";
                FileOutputStream fos = new FileOutputStream(filename);
                InputStream is = conn.getInputStream();
                byte[] buffer = new byte[2048];
                int n = -1;
                while ((n = is.read(buffer)) > -1) {
                    fos.write(buffer, 0, n);
                }
                is.close();
                fos.close();
                System.out.println("Opening " + filename);
                OpenBrowser.displayUrl((String)("file://" + filename));
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        } else {
            System.out.println("Opening " + this.link.url);
            OpenBrowser.displayUrl((String)this.link.url);
        }
    }
}

