/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.print;

import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.print.PrintAction;

public class PrintPlugin
extends Plugin {
    private JMenuItem printMenu;
    public static final int DEF_MAP_SCALE = 25000;
    public static final int DEF_RESOLUTION_DPI = 100;
    public static final String DEF_ATTRIBUTION = "OSM Map data (c) OpenStreetMap contributors, CC-BY-SA";

    public PrintPlugin(PluginInformation info) {
        super(info);
        JMenu fileMenu = Main.main.menu.fileMenu;
        int pos = fileMenu.getItemCount();
        while (fileMenu.getItem(--pos) != null && pos > 2) {
        }
        PrintAction printAction = new PrintAction();
        this.printMenu = fileMenu.insert((Action)((Object)printAction), pos);
        this.printMenu.setEnabled(false);
        this.printMenu.setVisible(true);
        KeyStroke ks = printAction.getShortcut().getKeyStroke();
        if (ks != null) {
            this.printMenu.setAccelerator(ks);
        }
        fileMenu.insertSeparator(pos);
        Main.pref.putDefault("print.map-scale", Integer.toString(25000));
        Main.pref.putDefault("print.resolution.dpi", Integer.toString(100));
        Main.pref.putDefault("print.attribution", DEF_ATTRIBUTION);
        Main.pref.putDefault("print.preview.enabled", new Boolean(false).toString());
        PrintPlugin.restorePrefs();
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        this.printMenu.setEnabled(newFrame != null);
    }

    public static void adjustPrefs() {
        if (!Main.pref.getBoolean("print.saved-prefs", false)) {
            Main.pref.put("print.saved-prefs", true);
            PrintPlugin.adjustPref("draw.data.downloaded_area", false);
            PrintPlugin.adjustPref("mappaint.node.connection-size", 0);
            PrintPlugin.adjustPref("mappaint.node.selected-size", 0);
            PrintPlugin.adjustPref("mappaint.node.tagged-size", 0);
            PrintPlugin.adjustPref("mappaint.node.unselected-size", 0);
            PrintPlugin.adjustPref("mappaint.node.virtual-size", 0);
        }
    }

    protected static void adjustPref(String key, int value) {
        if (Main.pref.hasKey(key)) {
            Main.pref.put("print.saved-prefs." + key, Main.pref.get(key));
        }
        Main.pref.putInteger(key, Integer.valueOf(value));
    }

    protected static void adjustPref(String key, boolean value) {
        if (Main.pref.hasKey(key)) {
            Main.pref.put("print.saved-prefs." + key, Main.pref.get(key));
        }
        Main.pref.put(key, value);
    }

    protected static void adjustPref(String key, String value) {
        if (Main.pref.hasKey(key)) {
            Main.pref.put("print.saved-prefs." + key, Main.pref.get(key));
        }
        Main.pref.put(key, value);
    }

    public static void restorePrefs() {
        if (Main.pref.getBoolean("print.saved-prefs", false)) {
            PrintPlugin.restorePref("draw.data.downloaded_area");
            PrintPlugin.restorePref("mappaint.node.connection-size");
            PrintPlugin.restorePref("mappaint.node.selected-size");
            PrintPlugin.restorePref("mappaint.node.tagged-size");
            PrintPlugin.restorePref("mappaint.node.unselected-size");
            PrintPlugin.restorePref("mappaint.node.virtual-size");
            Main.pref.put("print.saved-prefs", false);
        }
    }

    protected static void restorePref(String key) {
        String savedKey = "print.saved-prefs." + key;
        Main.pref.put(key, Main.pref.get(savedKey));
        Main.pref.put(savedKey, null);
    }
}

