/*
 * Decompiled with CFR 0.152.
 */
package relcontext.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import relcontext.ChosenRelation;
import relcontext.ChosenRelationListener;

public class DuplicateChosenRelationAction
extends AbstractAction
implements ChosenRelationListener {
    private ChosenRelation rel;

    public DuplicateChosenRelationAction(ChosenRelation rel) {
        super(I18n.tr((String)"Duplicate relation", (Object[])new Object[0]));
        this.putValue("SmallIcon", ImageProvider.get((String)"duplicate"));
        this.putValue("ShortDescription", I18n.tr((String)"Create a copy of this relation and open it in another editor window", (Object[])new Object[0]));
        this.rel = rel;
        rel.addChosenRelationListener(this);
        this.setEnabled(rel.get() != null);
    }

    public void actionPerformed(ActionEvent e) {
        Relation r = this.rel.get();
        Relation copy = new Relation(r, true);
        Main.main.undoRedo.add((Command)new AddCommand((OsmPrimitive)copy));
        this.rel.set(copy);
        if (Main.main.getCurrentDataSet() != null) {
            Main.main.getCurrentDataSet().setSelected(new PrimitiveId[]{copy});
        }
    }

    public void chosenRelationChanged(Relation oldRelation, Relation newRelation) {
        this.setEnabled(newRelation != null);
    }
}

