/*
 * Decompiled with CFR 0.152.
 */
package toms.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import toms.Messages;
import toms.seamarks.buoys.Buoy;
import toms.seamarks.buoys.BuoyCard;
import toms.seamarks.buoys.BuoyIsol;
import toms.seamarks.buoys.BuoyLat;
import toms.seamarks.buoys.BuoyNota;
import toms.seamarks.buoys.BuoySaw;
import toms.seamarks.buoys.BuoySpec;
import toms.seamarks.buoys.BuoyUkn;

public class SmpDialogAction
extends JosmAction {
    private static final long serialVersionUID = -2976230949744302905L;
    private SmpDialogAction dia = null;
    private Buoy buoy = null;
    private boolean isOpen = false;
    private Node onode = null;
    private Buoy obuoy = null;
    private JMenuItem SmpItem = null;
    private String smt = "";
    private String smb = "";
    private Collection<? extends OsmPrimitive> Selection = null;
    private OsmPrimitive SelNode = null;
    private String Os = "";
    private String UserHome = "";
    private SelectionChangedListener SmpListener = new SelectionChangedListener(){

        public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
            SmpDialogAction.this.Selection = newSelection;
            for (OsmPrimitive osm : SmpDialogAction.this.Selection) {
                if (!(osm instanceof Node)) continue;
                Node node = (Node)osm;
                if (SmpDialogAction.this.Selection.size() != 1 || node.compareTo(SmpDialogAction.this.SelNode) == 0) continue;
                SmpDialogAction.this.SelNode = (OsmPrimitive)node;
                SmpDialogAction.this.parseSeaMark();
                SmpDialogAction.this.buoy.paintSign();
            }
            SmpDialogAction.this.Selection = null;
        }
    };
    private JDialog dM01SeaMap = null;
    private JPanel pM01SeaMap = null;
    private JLabel lM01Head = null;
    private JLabel lM01Region = null;
    private JLabel lM02Region = null;
    public ButtonGroup bgM01Region = null;
    public JRadioButton rbM01RegionA = null;
    public JRadioButton rbM01RegionB = null;
    public JLabel lM01Icon = null;
    public JLabel lM02Icon = null;
    public JLabel lM03Icon = null;
    public JLabel lM04Icon = null;
    public JLabel lM05Icon = null;
    public JLabel lM06Icon = null;
    public JLabel lM01NameMark = null;
    public JLabel lM01FireMark = null;
    public JLabel lM01FogMark = null;
    public JLabel lM01RadarMark = null;
    private JLabel lM01TypeOfMark = null;
    public JComboBox cbM01TypeOfMark = null;
    public JLabel lM01CatOfMark = null;
    public JComboBox cbM01CatOfMark = null;
    public JLabel lM01StyleOfMark = null;
    public JComboBox cbM01StyleOfMark = null;
    private JLabel lM01Name = null;
    public JTextField tfM01Name = null;
    private JLabel lM01Props02 = null;
    public JCheckBox cM01TopMark = null;
    public JComboBox cbM01TopMark = null;
    public JCheckBox cM01Radar = null;
    public JCheckBox cM01Racon = null;
    public JComboBox cbM01Racon = null;
    public JTextField tfM01Racon = null;
    public JLabel lM01Racon = null;
    public JCheckBox cM01Fog = null;
    public JComboBox cbM01Fog = null;
    public JLabel lM01FogGroup = null;
    public JTextField tfM01FogGroup = null;
    public JLabel lM01FogPeriod = null;
    public JTextField tfM01FogPeriod = null;
    public JCheckBox cM01Fired = null;
    public ButtonGroup bgM01Fired = null;
    public JRadioButton rbM01Fired1 = null;
    public JRadioButton rbM01FiredN = null;
    public JLabel lM01Kennung = null;
    public JComboBox cbM01Kennung = null;
    public JLabel lM01Height = null;
    public JTextField tfM01Height = null;
    public JLabel lM01Range = null;
    public JTextField tfM01Range = null;
    public JLabel lM01Group = null;
    public JTextField tfM01Group = null;
    public JLabel lM01RepeatTime = null;
    public JTextField tfM01RepeatTime = null;
    public JLabel lM01Sector = null;
    public JComboBox cbM01Sector = null;
    public JLabel lM01Colour = null;
    public JComboBox cbM01Colour = null;
    public JLabel lM01Bearing = null;
    public JTextField tfM01Bearing = null;
    public JTextField tfM02Bearing = null;
    public JTextField tfM01Radius = null;
    public JButton bM01Save = null;
    public JButton bM01Close = null;
    public JCheckBox cM01IconVisible = null;
    public JTextField sM01StatusBar = null;
    public boolean paintlock = false;

    public JMenuItem getSmpItem() {
        return this.SmpItem;
    }

    public void setSmpItem(JMenuItem smpItem) {
        this.SmpItem = smpItem;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void setOpen(boolean isOpen) {
        this.isOpen = isOpen;
    }

    public String getOs() {
        return this.Os;
    }

    public void setOs(String os) {
        this.Os = os;
    }

    public String getUserHome() {
        return this.UserHome;
    }

    public void setUserHome(String userHome) {
        this.UserHome = userHome;
    }

    public SmpDialogAction() {
        super(Messages.getString("SmpDialogAction.4"), "Smp", Messages.getString("SmpDialogAction.0"), Shortcut.registerShortcut((String)"tools:Semarks", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{Messages.getString("SmpDialogAction.9")}), (int)83, (int)3, (int)1), true);
        this.dia = this;
        int l = 0;
        while (true) {
            String entry;
            String str;
            if ((str = Main.pref.get(entry = new String("mappaint.style.sources-list." + l))) == null || str.isEmpty()) {
                String sep = new String(new char[]{'\u001e'});
                Main.pref.put(entry, "http://dev.openseamap.org/josm/seamark_styles.xml" + sep + sep + "OpenSeaMap" + sep + "true");
                break;
            }
            if (str.contains("http://dev.openseamap.org/josm/seamark_styles.xml")) break;
            ++l;
        }
    }

    public void CloseDialog() {
        this.onode = null;
        DataSet.removeSelectionListener((SelectionChangedListener)this.SmpListener);
        this.Selection = null;
        if (this.isOpen) {
            this.dM01SeaMap.dispose();
        }
        this.isOpen = false;
    }

    public void actionPerformed(ActionEvent e) {
        this.onode = null;
        this.obuoy = null;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JDialog dialog = SmpDialogAction.this.getDM01SeaMap();
                if (SmpDialogAction.this.SmpItem == null) {
                    // empty if block
                }
                dialog.setVisible(true);
            }
        });
        this.setOpen(true);
        if (this.SmpItem == null) {
            return;
        }
        this.SmpItem.setEnabled(false);
        DataSet.addSelectionListener((SelectionChangedListener)this.SmpListener);
    }

    private void PicRebuild() {
        DataSet ds = Main.main.getCurrentDataSet();
        if (this.obuoy == null) {
            return;
        }
        Node n = this.obuoy.getNode();
        if (n != null) {
            ChangePropertyCommand c;
            if (this.smb != "") {
                c = new ChangePropertyCommand((OsmPrimitive)n, "seamark", this.smb);
                c.executeCommand();
                ds.fireSelectionChanged();
                this.smb = "";
            }
            if (this.smt != "") {
                c = new ChangePropertyCommand((OsmPrimitive)n, "seamark:type", this.smt);
                c.executeCommand();
                ds.fireSelectionChanged();
                this.smt = "";
            }
        }
        this.obuoy = null;
    }

    private void parseSeaMark() {
        int nodes = 0;
        Node node = null;
        Collection selection = null;
        DataSet ds = Main.main.getCurrentDataSet();
        if (ds == null) {
            this.buoy = new BuoyUkn(this, Messages.getString("SmpDialogAction.26"));
            this.buoy.setNode(null);
            return;
        }
        selection = ds.getSelectedNodes();
        nodes = selection.size();
        if (nodes == 0) {
            this.buoy = new BuoyUkn(this, Messages.getString("SmpDialogAction.27"));
            this.buoy.setNode(null);
            return;
        }
        if (nodes > 1) {
            this.buoy = new BuoyUkn(this, Messages.getString("SmpDialogAction.28"));
            this.buoy.setNode(null);
            return;
        }
        Iterator it = selection.iterator();
        node = (Node)it.next();
        if (this.onode != null && node.equals((Object)this.onode)) {
            return;
        }
        if (this.obuoy != null) {
            this.PicRebuild();
        }
        this.onode = node;
        this.cM01IconVisible.setEnabled(true);
        this.cM01IconVisible.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/images/Auge.png")));
        this.cbM01TypeOfMark.setEnabled(true);
        String type = "";
        String str = "";
        Map keys = node.getKeys();
        if (keys.containsKey("seamark:type")) {
            type = (String)keys.get("seamark:type");
        }
        if (type.equals("buoy_lateral") || type.equals("beacon_lateral")) {
            this.buoy = new BuoyLat(this, node);
            return;
        }
        if (type.equals("buoy_cardinal") || type.equals("beacon_cardinal")) {
            this.buoy = new BuoyCard(this, node);
            return;
        }
        if (type.equals("buoy_safe_water") || type.equals("beacon_safe_water")) {
            this.buoy = new BuoySaw(this, node);
            return;
        }
        if (type.equals("buoy_special_purpose") || type.equals("beacon_special_purpose")) {
            this.buoy = new BuoySpec(this, node);
            return;
        }
        if (type.equals("buoy_isolated_danger") || type.equals("beacon_isolated_danger")) {
            this.buoy = new BuoyIsol(this, node);
            return;
        }
        if (type.equals("landmark") || type.equals("light_vessel") || type.equals("light_major") || type.equals("light_minor")) {
            this.buoy = new BuoyNota(this, node);
            return;
        }
        if (type.equals("light_float")) {
            if (keys.containsKey("seamark:light_float:colour")) {
                str = (String)keys.get("seamark:light_float:colour");
                if (str.equals("red") || str.equals("green") || str.equals("red;green;red") || str.equals("green;red;green")) {
                    this.buoy = new BuoyLat(this, node);
                    return;
                }
                if (str.equals("black;yellow") || str.equals("black;yellow;black") || str.equals("yellow;black") || str.equals("yellow;black;yellow")) {
                    this.buoy = new BuoyCard(this, node);
                    return;
                }
                if (str.equals("black;red;black")) {
                    this.buoy = new BuoyIsol(this, node);
                    return;
                }
                if (str.equals("red;white")) {
                    this.buoy = new BuoySaw(this, node);
                    return;
                }
                if (str.equals("yellow")) {
                    this.buoy = new BuoySpec(this, node);
                    return;
                }
            } else if (keys.containsKey("seamark:light_float:topmark:shape")) {
                str = (String)keys.get("seamark:light_float:topmark:shape");
                if (str.equals("cylinder") || str.equals("cone, point up")) {
                    this.buoy = new BuoyLat(this, node);
                    return;
                }
            } else if (keys.containsKey("seamark:light_float:topmark:colour") && ((str = (String)keys.get("seamark:light_float:topmark:colour")).equals("red") || str.equals("green"))) {
                this.buoy = new BuoyLat(this, node);
                return;
            }
        }
        if (keys.containsKey("buoy_lateral:category") || keys.containsKey("beacon_lateral:category")) {
            this.buoy = new BuoyLat(this, node);
            return;
        }
        if (keys.containsKey("buoy_cardinal:category") || keys.containsKey("beacon_cardinal:category")) {
            this.buoy = new BuoyCard(this, node);
            return;
        }
        if (keys.containsKey("buoy_isolated_danger:category") || keys.containsKey("beacon_isolated_danger:category")) {
            this.buoy = new BuoyIsol(this, node);
            return;
        }
        if (keys.containsKey("buoy_safe_water:category") || keys.containsKey("beacon_safe_water:category")) {
            this.buoy = new BuoySaw(this, node);
            return;
        }
        if (keys.containsKey("buoy_special_purpose:category") || keys.containsKey("beacon_special_purpose:category")) {
            this.buoy = new BuoySpec(this, node);
            return;
        }
        if (keys.containsKey("buoy_lateral:shape") || keys.containsKey("beacon_lateral:shape")) {
            this.buoy = new BuoyLat(this, node);
            return;
        }
        if (keys.containsKey("buoy_cardinal:shape") || keys.containsKey("beacon_cardinal:shape")) {
            this.buoy = new BuoyCard(this, node);
            return;
        }
        if (keys.containsKey("buoy_isolated_danger:shape") || keys.containsKey("beacon_isolated_danger:shape")) {
            this.buoy = new BuoyIsol(this, node);
            return;
        }
        if (keys.containsKey("buoy_safe_water:shape") || keys.containsKey("beacon_safe_water:shape")) {
            this.buoy = new BuoySaw(this, node);
            return;
        }
        if (keys.containsKey("buoy_special_purpose:shape") || keys.containsKey("beacon_special_purpose:shape")) {
            this.buoy = new BuoySpec(this, node);
            return;
        }
        if (keys.containsKey("buoy_lateral:colour") || keys.containsKey("beacon_lateral:colour")) {
            this.buoy = new BuoyLat(this, node);
            return;
        }
        if (keys.containsKey("buoy_cardinal:colour") || keys.containsKey("beacon_cardinal:colour")) {
            this.buoy = new BuoyCard(this, node);
            return;
        }
        if (keys.containsKey("buoy_isolated_danger:colour") || keys.containsKey("beacon_isolated_danger:colour")) {
            this.buoy = new BuoyIsol(this, node);
            return;
        }
        if (keys.containsKey("buoy_safe_water:colour") || keys.containsKey("beacon_safe_water:colour")) {
            this.buoy = new BuoySaw(this, node);
            return;
        }
        if (keys.containsKey("buoy_special_purpose:colour") || keys.containsKey("beacon_special_purpose:colour")) {
            this.buoy = new BuoySpec(this, node);
            return;
        }
        this.buoy = new BuoyUkn(this, Messages.getString("SmpDialogAction.91"));
        this.buoy.setNode(node);
        this.buoy.paintSign();
    }

    private JDialog getDM01SeaMap() {
        if (this.dM01SeaMap == null) {
            this.dM01SeaMap = new JDialog();
            this.dM01SeaMap.setSize(new Dimension(400, 400));
            this.dM01SeaMap.setDefaultCloseOperation(2);
            this.dM01SeaMap.setModal(false);
            this.dM01SeaMap.setResizable(false);
            this.dM01SeaMap.setContentPane(this.getPM01SeaMap());
            this.dM01SeaMap.setTitle(Messages.getString("SmpDialogAction.9"));
            this.dM01SeaMap.setVisible(false);
            this.dM01SeaMap.setAlwaysOnTop(true);
            this.dM01SeaMap.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    if (SmpDialogAction.this.obuoy != null) {
                        SmpDialogAction.this.PicRebuild();
                    }
                    DataSet.removeSelectionListener((SelectionChangedListener)SmpDialogAction.this.SmpListener);
                    SmpDialogAction.this.Selection = null;
                    SmpDialogAction.this.SmpItem.setEnabled(true);
                }

                public void windowActivated(WindowEvent arg0) {
                    SmpDialogAction.this.parseSeaMark();
                    SmpDialogAction.this.buoy.paintSign();
                }
            });
        }
        return this.dM01SeaMap;
    }

    private JPanel getPM01SeaMap() {
        if (this.pM01SeaMap == null) {
            this.lM01Icon = new JLabel();
            this.lM01Icon.setBounds(new Rectangle(220, 20, 150, 200));
            this.lM01Icon.setIcon(null);
            this.lM01Icon.setText("");
            this.lM02Icon = new JLabel();
            this.lM02Icon.setBounds(new Rectangle(220, 20, 150, 200));
            this.lM02Icon.setIcon(null);
            this.lM02Icon.setText("");
            this.lM03Icon = new JLabel();
            this.lM03Icon.setBounds(new Rectangle(220, 20, 150, 200));
            this.lM03Icon.setIcon(null);
            this.lM03Icon.setText("");
            this.lM04Icon = new JLabel();
            this.lM04Icon.setBounds(new Rectangle(220, 20, 150, 200));
            this.lM04Icon.setIcon(null);
            this.lM04Icon.setText("");
            this.lM05Icon = new JLabel();
            this.lM05Icon.setBounds(new Rectangle(220, 20, 150, 200));
            this.lM05Icon.setIcon(null);
            this.lM05Icon.setText("");
            this.lM06Icon = new JLabel();
            this.lM06Icon.setBounds(new Rectangle(220, 20, 150, 200));
            this.lM06Icon.setIcon(null);
            this.lM06Icon.setText("");
            this.lM01FireMark = new JLabel();
            this.lM01FireMark.setBounds(new Rectangle(315, 85, 80, 20));
            this.lM01FireMark.setFont(new Font("Dialog", 0, 10));
            this.lM01FireMark.setText("");
            this.lM01NameMark = new JLabel();
            this.lM01NameMark.setBounds(new Rectangle(315, 65, 80, 20));
            this.lM01NameMark.setFont(new Font("Dialog", 0, 10));
            this.lM01NameMark.setText("");
            this.lM01FogMark = new JLabel();
            this.lM01FogMark.setBounds(new Rectangle(220, 85, 70, 20));
            this.lM01FogMark.setFont(new Font("Dialog", 0, 10));
            this.lM01FogMark.setText("");
            this.lM01RadarMark = new JLabel();
            this.lM01RadarMark.setBounds(new Rectangle(230, 65, 70, 20));
            this.lM01RadarMark.setFont(new Font("Dialog", 0, 10));
            this.lM01RadarMark.setText("");
            this.lM01Head = new JLabel();
            this.lM01Head.setBounds(new Rectangle(5, 3, 316, 16));
            this.lM01Head.setText(Messages.getString("SmpDialogAction.97"));
            this.lM01Region = new JLabel();
            this.lM01Region.setBounds(new Rectangle(220, 7, 120, 16));
            this.lM01Region.setFont(new Font("Dialog", 0, 12));
            this.lM01Region.setText(Messages.getString("SmpDialogAction.99"));
            this.lM02Region = new JLabel();
            this.lM02Region.setBounds(new Rectangle(270, 7, 120, 16));
            this.lM02Region.setFont(new Font("Dialog", 1, 12));
            this.lM02Region.setText(Messages.getString("SmpDialogAction.101"));
            this.lM01TypeOfMark = new JLabel();
            this.lM01TypeOfMark.setBounds(new Rectangle(5, 28, 120, 16));
            this.lM01TypeOfMark.setFont(new Font("Dialog", 0, 12));
            this.lM01TypeOfMark.setText(Messages.getString("SmpDialogAction.103"));
            this.lM01CatOfMark = new JLabel();
            this.lM01CatOfMark.setBounds(new Rectangle(5, 58, 120, 16));
            this.lM01CatOfMark.setFont(new Font("Dialog", 0, 12));
            this.lM01CatOfMark.setText(Messages.getString("SmpDialogAction.1"));
            this.lM01StyleOfMark = new JLabel();
            this.lM01StyleOfMark.setBounds(new Rectangle(5, 88, 148, 16));
            this.lM01StyleOfMark.setFont(new Font("Dialog", 0, 12));
            this.lM01StyleOfMark.setText(Messages.getString("SmpDialogAction.107"));
            this.lM01Name = new JLabel();
            this.lM01Name.setBounds(new Rectangle(5, 120, 82, 16));
            this.lM01Name.setFont(new Font("Dialog", 0, 12));
            this.lM01Name.setText(Messages.getString("SmpDialogAction.109"));
            this.lM01Props02 = new JLabel();
            this.lM01Props02.setBounds(new Rectangle(5, 150, 172, 16));
            this.lM01Props02.setFont(new Font("Dialog", 0, 12));
            this.lM01Props02.setText(Messages.getString("SmpDialogAction.111"));
            this.lM01Racon = new JLabel();
            this.lM01Racon.setBounds(new Rectangle(335, 195, 65, 20));
            this.lM01Racon.setFont(new Font("Dialog", 0, 12));
            this.lM01Racon.setText(Messages.getString("SmpDialogAction.113"));
            this.lM01FogGroup = new JLabel();
            this.lM01FogGroup.setBounds(new Rectangle(190, 220, 100, 20));
            this.lM01FogGroup.setFont(new Font("Dialog", 0, 12));
            this.lM01FogGroup.setText(Messages.getString("SmpDialogAction.115"));
            this.lM01FogPeriod = new JLabel();
            this.lM01FogPeriod.setBounds(new Rectangle(300, 220, 100, 20));
            this.lM01FogPeriod.setFont(new Font("Dialog", 0, 12));
            this.lM01FogPeriod.setText(Messages.getString("SmpDialogAction.117"));
            this.lM01Kennung = new JLabel();
            this.lM01Kennung.setBounds(new Rectangle(235, 245, 70, 20));
            this.lM01Kennung.setFont(new Font("Dialog", 0, 12));
            this.lM01Kennung.setText(Messages.getString("SmpDialogAction.119"));
            this.lM01Height = new JLabel();
            this.lM01Height.setBounds(new Rectangle(10, 270, 100, 20));
            this.lM01Height.setFont(new Font("Dialog", 0, 12));
            this.lM01Height.setText(Messages.getString("SmpDialogAction.121"));
            this.lM01Range = new JLabel();
            this.lM01Range.setBounds(new Rectangle(108, 270, 100, 20));
            this.lM01Range.setFont(new Font("Dialog", 0, 12));
            this.lM01Range.setText(Messages.getString("SmpDialogAction.123"));
            this.lM01Group = new JLabel();
            this.lM01Group.setBounds(new Rectangle(204, 270, 100, 20));
            this.lM01Group.setFont(new Font("Dialog", 0, 12));
            this.lM01Group.setText(Messages.getString("SmpDialogAction.125"));
            this.lM01RepeatTime = new JLabel();
            this.lM01RepeatTime.setBounds(new Rectangle(300, 270, 100, 20));
            this.lM01RepeatTime.setFont(new Font("Dialog", 0, 12));
            this.lM01RepeatTime.setText(Messages.getString("SmpDialogAction.127"));
            this.lM01Sector = new JLabel();
            this.lM01Sector.setBounds(new Rectangle(10, 295, 180, 20));
            this.lM01Sector.setFont(new Font("Dialog", 0, 12));
            this.lM01Sector.setText(Messages.getString("SmpDialogAction.129"));
            this.lM01Colour = new JLabel();
            this.lM01Colour.setBounds(new Rectangle(120, 295, 180, 20));
            this.lM01Colour.setFont(new Font("Dialog", 0, 12));
            this.lM01Colour.setText(Messages.getString("SmpDialogAction.131"));
            this.lM01Bearing = new JLabel();
            this.lM01Bearing.setBounds(new Rectangle(228, 295, 180, 20));
            this.lM01Bearing.setFont(new Font("Dialog", 0, 12));
            this.lM01Bearing.setText(Messages.getString("SmpDialogAction.133"));
            this.rbM01RegionA = new JRadioButton(Messages.getString("SmpDialogAction.134"), Main.pref.get("tomsplugin.IALA").equals("A"));
            this.rbM01RegionA.setBounds(new Rectangle(305, 0, 50, 30));
            this.rbM01RegionB = new JRadioButton("-B", Main.pref.get("tomsplugin.IALA").equals("B"));
            this.rbM01RegionB.setBounds(new Rectangle(352, 0, 50, 30));
            this.bgM01Region = new ButtonGroup();
            this.bgM01Region.add(this.rbM01RegionA);
            this.bgM01Region.add(this.rbM01RegionB);
            ActionListener alM01Region = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (SmpDialogAction.this.buoy instanceof BuoyLat) {
                        SmpDialogAction.this.buoy.setRegion(SmpDialogAction.this.rbM01RegionB.isSelected());
                        SmpDialogAction.this.buoy.setLightColour();
                        SmpDialogAction.this.buoy.paintSign();
                    }
                }
            };
            this.rbM01RegionA.addActionListener(alM01Region);
            this.rbM01RegionB.addActionListener(alM01Region);
            this.rbM01Fired1 = new JRadioButton(Messages.getString("SmpDialogAction.140"), true);
            this.rbM01Fired1.setBounds(new Rectangle(85, 240, 70, 30));
            this.rbM01FiredN = new JRadioButton(Messages.getString("SmpDialogAction.141"), false);
            this.rbM01FiredN.setBounds(new Rectangle(155, 240, 80, 30));
            this.bgM01Fired = new ButtonGroup();
            this.bgM01Fired.add(this.rbM01Fired1);
            this.bgM01Fired.add(this.rbM01FiredN);
            ActionListener alM01Fired = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SmpDialogAction.this.buoy.setSectored(SmpDialogAction.this.rbM01FiredN.isSelected());
                    SmpDialogAction.this.cbM01Sector.setSelectedIndex(0);
                    SmpDialogAction.this.buoy.setSectorIndex(0);
                    SmpDialogAction.this.buoy.paintSign();
                }
            };
            this.rbM01Fired1.addActionListener(alM01Fired);
            this.rbM01FiredN.addActionListener(alM01Fired);
            this.pM01SeaMap = new JPanel();
            this.pM01SeaMap.setLayout(null);
            this.pM01SeaMap.add((Component)this.lM01Head, null);
            this.pM01SeaMap.add((Component)this.rbM01RegionA, null);
            this.pM01SeaMap.add((Component)this.rbM01RegionB, null);
            this.pM01SeaMap.add((Component)this.lM01Region, null);
            this.pM01SeaMap.add((Component)this.lM02Region, null);
            this.pM01SeaMap.add((Component)this.lM01Icon, null);
            this.pM01SeaMap.add((Component)this.lM02Icon, null);
            this.pM01SeaMap.add((Component)this.lM03Icon, null);
            this.pM01SeaMap.add((Component)this.lM04Icon, null);
            this.pM01SeaMap.add((Component)this.lM05Icon, null);
            this.pM01SeaMap.add((Component)this.lM06Icon, null);
            this.pM01SeaMap.add((Component)this.getCbM01TypeOfMark(), null);
            this.pM01SeaMap.add((Component)this.lM01TypeOfMark, null);
            this.pM01SeaMap.add((Component)this.getCbM01CatOfMark(), null);
            this.pM01SeaMap.add((Component)this.lM01CatOfMark, null);
            this.pM01SeaMap.add((Component)this.getCbM01StyleOfMark(), null);
            this.pM01SeaMap.add((Component)this.lM01StyleOfMark, null);
            this.pM01SeaMap.add((Component)this.lM01Name, null);
            this.pM01SeaMap.add((Component)this.getTfM01Name(), null);
            this.pM01SeaMap.add((Component)this.lM01Props02, null);
            this.pM01SeaMap.add((Component)this.getCM01TopMark(), null);
            this.pM01SeaMap.add((Component)this.getCbM01TopMark(), null);
            this.pM01SeaMap.add((Component)this.getCM01Radar(), null);
            this.pM01SeaMap.add((Component)this.getCM01Racon(), null);
            this.pM01SeaMap.add((Component)this.getCbM01Racon(), null);
            this.pM01SeaMap.add((Component)this.getTfM01Racon(), null);
            this.pM01SeaMap.add((Component)this.lM01Racon, null);
            this.pM01SeaMap.add((Component)this.getCM01Fog(), null);
            this.pM01SeaMap.add((Component)this.getCbM01Fog(), null);
            this.pM01SeaMap.add((Component)this.getTfM01FogGroup(), null);
            this.pM01SeaMap.add((Component)this.lM01FogGroup, null);
            this.pM01SeaMap.add((Component)this.getTfM01FogPeriod(), null);
            this.pM01SeaMap.add((Component)this.lM01FogPeriod, null);
            this.pM01SeaMap.add((Component)this.getCM01Fired(), null);
            this.pM01SeaMap.add((Component)this.rbM01Fired1, null);
            this.pM01SeaMap.add((Component)this.rbM01FiredN, null);
            this.pM01SeaMap.add((Component)this.getTfM01RepeatTime(), null);
            this.pM01SeaMap.add((Component)this.lM01RepeatTime, null);
            this.pM01SeaMap.add((Component)this.getCbM01Kennung(), null);
            this.pM01SeaMap.add((Component)this.lM01Kennung, null);
            this.pM01SeaMap.add((Component)this.lM01Group, null);
            this.pM01SeaMap.add((Component)this.getTfM01Group(), null);
            this.pM01SeaMap.add((Component)this.lM01Sector, null);
            this.pM01SeaMap.add((Component)this.getCbM01Sector(), null);
            this.pM01SeaMap.add((Component)this.lM01Colour, null);
            this.pM01SeaMap.add((Component)this.getCbM01Colour(), null);
            this.pM01SeaMap.add((Component)this.lM01Bearing, null);
            this.pM01SeaMap.add((Component)this.getTfM01Bearing(), null);
            this.pM01SeaMap.add((Component)this.getTfM02Bearing(), null);
            this.pM01SeaMap.add((Component)this.getTfM01Radius(), null);
            this.pM01SeaMap.add((Component)this.lM01Height, null);
            this.pM01SeaMap.add((Component)this.getTfM01Height(), null);
            this.pM01SeaMap.add((Component)this.lM01Range, null);
            this.pM01SeaMap.add((Component)this.getTfM01Range(), null);
            this.pM01SeaMap.add((Component)this.lM01FireMark, null);
            this.pM01SeaMap.add((Component)this.lM01NameMark, null);
            this.pM01SeaMap.add((Component)this.lM01FogMark, null);
            this.pM01SeaMap.add((Component)this.lM01RadarMark, null);
            this.pM01SeaMap.add((Component)this.getBM01Save(), null);
            this.pM01SeaMap.add((Component)this.getSM01StatusBar(), null);
            this.pM01SeaMap.add((Component)this.getBM01Close(), null);
            this.pM01SeaMap.add((Component)this.getCM01IconVisible(), null);
        }
        return this.pM01SeaMap;
    }

    private JComboBox getCbM01TypeOfMark() {
        if (this.cbM01TypeOfMark == null) {
            this.cbM01TypeOfMark = new JComboBox();
            this.cbM01TypeOfMark.addItem(Messages.getString("SmpDialogAction.142"));
            this.cbM01TypeOfMark.addItem(Messages.getString("SmpDialogAction.143"));
            this.cbM01TypeOfMark.addItem(Messages.getString("SmpDialogAction.144"));
            this.cbM01TypeOfMark.addItem(Messages.getString("SmpDialogAction.145"));
            this.cbM01TypeOfMark.addItem(Messages.getString("SmpDialogAction.146"));
            this.cbM01TypeOfMark.addItem(Messages.getString("SmpDialogAction.147"));
            this.cbM01TypeOfMark.addItem(Messages.getString("SmpDialogAction.148"));
            this.cbM01TypeOfMark.setBounds(new Rectangle(50, 25, 170, 25));
            this.cbM01TypeOfMark.setFont(new Font("Dialog", 0, 12));
            this.cbM01TypeOfMark.setEnabled(true);
            this.cbM01TypeOfMark.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int type = SmpDialogAction.this.cbM01TypeOfMark.getSelectedIndex();
                    if (SmpDialogAction.this.buoy == null) {
                        SmpDialogAction.this.buoy = new BuoyUkn(SmpDialogAction.this.dia, Messages.getString("SmpDialogAction.150"));
                        SmpDialogAction.this.buoy.paintSign();
                        return;
                    }
                    Node n = SmpDialogAction.this.buoy.getNode();
                    if (n == null) {
                        return;
                    }
                    SmpDialogAction.this.paintlock = true;
                    switch (type) {
                        case 0: {
                            if (!(SmpDialogAction.this.buoy instanceof BuoyUkn)) {
                                SmpDialogAction.this.buoy = null;
                                SmpDialogAction.this.buoy = new BuoyUkn(SmpDialogAction.this.dia, Messages.getString("SmpDialogAction.150"));
                            }
                            SmpDialogAction.this.buoy.setBuoyIndex(0);
                            break;
                        }
                        case 1: {
                            if (SmpDialogAction.this.buoy instanceof BuoyLat) break;
                            SmpDialogAction.this.buoy = null;
                            SmpDialogAction.this.buoy = new BuoyLat(SmpDialogAction.this.dia, n);
                            SmpDialogAction.this.buoy.setBuoyIndex(0);
                            break;
                        }
                        case 2: {
                            if (SmpDialogAction.this.buoy instanceof BuoyCard) break;
                            SmpDialogAction.this.buoy = null;
                            SmpDialogAction.this.buoy = new BuoyCard(SmpDialogAction.this.dia, n);
                            SmpDialogAction.this.buoy.setBuoyIndex(0);
                            break;
                        }
                        case 3: {
                            if (!(SmpDialogAction.this.buoy instanceof BuoySaw)) {
                                SmpDialogAction.this.buoy = null;
                                SmpDialogAction.this.buoy = new BuoySaw(SmpDialogAction.this.dia, n);
                            }
                            SmpDialogAction.this.buoy.setBuoyIndex(type);
                            break;
                        }
                        case 4: {
                            if (!(SmpDialogAction.this.buoy instanceof BuoyIsol)) {
                                SmpDialogAction.this.buoy = null;
                                SmpDialogAction.this.buoy = new BuoyIsol(SmpDialogAction.this.dia, n);
                            }
                            SmpDialogAction.this.buoy.setBuoyIndex(type);
                            break;
                        }
                        case 5: {
                            if (!(SmpDialogAction.this.buoy instanceof BuoySpec)) {
                                SmpDialogAction.this.buoy = null;
                                SmpDialogAction.this.buoy = new BuoySpec(SmpDialogAction.this.dia, n);
                            }
                            SmpDialogAction.this.buoy.setBuoyIndex(type);
                            break;
                        }
                        case 6: {
                            if (SmpDialogAction.this.buoy instanceof BuoyNota) break;
                            SmpDialogAction.this.buoy = null;
                            SmpDialogAction.this.buoy = new BuoyNota(SmpDialogAction.this.dia, n);
                            SmpDialogAction.this.buoy.setBuoyIndex(0);
                        }
                    }
                    SmpDialogAction.this.buoy.refreshLights();
                    SmpDialogAction.this.buoy.setLightColour();
                    SmpDialogAction.this.paintlock = false;
                    SmpDialogAction.this.buoy.paintSign();
                }
            });
        }
        return this.cbM01TypeOfMark;
    }

    private JComboBox getCbM01CatOfMark() {
        if (this.cbM01CatOfMark == null) {
            this.cbM01CatOfMark = new JComboBox();
            this.cbM01CatOfMark.setBounds(new Rectangle(65, 55, 155, 25));
            this.cbM01CatOfMark.setFont(new Font("Dialog", 0, 12));
            this.cbM01CatOfMark.setEnabled(true);
            this.cbM01CatOfMark.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (SmpDialogAction.this.buoy == null) {
                        return;
                    }
                    SmpDialogAction.this.buoy.setBuoyIndex(SmpDialogAction.this.cbM01CatOfMark.getSelectedIndex());
                    SmpDialogAction.this.buoy.refreshStyles();
                    SmpDialogAction.this.buoy.refreshLights();
                    SmpDialogAction.this.buoy.setLightColour();
                    SmpDialogAction.this.buoy.paintSign();
                }
            });
        }
        return this.cbM01CatOfMark;
    }

    private JComboBox getCbM01StyleOfMark() {
        if (this.cbM01StyleOfMark == null) {
            this.cbM01StyleOfMark = new JComboBox();
            this.cbM01StyleOfMark.setBounds(new Rectangle(50, 85, 170, 25));
            this.cbM01StyleOfMark.setFont(new Font("Dialog", 0, 12));
            this.cbM01StyleOfMark.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (SmpDialogAction.this.buoy == null) {
                        return;
                    }
                    SmpDialogAction.this.buoy.setStyleIndex(SmpDialogAction.this.cbM01StyleOfMark.getSelectedIndex());
                    SmpDialogAction.this.buoy.refreshLights();
                    SmpDialogAction.this.buoy.setLightColour();
                    SmpDialogAction.this.buoy.paintSign();
                }
            });
        }
        return this.cbM01StyleOfMark;
    }

    private JTextField getTfM01Name() {
        if (this.tfM01Name == null) {
            this.tfM01Name = new JTextField();
            this.tfM01Name.setBounds(new Rectangle(50, 120, 150, 20));
            this.tfM01Name.addFocusListener(new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    if (SmpDialogAction.this.buoy == null) {
                        return;
                    }
                    SmpDialogAction.this.buoy.setName(SmpDialogAction.this.tfM01Name.getText());
                    SmpDialogAction.this.buoy.paintSign();
                }
            });
        }
        return this.tfM01Name;
    }

    private JCheckBox getCM01TopMark() {
        if (this.cM01TopMark == null) {
            this.cM01TopMark = new JCheckBox();
            this.cM01TopMark.setBounds(new Rectangle(10, 170, 100, 20));
            this.cM01TopMark.setFont(new Font("Dialog", 0, 12));
            this.cM01TopMark.setText(Messages.getString("SmpDialogAction.166"));
            this.cM01TopMark.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (SmpDialogAction.this.buoy == null) {
                        return;
                    }
                    SmpDialogAction.this.buoy.setTopMark(SmpDialogAction.this.cM01TopMark.isSelected());
                    SmpDialogAction.this.buoy.paintSign();
                }
            });
        }
        return this.cM01TopMark;
    }

    private JComboBox getCbM01TopMark() {
        if (this.cbM01TopMark == null) {
            this.cbM01TopMark = new JComboBox();
            this.cbM01TopMark.setBounds(new Rectangle(110, 170, 80, 20));
            this.cbM01TopMark.setFont(new Font("Dialog", 0, 12));
            this.cbM01TopMark.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (SmpDialogAction.this.buoy == null) {
                        return;
                    }
                    SmpDialogAction.this.buoy.setTopMarkIndex(SmpDialogAction.this.cbM01TopMark.getSelectedIndex());
                    SmpDialogAction.this.buoy.paintSign();
                }
            });
        }
        return this.cbM01TopMark;
    }

    private JCheckBox getCM01Radar() {
        if (this.cM01Radar == null) {
            this.cM01Radar = new JCheckBox();
            this.cM01Radar.setBounds(new Rectangle(10, 195, 120, 20));
            this.cM01Radar.setFont(new Font("Dialog", 0, 12));
            this.cM01Radar.setText(Messages.getString("SmpDialogAction.169"));
            this.cM01Radar.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (SmpDialogAction.this.buoy == null) {
                        return;
                    }
                    if (SmpDialogAction.this.cM01Radar.isSelected()) {
                        SmpDialogAction.this.buoy.setRadar(true);
                        SmpDialogAction.this.buoy.setRacon(false);
                        SmpDialogAction.this.cM01Racon.setSelected(false);
                    } else {
                        SmpDialogAction.this.buoy.setRadar(false);
                    }
                    SmpDialogAction.this.buoy.paintSign();
                }
            });
        }
        return this.cM01Radar;
    }

    private JCheckBox getCM01Racon() {
        if (this.cM01Racon == null) {
            this.cM01Racon = new JCheckBox();
            this.cM01Racon.setBounds(new Rectangle(130, 195, 110, 20));
            this.cM01Racon.setFont(new Font("Dialog", 0, 12));
            this.cM01Racon.setText(Messages.getString("SmpDialogAction.171"));
            this.cM01Racon.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (SmpDialogAction.this.buoy == null) {
                        return;
                    }
                    if (SmpDialogAction.this.cM01Racon.isSelected()) {
                        SmpDialogAction.this.buoy.setRacon(true);
                        SmpDialogAction.this.buoy.setRadar(false);
                        SmpDialogAction.this.cM01Radar.setSelected(false);
                    } else {
                        SmpDialogAction.this.buoy.setRacon(false);
                    }
                    SmpDialogAction.this.buoy.paintSign();
                }
            });
        }
        return this.cM01Racon;
    }

    private JComboBox getCbM01Racon() {
        if (this.cbM01Racon == null) {
            this.cbM01Racon = new JComboBox();
            this.cbM01Racon.setBounds(new Rectangle(240, 195, 80, 20));
            this.cbM01Racon.setFont(new Font("Dialog", 0, 12));
            this.cbM01Racon.removeAllItems();
            this.cbM01Racon.addItem(Messages.getString("SmpDialogAction.8"));
            this.cbM01Racon.addItem(Messages.getString("SmpDialogAction.10"));
            this.cbM01Racon.addItem(Messages.getString("SmpDialogAction.11"));
            this.cbM01Racon.addItem(Messages.getString("SmpDialogAction.12"));
            this.cbM01Racon.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (SmpDialogAction.this.buoy == null) {
                        return;
                    }
                    int rac = SmpDialogAction.this.cbM01Racon.getSelectedIndex();
                    SmpDialogAction.this.buoy.setRaType(rac);
                    SmpDialogAction.this.buoy.paintSign();
                }
            });
        }
        return this.cbM01Racon;
    }

    private JTextField getTfM01Racon() {
        if (this.tfM01Racon == null) {
            this.tfM01Racon = new JTextField();
            this.tfM01Racon.setBounds(new Rectangle(345, 195, 30, 20));
            this.tfM01Racon.addFocusListener(new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    if (SmpDialogAction.this.buoy == null) {
                        return;
                    }
                    SmpDialogAction.this.buoy.setRaconGroup(SmpDialogAction.this.tfM01Racon.getText().trim());
                    SmpDialogAction.this.buoy.paintSign();
                }
            });
        }
        return this.tfM01Racon;
    }

    private JCheckBox getCM01Fog() {
        if (this.cM01Fog == null) {
            this.cM01Fog = new JCheckBox();
            this.cM01Fog.setBounds(new Rectangle(10, 220, 90, 20));
            this.cM01Fog.setFont(new Font("Dialog", 0, 12));
            this.cM01Fog.setText(Messages.getString("SmpDialogAction.174"));
            this.cM01Fog.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (SmpDialogAction.this.buoy == null) {
                        return;
                    }
                    SmpDialogAction.this.buoy.setFog(SmpDialogAction.this.cM01Fog.isSelected());
                    SmpDialogAction.this.buoy.paintSign();
                }
            });
        }
        return this.cM01Fog;
    }

    private JComboBox getCbM01Fog() {
        if (this.cbM01Fog == null) {
            this.cbM01Fog = new JComboBox();
            this.cbM01Fog.setBounds(new Rectangle(100, 220, 75, 20));
            this.cbM01Fog.setFont(new Font("Dialog", 0, 12));
            this.cbM01Fog.removeAllItems();
            this.cbM01Fog.addItem(Messages.getString("SmpDialogAction.8"));
            this.cbM01Fog.addItem(Messages.getString("SmpDialogAction.14"));
            this.cbM01Fog.addItem(Messages.getString("SmpDialogAction.15"));
            this.cbM01Fog.addItem(Messages.getString("SmpDialogAction.16"));
            this.cbM01Fog.addItem(Messages.getString("SmpDialogAction.17"));
            this.cbM01Fog.addItem(Messages.getString("SmpDialogAction.18"));
            this.cbM01Fog.addItem(Messages.getString("SmpDialogAction.19"));
            this.cbM01Fog.addItem(Messages.getString("SmpDialogAction.20"));
            this.cbM01Fog.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (SmpDialogAction.this.buoy == null) {
                        return;
                    }
                    if (SmpDialogAction.this.cbM01Fog.getSelectedIndex() > 0) {
                        SmpDialogAction.this.buoy.setFogSound(SmpDialogAction.this.cbM01Fog.getSelectedIndex());
                    } else {
                        SmpDialogAction.this.buoy.setFogSound(0);
                    }
                    SmpDialogAction.this.buoy.paintSign();
                }
            });
        }
        return this.cbM01Fog;
    }

    private JTextField getTfM01FogGroup() {
        if (this.tfM01FogGroup == null) {
            this.tfM01FogGroup = new JTextField();
            this.tfM01FogGroup.setBounds(new Rectangle(243, 220, 30, 20));
            this.tfM01FogGroup.addFocusListener(new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    if (SmpDialogAction.this.buoy == null) {
                        return;
                    }
                    SmpDialogAction.this.buoy.setFogGroup(SmpDialogAction.this.tfM01FogGroup.getText().trim());
                    SmpDialogAction.this.buoy.paintSign();
                }
            });
        }
        return this.tfM01FogGroup;
    }

    private JTextField getTfM01FogPeriod() {
        if (this.tfM01FogPeriod == null) {
            this.tfM01FogPeriod = new JTextField();
            this.tfM01FogPeriod.setBounds(new Rectangle(345, 220, 30, 20));
            this.tfM01FogPeriod.addFocusListener(new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    if (SmpDialogAction.this.buoy == null) {
                        return;
                    }
                    SmpDialogAction.this.buoy.setFogPeriod(SmpDialogAction.this.tfM01FogPeriod.getText().trim());
                    SmpDialogAction.this.buoy.paintSign();
                }
            });
        }
        return this.tfM01FogPeriod;
    }

    private JCheckBox getCM01Fired() {
        if (this.cM01Fired == null) {
            this.cM01Fired = new JCheckBox();
            this.cM01Fired.setBounds(new Rectangle(10, 245, 75, 20));
            this.cM01Fired.setFont(new Font("Dialog", 0, 12));
            this.cM01Fired.setText(Messages.getString("SmpDialogAction.177"));
            this.cM01Fired.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (SmpDialogAction.this.buoy == null) {
                        return;
                    }
                    SmpDialogAction.this.buoy.setFired(SmpDialogAction.this.cM01Fired.isSelected());
                    SmpDialogAction.this.buoy.setLightColour();
                    SmpDialogAction.this.buoy.paintSign();
                }
            });
        }
        return this.cM01Fired;
    }

    private JComboBox getCbM01Kennung() {
        if (this.cbM01Kennung == null) {
            this.cbM01Kennung = new JComboBox();
            this.cbM01Kennung.setBounds(new Rectangle(300, 245, 75, 20));
            this.cbM01Kennung.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String c = "";
                    String it = (String)SmpDialogAction.this.cbM01Kennung.getSelectedItem();
                    if (it == null) {
                        return;
                    }
                    if (it.equals(Messages.getString("SmpDialogAction.212"))) {
                        return;
                    }
                    if (SmpDialogAction.this.buoy == null) {
                        return;
                    }
                    if (it.contains("(")) {
                        int i1 = it.indexOf("(");
                        int i2 = it.indexOf(")");
                        c = it.substring(i1 + 1, i2);
                        it = it.substring(0, i1) + it.substring(i2 + 1);
                    }
                    if (!c.isEmpty()) {
                        SmpDialogAction.this.buoy.setLightGroup(c);
                    }
                    SmpDialogAction.this.buoy.setLightChar(it);
                    SmpDialogAction.this.buoy.paintSign();
                }
            });
        }
        return this.cbM01Kennung;
    }

    private JTextField getTfM01Height() {
        if (this.tfM01Height == null) {
            this.tfM01Height = new JTextField();
            this.tfM01Height.setBounds(new Rectangle(54, 270, 30, 20));
            this.tfM01Height.addFocusListener(new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    if (SmpDialogAction.this.buoy == null) {
                        return;
                    }
                    SmpDialogAction.this.buoy.setHeight(SmpDialogAction.this.tfM01Height.getText().trim());
                    SmpDialogAction.this.buoy.paintSign();
                }
            });
        }
        return this.tfM01Height;
    }

    private JTextField getTfM01Range() {
        if (this.tfM01Range == null) {
            this.tfM01Range = new JTextField();
            this.tfM01Range.setBounds(new Rectangle(151, 270, 30, 20));
            this.tfM01Range.addFocusListener(new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    if (SmpDialogAction.this.buoy == null) {
                        return;
                    }
                    SmpDialogAction.this.buoy.setRange(SmpDialogAction.this.tfM01Range.getText().trim());
                    SmpDialogAction.this.buoy.paintSign();
                }
            });
        }
        return this.tfM01Range;
    }

    private JTextField getTfM01Group() {
        if (this.tfM01Group == null) {
            this.tfM01Group = new JTextField();
            this.tfM01Group.setBounds(new Rectangle(255, 270, 30, 20));
            this.tfM01Group.addFocusListener(new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    if (SmpDialogAction.this.buoy == null) {
                        return;
                    }
                    SmpDialogAction.this.buoy.setLightGroup(SmpDialogAction.this.tfM01Group.getText().trim());
                    SmpDialogAction.this.buoy.paintSign();
                }
            });
        }
        return this.tfM01Group;
    }

    private JTextField getTfM01RepeatTime() {
        if (this.tfM01RepeatTime == null) {
            this.tfM01RepeatTime = new JTextField();
            this.tfM01RepeatTime.setBounds(new Rectangle(345, 270, 30, 20));
            this.tfM01RepeatTime.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (SmpDialogAction.this.buoy == null) {
                        return;
                    }
                    SmpDialogAction.this.buoy.setLightPeriod(SmpDialogAction.this.tfM01RepeatTime.getText().trim());
                    SmpDialogAction.this.buoy.paintSign();
                }
            });
            this.tfM01RepeatTime.addFocusListener(new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    if (SmpDialogAction.this.buoy == null) {
                        return;
                    }
                    SmpDialogAction.this.buoy.setLightPeriod(SmpDialogAction.this.tfM01RepeatTime.getText().trim());
                    SmpDialogAction.this.buoy.paintSign();
                }
            });
        }
        return this.tfM01RepeatTime;
    }

    private JComboBox getCbM01Colour() {
        if (this.cbM01Colour == null) {
            this.cbM01Colour = new JComboBox();
            this.cbM01Colour.setBounds(new Rectangle(165, 295, 40, 20));
            this.cbM01Colour.setFont(new Font("Dialog", 0, 12));
            this.cbM01Colour.addItem("");
            this.cbM01Colour.addItem(Messages.getString("SmpDialogAction.190"));
            this.cbM01Colour.addItem(Messages.getString("SmpDialogAction.191"));
            this.cbM01Colour.addItem(Messages.getString("SmpDialogAction.192"));
            this.cbM01Colour.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (SmpDialogAction.this.buoy == null) {
                        return;
                    }
                    SmpDialogAction.this.buoy.setLightColour((String)SmpDialogAction.this.cbM01Colour.getSelectedItem());
                    SmpDialogAction.this.buoy.paintSign();
                }
            });
        }
        return this.cbM01Colour;
    }

    private JComboBox getCbM01Sector() {
        if (this.cbM01Sector == null) {
            this.cbM01Sector = new JComboBox();
            this.cbM01Sector.setBounds(new Rectangle(55, 295, 50, 20));
            this.cbM01Sector.setFont(new Font("Dialog", 0, 12));
            this.cbM01Sector.addItem(Messages.getString("SmpDialogAction.194"));
            this.cbM01Sector.addItem(Messages.getString("SmpDialogAction.195"));
            this.cbM01Sector.addItem(Messages.getString("SmpDialogAction.196"));
            this.cbM01Sector.addItem(Messages.getString("SmpDialogAction.197"));
            this.cbM01Sector.addItem(Messages.getString("SmpDialogAction.198"));
            this.cbM01Sector.addItem(Messages.getString("SmpDialogAction.199"));
            this.cbM01Sector.addItem(Messages.getString("SmpDialogAction.200"));
            this.cbM01Sector.addItem(Messages.getString("SmpDialogAction.201"));
            this.cbM01Sector.addItem(Messages.getString("SmpDialogAction.202"));
            this.cbM01Sector.addItem(Messages.getString("SmpDialogAction.203"));
            this.cbM01Sector.addItem("10");
            this.cbM01Sector.addItem("11");
            this.cbM01Sector.addItem("12");
            this.cbM01Sector.addItem("13");
            this.cbM01Sector.addItem("14");
            this.cbM01Sector.addItem("15");
            this.cbM01Sector.addItem("16");
            this.cbM01Sector.addItem("17");
            this.cbM01Sector.addItem("18");
            this.cbM01Sector.addItem("19");
            this.cbM01Sector.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (SmpDialogAction.this.buoy == null) {
                        return;
                    }
                    SmpDialogAction.this.buoy.setSectorIndex(SmpDialogAction.this.cbM01Sector.getSelectedIndex());
                    SmpDialogAction.this.buoy.paintSign();
                }
            });
        }
        return this.cbM01Sector;
    }

    private JTextField getTfM01Bearing() {
        if (this.tfM01Bearing == null) {
            this.tfM01Bearing = new JTextField();
            this.tfM01Bearing.setBounds(new Rectangle(255, 295, 30, 20));
            this.tfM01Bearing.addFocusListener(new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    if (SmpDialogAction.this.buoy == null) {
                        return;
                    }
                    SmpDialogAction.this.buoy.setBearing1(SmpDialogAction.this.tfM01Bearing.getText().trim());
                }
            });
        }
        return this.tfM01Bearing;
    }

    private JTextField getTfM02Bearing() {
        if (this.tfM02Bearing == null) {
            this.tfM02Bearing = new JTextField();
            this.tfM02Bearing.setBounds(new Rectangle(300, 295, 30, 20));
            this.tfM02Bearing.addFocusListener(new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    SmpDialogAction.this.buoy.setBearing2(SmpDialogAction.this.tfM02Bearing.getText().trim());
                }
            });
        }
        return this.tfM02Bearing;
    }

    private JTextField getTfM01Radius() {
        if (this.tfM01Radius == null) {
            this.tfM01Radius = new JTextField();
            this.tfM01Radius.setBounds(new Rectangle(355, 295, 30, 20));
            this.tfM01Radius.addFocusListener(new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    if (SmpDialogAction.this.buoy == null) {
                        return;
                    }
                    SmpDialogAction.this.buoy.setRadius(SmpDialogAction.this.tfM01Radius.getText().trim());
                }
            });
        }
        return this.tfM01Radius;
    }

    private JButton getBM01Close() {
        if (this.bM01Close == null) {
            this.bM01Close = new JButton();
            this.bM01Close.setBounds(new Rectangle(20, 325, 110, 20));
            this.bM01Close.setText(I18n.tr((String)"Close", (Object[])new Object[0]));
            this.bM01Close.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (SmpDialogAction.this.obuoy != null) {
                        SmpDialogAction.this.PicRebuild();
                    }
                    DataSet.removeSelectionListener((SelectionChangedListener)SmpDialogAction.this.SmpListener);
                    SmpDialogAction.this.Selection = null;
                    SmpDialogAction.this.SmpItem.setEnabled(true);
                    SmpDialogAction.this.onode = null;
                    SmpDialogAction.this.dM01SeaMap.dispose();
                }
            });
        }
        return this.bM01Close;
    }

    private JButton getBM01Save() {
        if (this.bM01Save == null) {
            this.bM01Save = new JButton();
            this.bM01Save.setBounds(new Rectangle(150, 325, 110, 20));
            this.bM01Save.setText(I18n.tr((String)"Save", (Object[])new Object[0]));
            this.bM01Save.setEnabled(false);
            this.bM01Save.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SmpDialogAction.this.cM01IconVisible.setIcon(new ImageIcon(this.getClass().getResource("/images/Auge.png")));
                    SmpDialogAction.this.cM01IconVisible.setSelected(true);
                    SmpDialogAction.this.buoy.saveSign();
                }
            });
        }
        return this.bM01Save;
    }

    private JCheckBox getCM01IconVisible() {
        if (this.cM01IconVisible == null) {
            this.cM01IconVisible = new JCheckBox();
            this.cM01IconVisible.setBounds(new Rectangle(310, 325, 30, 21));
            this.cM01IconVisible.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/images/AugeN.png")));
            this.cM01IconVisible.setSelected(false);
            this.cM01IconVisible.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Node n = null;
                    DataSet ds = Main.main.getCurrentDataSet();
                    if (SmpDialogAction.this.buoy != null) {
                        n = SmpDialogAction.this.buoy.getNode();
                    }
                    if (SmpDialogAction.this.cM01IconVisible.isSelected()) {
                        SmpDialogAction.this.cM01IconVisible.setIcon(new ImageIcon(this.getClass().getResource("/images/AugeN.png")));
                        if (n != null) {
                            ChangePropertyCommand c;
                            if (n.getKeys().containsKey("seamark")) {
                                SmpDialogAction.this.smb = (String)n.getKeys().get("seamark");
                                c = new ChangePropertyCommand((OsmPrimitive)n, "seamark", null);
                                c.executeCommand();
                                ds.fireSelectionChanged();
                                SmpDialogAction.this.obuoy = SmpDialogAction.this.buoy;
                            }
                            if (n.getKeys().containsKey("seamark:type")) {
                                SmpDialogAction.this.smt = (String)n.getKeys().get("seamark:type");
                                c = new ChangePropertyCommand((OsmPrimitive)n, "seamark:type", null);
                                c.executeCommand();
                                ds.fireSelectionChanged();
                                SmpDialogAction.this.obuoy = SmpDialogAction.this.buoy;
                            }
                        }
                    } else {
                        SmpDialogAction.this.cM01IconVisible.setIcon(new ImageIcon(this.getClass().getResource("/images/Auge.png")));
                        SmpDialogAction.this.PicRebuild();
                        SmpDialogAction.this.obuoy = null;
                    }
                    SmpDialogAction.this.buoy.paintSign();
                }
            });
        }
        return this.cM01IconVisible;
    }

    private JTextField getSM01StatusBar() {
        if (this.sM01StatusBar == null) {
            this.sM01StatusBar = new JTextField();
            this.sM01StatusBar.setBounds(new Rectangle(7, 355, 385, 20));
            this.sM01StatusBar.setBackground(SystemColor.activeCaptionBorder);
        }
        return this.sM01StatusBar;
    }
}

