/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.util.operator;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.pdmodel.graphics.color.PDCalRGB;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorState;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceCMYK;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceN;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.graphics.color.PDICCBased;
import org.apache.pdfbox.util.PDFOperator;
import org.apache.pdfbox.util.operator.OperatorProcessor;
import org.apache.pdfbox.util.operator.SetStrokingCMYKColor;
import org.apache.pdfbox.util.operator.SetStrokingCalRGBColor;
import org.apache.pdfbox.util.operator.SetStrokingGrayColor;
import org.apache.pdfbox.util.operator.SetStrokingICCBasedColor;
import org.apache.pdfbox.util.operator.SetStrokingRGBColor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetStrokingDeviceN
extends OperatorProcessor {
    private static final Log log = LogFactory.getLog(SetStrokingDeviceN.class);

    @Override
    public void process(PDFOperator operator, List<COSBase> arguments) throws IOException {
        PDColorState color = this.context.getGraphicsState().getStrokingColor();
        PDColorSpace colorSpace = color.getColorSpace();
        if (colorSpace != null) {
            OperatorProcessor newOperator = null;
            List<COSBase> argList = arguments;
            if (colorSpace instanceof PDDeviceN) {
                PDDeviceN sep = (PDDeviceN)colorSpace;
                colorSpace = sep.getAlternateColorSpace();
                argList = sep.calculateColorValues(arguments).toList();
            }
            if (colorSpace instanceof PDDeviceGray) {
                newOperator = new SetStrokingGrayColor();
            } else if (colorSpace instanceof PDDeviceRGB) {
                newOperator = new SetStrokingRGBColor();
            } else if (colorSpace instanceof PDDeviceCMYK) {
                newOperator = new SetStrokingCMYKColor();
            } else if (colorSpace instanceof PDICCBased) {
                newOperator = new SetStrokingICCBasedColor();
            } else if (colorSpace instanceof PDCalRGB) {
                newOperator = new SetStrokingCalRGBColor();
            }
            if (newOperator != null) {
                color.setColorSpace(colorSpace);
                newOperator.setContext(this.getContext());
                ((OperatorProcessor)newOperator).process(operator, argList);
            } else {
                log.warn("Not supported colorspace " + colorSpace.getName() + " within operator " + operator.getOperation());
            }
        }
    }
}

