/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.ProjectionException;
import org.osgeo.proj4j.proj.Projection;
import org.osgeo.proj4j.util.ProjectionMath;

public class CassiniProjection
extends Projection {
    private double m0;
    private double n;
    private double t;
    private double a1;
    private double c;
    private double r;
    private double dd;
    private double d2;
    private double a2;
    private double tn;
    private double[] en;
    private static final double EPS10 = 1.0E-10;
    private static final double C1 = 0.16666666666666666;
    private static final double C2 = 0.008333333333333333;
    private static final double C3 = 0.041666666666666664;
    private static final double C4 = 0.3333333333333333;
    private static final double C5 = 0.06666666666666667;

    public CassiniProjection() {
        this.projectionLatitude = Math.toRadians(0.0);
        this.projectionLongitude = Math.toRadians(0.0);
        this.minLongitude = Math.toRadians(-90.0);
        this.maxLongitude = Math.toRadians(90.0);
        this.initialize();
    }

    public ProjCoordinate project(double lplam, double lpphi, ProjCoordinate xy) {
        if (this.spherical) {
            xy.x = Math.asin(Math.cos(lpphi) * Math.sin(lplam));
            xy.y = Math.atan2(Math.tan(lpphi), Math.cos(lplam)) - this.projectionLatitude;
        } else {
            this.n = Math.sin(lpphi);
            this.c = Math.cos(lpphi);
            xy.y = ProjectionMath.mlfn(lpphi, this.n, this.c, this.en);
            this.n = 1.0 / Math.sqrt(1.0 - this.es * this.n * this.n);
            this.tn = Math.tan(lpphi);
            this.t = this.tn * this.tn;
            this.a1 = lplam * this.c;
            this.c *= this.es * this.c / (1.0 - this.es);
            this.a2 = this.a1 * this.a1;
            xy.x = this.n * this.a1 * (1.0 - this.a2 * this.t * (0.16666666666666666 - (8.0 - this.t + 8.0 * this.c) * this.a2 * 0.008333333333333333));
            xy.y -= this.m0 - this.n * this.tn * this.a2 * (0.5 + (5.0 - this.t + 6.0 * this.c) * this.a2 * 0.041666666666666664);
        }
        return xy;
    }

    public ProjCoordinate projectInverse(double xyx, double xyy, ProjCoordinate out) {
        if (this.spherical) {
            this.dd = xyy + this.projectionLatitude;
            out.y = Math.asin(Math.sin(this.dd) * Math.cos(xyx));
            out.x = Math.atan2(Math.tan(xyx), Math.cos(this.dd));
        } else {
            double ph1 = ProjectionMath.inv_mlfn(this.m0 + xyy, this.es, this.en);
            this.tn = Math.tan(ph1);
            this.t = this.tn * this.tn;
            this.n = Math.sin(ph1);
            this.r = 1.0 / (1.0 - this.es * this.n * this.n);
            this.n = Math.sqrt(this.r);
            this.r *= (1.0 - this.es) * this.n;
            this.dd = xyx / this.n;
            this.d2 = this.dd * this.dd;
            out.y = ph1 - this.n * this.tn / this.r * this.d2 * (0.5 - (1.0 + 3.0 * this.t) * this.d2 * 0.041666666666666664);
            out.x = this.dd * (1.0 + this.t * this.d2 * (-0.3333333333333333 + (1.0 + 3.0 * this.t) * this.d2 * 0.06666666666666667)) / Math.cos(ph1);
        }
        return out;
    }

    public void initialize() {
        super.initialize();
        if (!this.spherical) {
            this.en = ProjectionMath.enfn(this.es);
            if (this.en == null) {
                throw new ProjectionException();
            }
            this.m0 = ProjectionMath.mlfn(this.projectionLatitude, Math.sin(this.projectionLatitude), Math.cos(this.projectionLatitude), this.en);
        }
    }

    public boolean hasInverse() {
        return true;
    }

    public int getEPSGCode() {
        return 9806;
    }

    public String toString() {
        return "Cassini";
    }
}

