/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.embedded;

import java.awt.Canvas;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import javax.swing.SwingUtilities;
import uk.co.caprica.vlcj.binding.internal.libvlc_instance_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_player_t;
import uk.co.caprica.vlcj.log.Logger;
import uk.co.caprica.vlcj.player.MediaPlayer;
import uk.co.caprica.vlcj.player.embedded.FullScreenStrategy;

public abstract class EmbeddedMediaPlayer
extends MediaPlayer {
    private final FullScreenStrategy fullScreenStrategy;
    private final OverlayComponentAdapter overlayComponentAdapter;
    private final OverlayWindowAdapter overlayWindowAdapter;
    private Canvas videoSurface;
    private boolean videoSurfaceSet;
    private Window overlay;
    private boolean requestedOverlay;
    private boolean restoreOverlay;

    public EmbeddedMediaPlayer(libvlc_instance_t instance) {
        this(instance, null);
    }

    public EmbeddedMediaPlayer(libvlc_instance_t instance, FullScreenStrategy fullScreenStrategy) {
        super(instance);
        this.fullScreenStrategy = fullScreenStrategy;
        this.overlayComponentAdapter = new OverlayComponentAdapter();
        this.overlayWindowAdapter = new OverlayWindowAdapter();
    }

    public void setVideoSurface(Canvas videoSurface) {
        Logger.debug("setVideoSurface(videoSurface={})", videoSurface);
        this.videoSurface = videoSurface;
        this.videoSurfaceSet = false;
    }

    public void toggleFullScreen() {
        Logger.debug("toggleFullScreen()", new Object[0]);
        if (this.fullScreenStrategy != null) {
            this.setFullScreen(!this.fullScreenStrategy.isFullScreenMode());
        }
    }

    public void setFullScreen(boolean fullScreen) {
        Logger.debug("setFullScreen(fullScreen={})", fullScreen);
        if (this.fullScreenStrategy != null) {
            if (fullScreen) {
                this.fullScreenStrategy.enterFullScreenMode();
            } else {
                this.fullScreenStrategy.exitFullScreenMode();
            }
        }
    }

    public boolean isFullScreen() {
        Logger.debug("isFullScreen()", new Object[0]);
        if (this.fullScreenStrategy != null) {
            return this.fullScreenStrategy.isFullScreenMode();
        }
        return false;
    }

    public BufferedImage getVideoSurfaceContents() {
        Logger.debug("getVideoSurfaceContents()", new Object[0]);
        try {
            Rectangle bounds = this.videoSurface.getBounds();
            bounds.setLocation(this.videoSurface.getLocationOnScreen());
            return new Robot().createScreenCapture(bounds);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get video surface contents", e);
        }
    }

    public Window getOverlay() {
        Logger.debug("getOverlay()", new Object[0]);
        return this.overlay;
    }

    public void setOverlay(Window overlay) {
        Logger.debug("setOverlay(overlay={})", overlay);
        if (this.videoSurface == null) {
            throw new IllegalStateException("Can't set an overlay when there's no video surface");
        }
        this.enableOverlay(false);
        this.removeOverlay();
        this.addOverlay(overlay);
    }

    public void enableOverlay(boolean enable) {
        Logger.debug("enableOverlay(enable={})", enable);
        this.requestedOverlay = enable;
        if (this.overlay != null) {
            if (enable) {
                if (!this.overlay.isVisible()) {
                    this.overlay.setLocation(this.videoSurface.getLocationOnScreen());
                    this.overlay.setSize(this.videoSurface.getSize());
                    Window window = (Window)SwingUtilities.getAncestorOfClass(Window.class, this.videoSurface);
                    window.addComponentListener(this.overlayComponentAdapter);
                    this.overlay.setVisible(true);
                }
            } else if (this.overlay.isVisible()) {
                this.overlay.setVisible(false);
                Window window = (Window)SwingUtilities.getAncestorOfClass(Window.class, this.videoSurface);
                window.removeComponentListener(this.overlayComponentAdapter);
            }
        }
    }

    public boolean overlayEnabled() {
        Logger.debug("overlayEnabled()", new Object[0]);
        return this.overlay != null && this.overlay.isVisible();
    }

    private void addOverlay(Window overlay) {
        Logger.debug("addOverlay(overlay={})", overlay);
        if (overlay != null) {
            Window window = (Window)SwingUtilities.getAncestorOfClass(Window.class, this.videoSurface);
            window.addWindowListener(this.overlayWindowAdapter);
            this.overlay = overlay;
        }
    }

    private void removeOverlay() {
        Logger.debug("removeOverlay()", new Object[0]);
        if (this.overlay != null) {
            Window window = (Window)SwingUtilities.getAncestorOfClass(Window.class, this.videoSurface);
            window.removeWindowListener(this.overlayWindowAdapter);
            this.overlay = null;
        }
    }

    protected void onBeforePlay() {
        Logger.debug("onBeforePlay()", new Object[0]);
        Logger.debug("videoSurfaceSet={}", this.videoSurfaceSet);
        if (!this.videoSurfaceSet && this.videoSurface != null) {
            this.nativeSetVideoSurface(this.mediaPlayerInstance(), this.videoSurface);
            this.videoSurfaceSet = true;
        }
    }

    protected abstract void nativeSetVideoSurface(libvlc_media_player_t var1, Canvas var2);

    private void showOverlay() {
        Logger.trace("showOverlay()", new Object[0]);
        if (this.restoreOverlay) {
            this.enableOverlay(true);
        }
    }

    private void hideOverlay() {
        Logger.trace("hideOverlay()", new Object[0]);
        if (this.requestedOverlay) {
            this.restoreOverlay = true;
            this.enableOverlay(false);
        } else {
            this.restoreOverlay = false;
        }
    }

    private final class OverlayWindowAdapter
    extends WindowAdapter {
        private OverlayWindowAdapter() {
        }

        public void windowIconified(WindowEvent e) {
            Logger.trace("windowIconified(e={})", e);
            EmbeddedMediaPlayer.this.hideOverlay();
        }

        public void windowDeiconified(WindowEvent e) {
            Logger.trace("windowDeiconified(e={})", e);
            EmbeddedMediaPlayer.this.showOverlay();
        }
    }

    private final class OverlayComponentAdapter
    extends ComponentAdapter {
        private OverlayComponentAdapter() {
        }

        public void componentResized(ComponentEvent e) {
            Logger.trace("componentResized(e={})", e);
            EmbeddedMediaPlayer.this.overlay.setSize(EmbeddedMediaPlayer.this.videoSurface.getSize());
        }

        public void componentMoved(ComponentEvent e) {
            Logger.trace("componentMoved(e={})", e);
            EmbeddedMediaPlayer.this.overlay.setLocation(EmbeddedMediaPlayer.this.videoSurface.getLocationOnScreen());
        }

        public void componentShown(ComponentEvent e) {
            Logger.trace("componentShown(e={})", e);
            EmbeddedMediaPlayer.this.showOverlay();
        }

        public void componentHidden(ComponentEvent e) {
            Logger.trace("componentHidden(e={})", e);
            EmbeddedMediaPlayer.this.hideOverlay();
        }
    }
}

