/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.log;

import java.io.PrintWriter;
import java.util.Formatter;

public class Logger {
    private static final String PLACE_HOLDER = "{}";
    private static final Logger INSTANCE = new Logger();
    private final PrintWriter out = new PrintWriter(System.out);
    private final PrintWriter err = new PrintWriter(System.err);
    private Level threshold = Level.NONE;

    private Logger() {
        String logProperty = System.getProperty("vlcj.log");
        if (logProperty != null) {
            this.threshold = Level.valueOf(logProperty);
        }
    }

    public static void setLevel(Level threshold) {
        Logger.INSTANCE.threshold = threshold;
    }

    public static Level level() {
        return Logger.INSTANCE.threshold;
    }

    public static void trace(String msg, Object ... args) {
        if (Level.TRACE.compareTo(Logger.INSTANCE.threshold) <= 0) {
            Logger.out("TRACE", msg, null, args);
        }
    }

    public static void trace(String msg, Throwable t, Object ... args) {
        if (Level.TRACE.compareTo(Logger.INSTANCE.threshold) <= 0) {
            Logger.out("TRACE", msg, t, args);
        }
    }

    public static void debug(String msg, Object ... args) {
        if (Level.DEBUG.compareTo(Logger.INSTANCE.threshold) <= 0) {
            Logger.out("DEBUG", msg, null, args);
        }
    }

    public static void debug(String msg, Throwable t, Object ... args) {
        if (Level.DEBUG.compareTo(Logger.INSTANCE.threshold) <= 0) {
            Logger.out("DEBUG", msg, t, args);
        }
    }

    public static void info(String msg, Object ... args) {
        if (Level.INFO.compareTo(Logger.INSTANCE.threshold) <= 0) {
            Logger.out("INFO", msg, null, args);
        }
    }

    public static void info(String msg, Throwable t, Object ... args) {
        if (Level.INFO.compareTo(Logger.INSTANCE.threshold) <= 0) {
            Logger.out("INFO", msg, t, args);
        }
    }

    public static void warn(String msg, Object ... args) {
        if (Level.WARN.compareTo(Logger.INSTANCE.threshold) <= 0) {
            Logger.out("WARN", msg, null, args);
        }
    }

    public static void warn(String msg, Throwable t, Object ... args) {
        if (Level.WARN.compareTo(Logger.INSTANCE.threshold) <= 0) {
            Logger.out("WARN", msg, t, args);
        }
    }

    public static void error(String msg, Object ... args) {
        if (Level.ERROR.compareTo(Logger.INSTANCE.threshold) <= 0) {
            Logger.out("ERROR", msg, null, args);
        }
    }

    public static void error(String msg, Throwable t, Object ... args) {
        if (Level.ERROR.compareTo(Logger.INSTANCE.threshold) <= 0) {
            Logger.out("ERROR", msg, t, args);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void out(String level, String msg, Throwable t, Object ... args) {
        PrintWriter out;
        PrintWriter printWriter = out = Logger.INSTANCE.out;
        synchronized (printWriter) {
            StackTraceElement el = Logger.getLine();
            String location = new Formatter().format("(%s:%d)", el.getFileName(), el.getLineNumber()).toString();
            out.printf("vlcj: %-40s | %-5s | %s\n", location, level, Logger.format(msg, args));
            out.flush();
            if (t != null) {
                PrintWriter err = Logger.INSTANCE.err;
                err.printf("vlcj: %-40s | %-5s | %s\n", location, level, t.getMessage());
                err.flush();
                t.printStackTrace();
            }
        }
    }

    private static StackTraceElement getLine() {
        Throwable t = new Throwable();
        t.fillInStackTrace();
        StackTraceElement[] els = t.getStackTrace();
        return els[3];
    }

    public static String format(String msg, Object ... args) {
        if (args == null || args.length == 0 || msg == null) {
            return msg;
        }
        StringBuilder sb = new StringBuilder(msg.length() + args.length * 10);
        int current = 0;
        int argIndex = 0;
        while (current < msg.length()) {
            int token = msg.indexOf(PLACE_HOLDER, current);
            if (token > -1) {
                sb.append(msg.substring(current, token));
                sb.append(args[argIndex++]);
                current = token + PLACE_HOLDER.length();
                continue;
            }
            sb.append(msg.substring(current));
            break;
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Level {
        NONE,
        ERROR,
        WARN,
        INFO,
        DEBUG,
        TRACE;

    }
}

