/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.log;

import java.util.ArrayList;
import java.util.List;
import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.binding.internal.libvlc_instance_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_log_iterator_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_log_message_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_log_t;
import uk.co.caprica.vlcj.log.LogLevel;
import uk.co.caprica.vlcj.log.LogMessage;
import uk.co.caprica.vlcj.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Log {
    private final LibVlc libvlc;
    private final libvlc_instance_t instance;
    private LogLevel threshold;
    private libvlc_log_t logInstance;

    public Log(LibVlc libvlc, libvlc_instance_t instance) {
        Logger.debug("Log(libvlc={},instance={})", libvlc, instance);
        this.libvlc = libvlc;
        this.instance = instance;
    }

    public void setThreshold(LogLevel threshold) {
        Logger.debug("setThreshold(threshold={})", new Object[]{threshold});
        this.threshold = threshold;
    }

    public void open() {
        Logger.debug("open()", new Object[0]);
        if (this.logInstance != null) {
            throw new IllegalStateException("Log is already open");
        }
        this.logInstance = this.libvlc.libvlc_log_open(this.instance);
    }

    public void close() {
        Logger.debug("close()", new Object[0]);
        if (this.logInstance != null) {
            this.clear();
            this.libvlc.libvlc_log_close(this.logInstance);
            this.logInstance = null;
        }
    }

    public int count() {
        Logger.trace("count()", new Object[0]);
        return this.libvlc.libvlc_log_count(this.logInstance);
    }

    public void clear() {
        Logger.trace("clear()", new Object[0]);
        this.libvlc.libvlc_log_clear(this.logInstance);
    }

    public List<LogMessage> messages() {
        Logger.trace("messages()", new Object[0]);
        return this.messages(new ArrayList<LogMessage>(40));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LogMessage> messages(List<LogMessage> messages) {
        Logger.trace("messages(messages=[{}])", messages.size());
        libvlc_log_iterator_t it = null;
        try {
            it = this.libvlc.libvlc_log_get_iterator(this.logInstance);
            while (this.libvlc.libvlc_log_iterator_has_next(it) != 0) {
                libvlc_log_message_t message = new libvlc_log_message_t();
                if ((message = this.libvlc.libvlc_log_iterator_next(it, message)) == null) continue;
                LogLevel severity = LogLevel.value(message.i_severity);
                if (this.threshold != null && message.i_severity > this.threshold.intValue()) continue;
                messages.add(new LogMessage(severity, message.psz_type, message.psz_name, message.psz_header, message.psz_message));
            }
        }
        finally {
            if (it != null) {
                this.libvlc.libvlc_log_iterator_free(it);
            }
        }
        this.clear();
        return messages;
    }
}

