/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tageditor.editor;

import java.awt.Component;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.openstreetmap.josm.plugins.tageditor.preset.Item;
import org.openstreetmap.josm.tools.I18n;

public class PresetItemListCellRenderer
extends JLabel
implements ListCellRenderer {
    private static final Logger logger = Logger.getLogger(PresetItemListCellRenderer.class.getName());

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Item item = (Item)value;
        if (item == null) {
            this.setText(I18n.tr((String)"(none)", (Object[])new Object[0]));
            this.setIcon(null);
        } else {
            if (isSelected) {
                this.setBackground(UIManager.getColor("Table.selectionBackground"));
                this.setForeground(UIManager.getColor("Table.selectionForeground"));
            } else {
                this.setBackground(UIManager.getColor("Table.background"));
                this.setForeground(UIManager.getColor("Table.foreground"));
            }
            this.setIcon(item.getIcon());
            StringBuilder sb = new StringBuilder();
            sb.append(item.getParent().getName()).append("/").append(item.getName());
            this.setText(sb.toString());
            this.setOpaque(true);
            this.setFont(UIManager.getFont("Table.font"));
        }
        return this;
    }
}

