/*
 * Decompiled with CFR 0.152.
 */
package livegps;

import java.awt.Color;
import java.awt.GridLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import livegps.LiveGpsData;
import livegps.LiveGpsStatus;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class LiveGpsDialog
extends ToggleDialog
implements PropertyChangeListener {
    private static final long serialVersionUID = 6183400754671501117L;
    private JLabel statusLabel;
    private JLabel wayLabel;
    private JLabel latLabel;
    private JLabel longLabel;
    private JLabel courseLabel;
    private JLabel speedLabel;
    private JPanel panel = new JPanel();

    public LiveGpsDialog(MapFrame mapFrame) {
        super(I18n.tr((String)"Live GPS", (Object[])new Object[0]), "livegps", I18n.tr((String)"Show GPS data.", (Object[])new Object[0]), Shortcut.registerShortcut((String)"subwindow:livegps", (String)I18n.tr((String)"Toggle: {0}", (Object[])new Object[]{I18n.tr((String)"Live GPS", (Object[])new Object[0])}), (int)71, (int)4, (int)1), 100);
        this.panel.setLayout(new GridLayout(6, 2));
        this.panel.add(new JLabel(I18n.tr((String)"Status", (Object[])new Object[0])));
        this.statusLabel = new JLabel();
        this.panel.add(this.statusLabel);
        this.panel.add(new JLabel(I18n.tr((String)"Way Info", (Object[])new Object[0])));
        this.wayLabel = new JLabel();
        this.panel.add(this.wayLabel);
        this.panel.add(new JLabel(I18n.tr((String)"Latitude", (Object[])new Object[0])));
        this.latLabel = new JLabel();
        this.panel.add(this.latLabel);
        this.panel.add(new JLabel(I18n.tr((String)"Longitude", (Object[])new Object[0])));
        this.longLabel = new JLabel();
        this.panel.add(this.longLabel);
        this.panel.add(new JLabel(I18n.tr((String)"Speed", (Object[])new Object[0])));
        this.speedLabel = new JLabel();
        this.panel.add(this.speedLabel);
        this.panel.add(new JLabel(I18n.tr((String)"Course", (Object[])new Object[0])));
        this.courseLabel = new JLabel();
        this.panel.add(this.courseLabel);
        this.add(new JScrollPane(this.panel), "Center");
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (!this.isVisible()) {
            return;
        }
        if ("gpsdata".equals(evt.getPropertyName())) {
            LiveGpsData data = (LiveGpsData)evt.getNewValue();
            if (data.isFix()) {
                this.panel.setBackground(Color.WHITE);
                this.latLabel.setText(data.getLatitude() + "deg");
                this.longLabel.setText(data.getLongitude() + "deg");
                double mySpeed = data.getSpeed() * 3.6f;
                this.speedLabel.setText(Math.round(mySpeed * 100.0) / 100L + "km/h");
                this.courseLabel.setText(data.getCourse() + "deg");
                String wayString = data.getWayInfo();
                if (wayString.length() > 0) {
                    this.wayLabel.setText(wayString);
                } else {
                    this.wayLabel.setText(I18n.tr((String)"unknown", (Object[])new Object[0]));
                }
            } else {
                this.latLabel.setText("");
                this.longLabel.setText("");
                this.speedLabel.setText("");
                this.courseLabel.setText("");
                this.panel.setBackground(Color.RED);
            }
        } else if ("gpsstatus".equals(evt.getPropertyName())) {
            LiveGpsStatus status = (LiveGpsStatus)evt.getNewValue();
            this.statusLabel.setText(status.getStatusMessage());
            if (status.getStatus() != LiveGpsStatus.GpsStatus.CONNECTED) {
                this.panel.setBackground(Color.RED);
            } else {
                this.panel.setBackground(Color.WHITE);
            }
        }
    }
}

