/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.measurement;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.Collection;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.plugins.measurement.MeasurementLayer;
import org.openstreetmap.josm.plugins.measurement.MeasurementPlugin;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class MeasurementDialog
extends ToggleDialog
implements ActionListener {
    private static final long serialVersionUID = 4708541586297950021L;
    private SideButton resetButton;
    protected JLabel pathLengthLabel;
    protected JLabel selectLengthLabel;
    protected JLabel selectAreaLabel;
    protected JLabel segAngleLabel;

    public MeasurementDialog() {
        super(I18n.tr((String)"Measured values", (Object[])new Object[0]), "measure", I18n.tr((String)"Open the measurement window.", (Object[])new Object[0]), Shortcut.registerShortcut((String)"subwindow:measurement", (String)I18n.tr((String)"Toggle: {0}", (Object[])new Object[]{I18n.tr((String)"Measured values", (Object[])new Object[0])}), (int)77, (int)4), 150);
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2));
        this.resetButton = new SideButton(I18n.marktr((String)"Reset"), "select", "Measurement", I18n.tr((String)"Reset current measurement results and delete measurement path.", (Object[])new Object[0]), (ActionListener)this);
        buttonPanel.add((Component)this.resetButton);
        this.add(buttonPanel, "South");
        JPanel valuePanel = new JPanel(new GridLayout(0, 2));
        valuePanel.add(new JLabel(I18n.tr((String)"Path Length", (Object[])new Object[0])));
        this.pathLengthLabel = new JLabel("0 m");
        valuePanel.add(this.pathLengthLabel);
        valuePanel.add(new JLabel(I18n.tr((String)"Selection Length", (Object[])new Object[0])));
        this.selectLengthLabel = new JLabel("0 m");
        valuePanel.add(this.selectLengthLabel);
        valuePanel.add(new JLabel(I18n.tr((String)"Selection Area", (Object[])new Object[0])));
        this.selectAreaLabel = new JLabel("0 m\u00b2");
        valuePanel.add(this.selectAreaLabel);
        JLabel angle = new JLabel(I18n.tr((String)"Angle", (Object[])new Object[0]));
        angle.setToolTipText(I18n.tr((String)"Angle between two selected Nodes", (Object[])new Object[0]));
        valuePanel.add(angle);
        this.segAngleLabel = new JLabel("- \u00b0");
        valuePanel.add(this.segAngleLabel);
        this.add(valuePanel, "Center");
        this.setPreferredSize(new Dimension(0, 92));
        final MeasurementDialog dlg = this;
        DataSet.addSelectionListener((SelectionChangedListener)new SelectionChangedListener(){

            public void selectionChanged(Collection<? extends OsmPrimitive> arg0) {
                double length = 0.0;
                double segAngle = 0.0;
                double area = 0.0;
                Node lastNode = null;
                for (OsmPrimitive osmPrimitive : arg0) {
                    if (osmPrimitive instanceof Node && !((Node)osmPrimitive).isIncomplete()) {
                        Node n = (Node)osmPrimitive;
                        if (lastNode == null) {
                            lastNode = n;
                            continue;
                        }
                        length += lastNode.getCoor().greatCircleDistance(n.getCoor());
                        segAngle = MeasurementLayer.angleBetween(lastNode.getCoor(), n.getCoor());
                        lastNode = n;
                        continue;
                    }
                    if (!(osmPrimitive instanceof Way)) continue;
                    Way w = (Way)osmPrimitive;
                    Node lastN = null;
                    for (Node n : w.getNodes()) {
                        if (lastN != null) {
                            length += lastN.getCoor().greatCircleDistance(n.getCoor());
                            area += MeasurementLayer.calcX(n.getCoor()) * MeasurementLayer.calcY(lastN.getCoor()) - MeasurementLayer.calcY(n.getCoor()) * MeasurementLayer.calcX(lastN.getCoor());
                            segAngle = MeasurementLayer.angleBetween(lastN.getCoor(), n.getCoor());
                        }
                        lastN = n;
                    }
                    if (lastN != null && lastN == w.getNodes().iterator().next()) {
                        area = Math.abs(area / 2.0);
                        continue;
                    }
                    area = 0.0;
                }
                dlg.selectLengthLabel.setText(new DecimalFormat("#0.00").format(length) + " m");
                dlg.segAngleLabel.setText(new DecimalFormat("#0.0").format(segAngle) + " \u00b0");
                dlg.selectAreaLabel.setText(new DecimalFormat("#0.00").format(area) + " m\u00b2");
            }
        });
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand.equals("Reset")) {
            this.resetValues();
        }
    }

    public void resetValues() {
        MeasurementPlugin.getCurrentLayer().reset();
    }
}

