/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapdust.gui.component.dialog;

import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JToggleButton;
import org.openstreetmap.josm.plugins.mapdust.MapdustPlugin;
import org.openstreetmap.josm.plugins.mapdust.gui.action.adapter.WindowClose;
import org.openstreetmap.josm.plugins.mapdust.gui.action.execute.ExecuteCancel;
import org.openstreetmap.josm.plugins.mapdust.gui.action.execute.ExecuteFilterBug;
import org.openstreetmap.josm.plugins.mapdust.gui.component.dialog.AbstractDialog;
import org.openstreetmap.josm.plugins.mapdust.gui.component.panel.MapdustButtonPanel;
import org.openstreetmap.josm.plugins.mapdust.gui.component.slider.RelevanceSlider;
import org.openstreetmap.josm.plugins.mapdust.gui.component.util.ComponentUtil;
import org.openstreetmap.josm.plugins.mapdust.gui.component.util.FilterCheckBox;
import org.openstreetmap.josm.plugins.mapdust.gui.value.MapdustRelevanceValue;
import org.openstreetmap.josm.plugins.mapdust.service.value.MapdustBugFilter;
import org.openstreetmap.josm.plugins.mapdust.service.value.MapdustRelevance;
import org.openstreetmap.josm.plugins.mapdust.service.value.Status;
import org.openstreetmap.josm.plugins.mapdust.service.value.Type;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterBugDialog
extends AbstractDialog {
    private static final long serialVersionUID = -3333642616656969760L;
    private JLabel lblStatus;
    private FilterCheckBox[] filterStatuses;
    private JLabel lblType;
    private FilterCheckBox[] filterTypes;
    private JLabel lblDescription;
    private FilterCheckBox filterDescr;
    private JLabel lblRelevance;
    private RelevanceSlider sliderRelevance;
    private JButton btnApply;
    private JButton btnCancel;

    public FilterBugDialog() {
    }

    public FilterBugDialog(String title, String iconName, JToggleButton firedButton, MapdustPlugin mapdustPlugin) {
        if (firedButton != null) {
            this.setFiredButton(firedButton);
        }
        this.setTitle(title);
        this.setModal(true);
        Image image = ImageProvider.get((String)iconName).getImage();
        this.setIconImage(image);
        this.setDefaultCloseOperation(2);
        this.getContentPane().setFont(new Font("Times New Roman", 1, 14));
        this.setBackground(Color.white);
        this.setResizable(false);
        this.setForeground(Color.black);
        this.setLayout(null);
        this.addComponents(mapdustPlugin);
        MapdustButtonPanel btnPanel = mapdustPlugin.getMapdustGUI().getPanel().getBtnPanel();
        this.addWindowListener(new WindowClose(this, btnPanel));
    }

    @Override
    public void addComponents(MapdustPlugin mapdustPlugin) {
        Rectangle bounds;
        Font font = new Font("Times New Roman", 1, 14);
        MapdustBugFilter prevFilter = mapdustPlugin.getFilter();
        if (this.lblStatus == null) {
            bounds = new Rectangle(10, 10, 95, 25);
            this.lblStatus = ComponentUtil.createJLabel("Status", font, bounds, null);
        }
        if (this.filterStatuses == null) {
            this.createStatusFilters(prevFilter);
        }
        if (this.filterTypes == null) {
            this.createTypeFilters(prevFilter);
        }
        if (this.lblType == null) {
            bounds = new Rectangle(10, 90, 95, 25);
            this.lblType = ComponentUtil.createJLabel("Type", font, bounds, null);
        }
        if (this.lblDescription == null) {
            bounds = new Rectangle(10, 230, 95, 25);
            this.lblDescription = ComponentUtil.createJLabel("Description", font, bounds, null);
        }
        if (this.filterDescr == null) {
            Rectangle chbBounds = new Rectangle(110, 230, 20, 25);
            Rectangle lblBounds = new Rectangle(130, 230, 300, 25);
            String text = "Hide bugs with default description";
            String iconName = "dialogs/default_description.png";
            this.filterDescr = new FilterCheckBox("descr", chbBounds, iconName, text, lblBounds);
            if (prevFilter != null && prevFilter.getDescr() != null && prevFilter.getDescr().booleanValue()) {
                this.filterDescr.getChbFilter().setSelected(true);
            }
        }
        if (this.lblRelevance == null) {
            bounds = new Rectangle(10, 265, 95, 25);
            this.lblRelevance = ComponentUtil.createJLabel("Relevance", font, bounds, null);
        }
        if (this.sliderRelevance == null) {
            bounds = new Rectangle(110, 265, 300, 50);
            this.sliderRelevance = new RelevanceSlider();
            this.sliderRelevance.setBounds(bounds);
            if (prevFilter != null) {
                Integer value;
                MapdustRelevance min = prevFilter.getMinRelevance();
                MapdustRelevance max = prevFilter.getMaxRelevance();
                if (min != null) {
                    value = MapdustRelevanceValue.getSliderValue(min);
                    if (value == null) {
                        value = MapdustRelevanceValue.LOW.getSliderValue();
                    }
                    this.sliderRelevance.setLowerValue(value);
                }
                if (max != null) {
                    value = MapdustRelevanceValue.getSliderValue(max);
                    if (value == null) {
                        value = MapdustRelevanceValue.HIGH.getSliderValue();
                    }
                    this.sliderRelevance.setUpperValue(value);
                }
                if (max != null && max.equals(min) && max.equals(MapdustRelevance.LOW)) {
                    this.sliderRelevance.getUI().setIsUpperSelected(true);
                }
            }
        }
        if (this.btnCancel == null) {
            bounds = new Rectangle(360, 330, 90, 25);
            ExecuteCancel cancelAction = new ExecuteCancel(this, mapdustPlugin.getMapdustGUI());
            this.btnCancel = ComponentUtil.createJButton("Cancel", bounds, cancelAction);
        }
        if (this.btnApply == null) {
            bounds = new Rectangle(260, 330, 90, 25);
            ExecuteFilterBug applyAction = new ExecuteFilterBug(this, mapdustPlugin.getMapdustGUI());
            applyAction.addObserver(mapdustPlugin);
            this.btnApply = ComponentUtil.createJButton("Apply", bounds, applyAction);
        }
        this.add(this.lblStatus);
        this.add(this.filterStatuses);
        this.add(this.lblType);
        this.add(this.filterTypes);
        this.add(this.lblDescription);
        this.add(this.filterDescr);
        this.add(this.lblRelevance);
        this.add(this.sliderRelevance);
        this.add(this.btnCancel);
        this.add(this.btnApply);
        this.setSize(460, 360);
    }

    private void createStatusFilters(MapdustBugFilter prevFilter) {
        this.filterStatuses = new FilterCheckBox[3];
        this.filterStatuses[0] = new FilterCheckBox(Status.OPEN.getKey(), new Rectangle(110, 10, 20, 25), "dialogs/open_bug.png", Status.OPEN.getValue(), new Rectangle(130, 10, 150, 25));
        this.filterStatuses[1] = new FilterCheckBox(Status.INVALID.getKey(), new Rectangle(270, 10, 20, 25), "dialogs/invalid_bug.png", Status.INVALID.getValue(), new Rectangle(290, 10, 180, 25));
        this.filterStatuses[2] = new FilterCheckBox(Status.FIXED.getKey(), new Rectangle(110, 45, 20, 25), "dialogs/fixed_bug.png", Status.FIXED.getValue(), new Rectangle(130, 45, 150, 25));
        if (prevFilter != null && prevFilter.getStatuses() != null) {
            for (FilterCheckBox filter : this.filterStatuses) {
                if (!prevFilter.getStatuses().contains(filter.getId())) continue;
                filter.getChbFilter().setSelected(true);
            }
        }
    }

    private void createTypeFilters(MapdustBugFilter prevFilter) {
        this.filterTypes = new FilterCheckBox[8];
        this.filterTypes[0] = new FilterCheckBox(Type.WRONG_TURN.getKey(), new Rectangle(110, 90, 20, 25), "dialogs/wrong_turn.png", Type.WRONG_TURN.getValue(), new Rectangle(130, 90, 120, 25));
        this.filterTypes[1] = new FilterCheckBox(Type.WRONG_ROUNDABOUT.getKey(), new Rectangle(270, 90, 20, 25), "dialogs/wrong_roundabout.png", Type.WRONG_ROUNDABOUT.getValue(), new Rectangle(290, 90, 180, 25));
        this.filterTypes[2] = new FilterCheckBox(Type.MISSING_STREET.getKey(), new Rectangle(110, 125, 20, 25), "dialogs/missing_street.png", Type.MISSING_STREET.getValue(), new Rectangle(130, 125, 150, 25));
        this.filterTypes[3] = new FilterCheckBox(Type.BLOCKED_STREET.getKey(), new Rectangle(270, 125, 20, 25), "dialogs/blocked_street.png", Type.BLOCKED_STREET.getValue(), new Rectangle(290, 125, 180, 25));
        this.filterTypes[4] = new FilterCheckBox(Type.BAD_ROUTING.getKey(), new Rectangle(110, 160, 20, 25), "dialogs/bad_routing.png", Type.BAD_ROUTING.getValue(), new Rectangle(130, 160, 150, 25));
        this.filterTypes[5] = new FilterCheckBox(Type.MISSING_SPEEDLIMIT.getKey(), new Rectangle(270, 160, 20, 25), "dialogs/missing_speedlimit.png", Type.MISSING_SPEEDLIMIT.getValue(), new Rectangle(290, 160, 180, 25));
        this.filterTypes[6] = new FilterCheckBox(Type.OTHER.getKey(), new Rectangle(110, 195, 20, 25), "dialogs/other.png", Type.OTHER.getValue(), new Rectangle(130, 195, 150, 25));
        this.filterTypes[7] = new FilterCheckBox(Type.ONEWAY_ROAD.getKey(), new Rectangle(270, 195, 20, 25), "dialogs/oneway_road.png", Type.ONEWAY_ROAD.getValue(), new Rectangle(290, 195, 180, 25));
        if (prevFilter != null && prevFilter.getTypes() != null) {
            for (FilterCheckBox filter : this.filterTypes) {
                if (!prevFilter.getTypes().contains(filter.getId())) continue;
                filter.getChbFilter().setSelected(true);
            }
        }
    }

    public List<Integer> getCheckedStatuses() {
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        for (FilterCheckBox filter : this.filterStatuses) {
            if (!filter.getChbFilter().isSelected()) continue;
            statusList.add((Integer)filter.getId());
        }
        return statusList;
    }

    public List<String> getCheckedTypes() {
        ArrayList<String> typeList = new ArrayList<String>();
        for (FilterCheckBox filter : this.filterTypes) {
            if (!filter.getChbFilter().isSelected()) continue;
            typeList.add((String)filter.getId());
        }
        return typeList;
    }

    public boolean isDescrFilterChecked() {
        return this.filterDescr.getChbFilter().isSelected();
    }

    public MapdustRelevance getSelectedMinRelevance() {
        int value = this.sliderRelevance.getLowerValue();
        MapdustRelevance minRelevance = MapdustRelevance.getMapdustRelevance(value);
        return minRelevance;
    }

    public MapdustRelevance getSelectedMaxRelevance() {
        int value = this.sliderRelevance.getUpperValue();
        MapdustRelevance maxRelevance = MapdustRelevance.getMapdustRelevance(value);
        return maxRelevance;
    }

    private void add(FilterCheckBox filter) {
        this.add(filter.getChbFilter());
        this.add(filter.getLblFilter());
    }

    private void add(FilterCheckBox[] filters) {
        for (FilterCheckBox filter : filters) {
            this.add(filter.getChbFilter());
            this.add(filter.getLblFilter());
        }
    }
}

