/*
 * Decompiled with CFR 0.152.
 */
package org.insignificant.josm.plugins.imagewaypoint;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.insignificant.josm.plugins.imagewaypoint.IImageChangeListener;
import org.insignificant.josm.plugins.imagewaypoint.ImageEntries;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public final class ImageWayPointDialog {
    private static final ImageWayPointDialog INSTANCE = new ImageWayPointDialog();
    private final ToggleDialog dialog = new ToggleDialog(I18n.tr((String)"WayPoint Image", (Object[])new Object[0]), "imagewaypoint", I18n.tr((String)"Display non-geotagged photos", (Object[])new Object[0]), Shortcut.registerShortcut((String)"subwindow:imagewaypoint", (String)I18n.tr((String)"Toggle: {0}", (Object[])new Object[]{I18n.tr((String)"WayPoint Image", (Object[])new Object[0])}), (int)89, (int)4), 200);
    private final ImageComponent imageDisplay;
    private final Action previousAction = new PreviousAction(this);
    private final Action nextAction = new NextAction(this);
    private final Action rotateLeftAction = new RotateLeftAction(this);
    private final Action rotateRightAction = new RotateRightAction(this);
    private final IImageChangeListener listener;

    private ImageWayPointDialog() {
        JButton previousButton = new JButton(this.previousAction);
        JButton nextButton = new JButton(this.nextAction);
        JButton rotateLeftButton = new JButton(this.rotateLeftAction);
        JButton rotateRightButton = new JButton(this.rotateRightAction);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(previousButton);
        buttonPanel.add(nextButton);
        buttonPanel.add(rotateLeftButton);
        buttonPanel.add(rotateRightButton);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        this.imageDisplay = new ImageComponent();
        mainPanel.add((Component)buttonPanel, "South");
        mainPanel.add((Component)this.imageDisplay, "Center");
        this.listener = new ImageChangeListener(this);
        ImageEntries.getInstance().addListener(this.listener);
        this.updateUI();
        this.dialog.add((Component)mainPanel);
    }

    private final void updateUI() {
        this.previousAction.setEnabled(ImageEntries.getInstance().hasPrevious());
        this.nextAction.setEnabled(ImageEntries.getInstance().hasNext());
        this.rotateLeftAction.setEnabled(null != ImageEntries.getInstance().getCurrentImageEntry());
        this.rotateRightAction.setEnabled(null != ImageEntries.getInstance().getCurrentImageEntry());
        if (null != Main.map) {
            Main.map.repaint();
        }
    }

    public static ImageWayPointDialog getInstance() {
        return INSTANCE;
    }

    public final ToggleDialog getDisplayComponent() {
        return this.dialog;
    }

    private static final class RotateRightAction
    extends JosmAction {
        private static final long serialVersionUID = 1760186810341888993L;
        private final ImageWayPointDialog dialog;

        public RotateRightAction(ImageWayPointDialog dialog) {
            super(I18n.tr((String)"Rotate right", (Object[])new Object[0]), null, I18n.tr((String)"Rotate image right", (Object[])new Object[0]), null, false);
            this.dialog = dialog;
        }

        public final void actionPerformed(ActionEvent actionEvent) {
            ImageEntries.getInstance().rotateCurrentImageRight();
        }
    }

    private static final class RotateLeftAction
    extends JosmAction {
        private static final long serialVersionUID = 3536922796446259943L;
        private final ImageWayPointDialog dialog;

        public RotateLeftAction(ImageWayPointDialog dialog) {
            super(I18n.tr((String)"Rotate left", (Object[])new Object[0]), null, I18n.tr((String)"Rotate image left", (Object[])new Object[0]), null, false);
            this.dialog = dialog;
        }

        public final void actionPerformed(ActionEvent actionEvent) {
            ImageEntries.getInstance().rotateCurrentImageLeft();
        }
    }

    private static final class NextAction
    extends JosmAction {
        private static final long serialVersionUID = 176134010956760988L;
        private final ImageWayPointDialog dialog;

        public NextAction(ImageWayPointDialog dialog) {
            super(I18n.tr((String)"Next", (Object[])new Object[0]), null, I18n.tr((String)"Next image", (Object[])new Object[0]), null, false);
            this.dialog = dialog;
        }

        public final void actionPerformed(ActionEvent actionEvent) {
            if (ImageEntries.getInstance().hasNext()) {
                ImageEntries.getInstance().next();
            }
        }
    }

    private static final class PreviousAction
    extends JosmAction {
        private static final long serialVersionUID = -7899209365124237890L;
        private final ImageWayPointDialog dialog;

        public PreviousAction(ImageWayPointDialog dialog) {
            super(I18n.tr((String)"Previous", (Object[])new Object[0]), null, I18n.tr((String)"Previous image", (Object[])new Object[0]), null, false);
            this.dialog = dialog;
        }

        public final void actionPerformed(ActionEvent actionEvent) {
            if (ImageEntries.getInstance().hasPrevious()) {
                ImageEntries.getInstance().previous();
            }
        }
    }

    private static final class ImageChangeListener
    implements IImageChangeListener {
        private final ImageWayPointDialog dialog;

        public ImageChangeListener(ImageWayPointDialog dialog) {
            this.dialog = dialog;
        }

        public final void onAvailableImageEntriesChanged(ImageEntries entries) {
            this.dialog.imageDisplay.setImage(entries.getCurrentImage());
            this.dialog.updateUI();
        }

        public final void onSelectedImageEntryChanged(ImageEntries entries) {
            this.dialog.imageDisplay.setImage(entries.getCurrentImage());
            this.dialog.updateUI();
        }
    }

    private static final class ImageComponent
    extends JComponent {
        private static final long serialVersionUID = -5207198660736375133L;
        private Image image = null;

        public final void paint(Graphics g) {
            if (null == this.image || 0 >= this.image.getWidth(null) || 0 >= this.image.getHeight(null)) {
                g.setColor(Color.white);
                g.fillRect(0, 0, this.getSize().width, this.getSize().height);
            } else {
                int resizedHeight;
                int resizedWidth;
                int imageHeight;
                int maxWidth = this.getSize().width;
                int maxHeight = this.getSize().height;
                int imageWidth = this.image.getWidth(null);
                double aspect = 1.0 * (double)imageWidth / (double)(imageHeight = this.image.getHeight(null));
                int widthIfHeightIsMax = (int)(aspect * (double)maxHeight);
                if (widthIfHeightIsMax > maxWidth) {
                    resizedWidth = maxWidth;
                    resizedHeight = (int)((double)resizedWidth / aspect);
                } else {
                    resizedWidth = widthIfHeightIsMax;
                    resizedHeight = maxHeight;
                }
                g.drawImage(this.image, (maxWidth - resizedWidth) / 2, (maxHeight - resizedHeight) / 2, resizedWidth, resizedHeight, Color.black, null);
            }
        }

        public final void setImage(Image image) {
            this.image = image;
            this.repaint();
        }
    }
}

