/*
 * Decompiled with CFR 0.152.
 */
package converttomultipoly;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipolyAction
extends JosmAction {
    public MultipolyAction() {
        super(I18n.tr((String)"Convert to multipolygon", (Object[])new Object[0]), "multipoly_convert", I18n.tr((String)"Convert to multipolygon.", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:multipolyconv", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Convert to multipolygon", (Object[])new Object[0])}), (int)77, (int)3, (int)1), true);
    }

    public void actionPerformed(ActionEvent e) {
        Way way;
        HashSet<OsmPrimitive> relationsInMulti = new HashSet<OsmPrimitive>();
        for (Relation r : Main.main.getCurrentDataSet().getRelations()) {
            if (!r.isUsable() || r.get("type") != "multipolygon") continue;
            for (RelationMember rm : r.getMembers()) {
                OsmPrimitive m = rm.getMember();
                if (!(m instanceof Way) || rm.getRole().compareTo("inner") == 0) continue;
                relationsInMulti.add(m);
            }
        }
        ArrayList<Way> selectedWays = new ArrayList<Way>();
        for (OsmPrimitive osm : Main.main.getCurrentDataSet().getSelected()) {
            if (!(osm instanceof Way)) continue;
            way = (Way)osm;
            if (relationsInMulti.contains(osm)) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"One of the selected ways is already part of another multipolygon.", (Object[])new Object[0]));
                return;
            }
            selectedWays.add(way);
        }
        if (Main.map == null) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"No data loaded.", (Object[])new Object[0]));
            return;
        }
        LinkedList<Object> cmds = new LinkedList<Object>();
        for (int i = 0; i < selectedWays.size(); ++i) {
            way = (Way)selectedWays.get(i);
            Relation rel = new Relation();
            rel.put("type", "multipolygon");
            RelationMember rm = new RelationMember("outer", (OsmPrimitive)way);
            rel.addMember(rm);
            for (String key : way.getKeys().keySet()) {
                if (!key.equals("area") || !way.get(key).equals("yes")) {
                    rel.put(key, way.get(key));
                }
                if (key.equals("source")) continue;
                cmds.add(new ChangePropertyCommand((OsmPrimitive)way, key, null));
            }
            cmds.add(new AddCommand((OsmPrimitive)rel));
        }
        Main.main.undoRedo.add((Command)new SequenceCommand(I18n.tr((String)"Create multipolygon", (Object[])new Object[0]), cmds));
        Main.map.repaint();
    }

    protected void updateEnabledState() {
        if (MultipolyAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(MultipolyAction.getCurrentDataSet().getSelected());
        }
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        if (selection == null) {
            this.setEnabled(false);
            return;
        }
        for (OsmPrimitive osmPrimitive : selection) {
            if (!(osmPrimitive instanceof Way)) {
                this.setEnabled(false);
                return;
            }
            if (!((Way)osmPrimitive).isClosed()) {
                this.setEnabled(false);
                return;
            }
            for (Relation r : OsmPrimitive.getFilteredList((Collection)osmPrimitive.getReferrers(), Relation.class)) {
                for (RelationMember rm : r.getMembers()) {
                    if (rm.getMember() != osmPrimitive || "inner".equals(rm.getRole())) continue;
                    this.setEnabled(false);
                    return;
                }
            }
        }
        this.setEnabled(selection.size() >= 1);
    }
}

