/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.print;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrintableMapView
extends MapView
implements Printable {
    protected int fixedMapScale = 0;
    protected double g2dFactor;
    protected MapView mapView;
    public static final int FONT_SIZE = 8;

    public PrintableMapView() {
        super(new JPanel());
        ComponentListener[] listeners = this.getComponentListeners();
        for (int i = 0; i < listeners.length; ++i) {
            this.removeComponentListener(listeners[i]);
        }
        this.mapView = Main.map.mapView;
    }

    public void setFixedMapScale(int scale) {
        this.fixedMapScale = scale;
        this.rezoomToFixedScale();
    }

    public void unsetFixedMapScale() {
        this.setFixedMapScale(0);
        this.rezoomToFixedScale();
    }

    public int getMapScale() {
        if (this.fixedMapScale > 0 || this.g2dFactor == 0.0) {
            return this.fixedMapScale;
        }
        double dist100px = this.getDist100Pixel() / this.g2dFactor;
        int mapScale = (int)(dist100px * 72.0 / 2.54);
        return mapScale;
    }

    public void initialize(PageFormat pageFormat) {
        int resolution = Main.pref.getInteger("print.resolution.dpi", 100);
        this.g2dFactor = 72.0 / (double)resolution;
        this.setSize((int)(pageFormat.getImageableWidth() / this.g2dFactor), (int)(pageFormat.getImageableHeight() / this.g2dFactor));
    }

    public void setSize(int width, int height) {
        Dimension dim = this.getSize();
        if (dim.width != width || dim.height != height) {
            super.setSize(width, height);
            this.zoomTo(this.mapView.getRealBounds());
            this.rezoomToFixedScale();
        }
    }

    public void setSize(Dimension newSize) {
        Dimension dim = this.getSize();
        if (dim.width != newSize.width || dim.height != newSize.height) {
            super.setSize(newSize);
            this.zoomTo(this.mapView.getRealBounds());
            this.rezoomToFixedScale();
        }
    }

    protected void rezoomToFixedScale() {
        if (this.fixedMapScale > 0) {
            double dist100px = this.getDist100Pixel() / this.g2dFactor;
            double mapScale = dist100px * 72.0 / 2.54;
            double mapFactor = (double)this.fixedMapScale / mapScale;
            this.zoomToFactor(mapFactor);
        }
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int page) throws PrinterException {
        if (page > 0) {
            return 1;
        }
        this.initialize(pageFormat);
        Graphics2D g2d = (Graphics2D)g;
        g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        this.paintMap(g2d, pageFormat);
        this.paintMapScale(g2d, pageFormat);
        this.paintMapAttribution(g2d, pageFormat);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintMap(Graphics2D g2d, PageFormat pageFormat) {
        AffineTransform at = g2d.getTransform();
        g2d.scale(this.g2dFactor, this.g2dFactor);
        Bounds box = this.getRealBounds();
        List<Layer> visibleLayers = this.getVisibleLayersInZOrder();
        for (Layer l : visibleLayers) {
            try {
                if (!(l instanceof OsmDataLayer)) {
                    Main.map.mapView = this;
                }
                if (l.getOpacity() < 1.0) {
                    g2d.setComposite(AlphaComposite.getInstance(3, (float)l.getOpacity()));
                }
                l.paint(g2d, (MapView)this, box);
                g2d.setPaintMode();
            }
            finally {
                Main.map.mapView = this.mapView;
            }
        }
        g2d.setTransform(at);
    }

    public void paintMapScale(Graphics2D g2d, PageFormat pageFormat) {
        NavigatableComponent.SystemOfMeasurement som = PrintableMapView.getSystemOfMeasurement();
        double dist100px = this.getDist100Pixel() / this.g2dFactor;
        double dist = dist100px / som.aValue;
        String unit = som.aName;
        if (!Main.pref.getBoolean("system_of_measurement.use_only_lower_unit", false) && dist > som.bValue / som.aValue) {
            dist = dist100px / som.bValue;
            unit = som.bName;
        }
        long distExponent = (long)Math.floor(Math.log(dist) / Math.log(10.0));
        double distMantissa = dist / Math.pow(10.0, distExponent);
        double distScale = 1.0;
        distScale = distMantissa <= 2.5 ? 2.5 / distMantissa : (distMantissa <= 4.0 ? 5.0 / distMantissa : 10.0 / distMantissa);
        Font labelFont = new Font("Arial", 0, 8);
        g2d.setFont(labelFont);
        int x = (int)(100.0 * distScale);
        Rectangle2D bound = g2d.getFontMetrics().getStringBounds("0", g2d);
        int xLeft = (int)(bound.getWidth() / 2.0);
        String rightLabel = som.getDistText(dist100px * distScale);
        bound = g2d.getFontMetrics().getStringBounds(rightLabel, g2d);
        int xRight = xLeft + (int)Math.max(0.95 * (double)x, (double)x - bound.getWidth() / 2.0);
        int h = 4;
        int yLexical = 3 * h;
        int yBar = 4 * h;
        int yLabel = 8 * h;
        int w = (int)(distScale * 100.0);
        int ws = (int)(distScale * 20.0);
        g2d.setColor(Color.WHITE);
        g2d.fillRect(xLeft - 1, yBar - 1, w + 2, h + 2);
        g2d.setFont(labelFont.deriveFont(AffineTransform.getTranslateInstance(0.5, 0.4)));
        g2d.drawString("0", 0, yLabel);
        g2d.drawString(rightLabel, xRight, yLabel);
        g2d.setColor(Color.BLACK);
        g2d.drawRect(xLeft, yBar, w, h);
        g2d.fillRect(xLeft, yBar, ws, h);
        g2d.fillRect(xLeft + (int)(distScale * 40.0), yBar, ws, h);
        g2d.fillRect(xLeft + w - ws, yBar, ws, h);
        g2d.setFont(labelFont);
        g2d.drawString("0", 0, yLabel);
        g2d.drawString(rightLabel, xRight, yLabel);
        int mapScale = this.getMapScale();
        String lexicalScale = I18n.tr((String)"Scale", (Object[])new Object[0]) + " 1 : " + mapScale;
        Font scaleFront = new Font("Arial", 1, 8);
        g2d.setFont(scaleFront);
        bound = g2d.getFontMetrics().getStringBounds(lexicalScale, g2d);
        int xLexical = Math.max(0, xLeft + (w - (int)bound.getWidth()) / 2);
        g2d.setColor(Color.WHITE);
        g2d.setFont(scaleFront.deriveFont(AffineTransform.getTranslateInstance(0.5, 0.4)));
        g2d.drawString(lexicalScale, xLexical, yLexical);
        g2d.setColor(Color.BLACK);
        g2d.setFont(scaleFront);
        g2d.drawString(lexicalScale, xLexical, yLexical);
    }

    public void paintMapAttribution(Graphics2D g2d, PageFormat pageFormat) {
        String text = Main.pref.get("print.attribution", "OSM Map data (c) OpenStreetMap contributors, CC-BY-SA");
        if (text == null || text.length() > 0) {
            Font attributionFont = new Font("Arial", 0, 6);
            g2d.setFont(attributionFont);
            Rectangle2D bound = g2d.getFontMetrics().getStringBounds(text, g2d);
            int x = (int)(pageFormat.getImageableWidth() - bound.getWidth());
            int y = 12;
            g2d.setColor(Color.WHITE);
            g2d.setFont(attributionFont.deriveFont(AffineTransform.getTranslateInstance(0.5, 0.4)));
            g2d.drawString(text, x, y);
            g2d.setColor(Color.BLACK);
            g2d.setFont(attributionFont);
            g2d.drawString(text, x, y);
        }
    }

    public Layer getActiveLayer() {
        return this.mapView.getActiveLayer();
    }

    public int getLayerPos(Layer layer) {
        return this.mapView.getLayerPos(layer);
    }

    protected List<Layer> getVisibleLayersInZOrder() {
        ArrayList<Layer> layers = new ArrayList<Layer>();
        for (Layer l : this.mapView.getAllLayersAsList()) {
            if (!l.isVisible()) continue;
            layers.add(l);
        }
        Collections.sort(layers, new Comparator<Layer>(){

            @Override
            public int compare(Layer l2, Layer l1) {
                if (l1 instanceof OsmDataLayer && l2 instanceof OsmDataLayer) {
                    if (l1 == PrintableMapView.this.getActiveLayer()) {
                        return -1;
                    }
                    if (l2 == PrintableMapView.this.getActiveLayer()) {
                        return 1;
                    }
                    return Integer.valueOf(PrintableMapView.this.getLayerPos(l1)).compareTo(PrintableMapView.this.getLayerPos(l2));
                }
                return Integer.valueOf(PrintableMapView.this.getLayerPos(l1)).compareTo(PrintableMapView.this.getLayerPos(l2));
            }
        });
        return layers;
    }
}

