/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.ohe.gui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.openstreetmap.josm.plugins.ohe.gui.OheEditor;
import org.openstreetmap.josm.tools.I18n;

public class TimeRect
extends JPanel
implements MouseListener,
MouseMotionListener {
    public static final int[] transformCursorTypes = new int[]{13, 8, 7, 11, 5, 9, 4, 10, 6};
    public static final int minuteResterize = 15;
    public static final int verticalNonDrawedPixels = 5;
    public static final boolean[][] transformDirections = new boolean[][]{{true, true, true, true}, {true, false, false, false}, {true, true, false, false}, {false, true, false, false}, {false, true, true, false}, {false, false, true, false}, {false, false, true, true}, {false, false, false, true}, {true, false, false, true}};
    public static final int roundCornerSize = 8;
    private final int clickAreaSize = 16;
    private OheEditor editor;
    private int dayStart;
    private int dayEnd;
    private int minuteStart;
    private int minuteEnd;
    private int actualDayDrag;
    private int actualMinuteDrag;
    private int dragX;
    private int dragY;
    private int transformType;

    public TimeRect(OheEditor editor, int dayStart, int dayEnd, int minutesStart, int minutesEnd) {
        this.editor = editor;
        this.dayStart = dayStart;
        this.dayEnd = dayEnd;
        this.minuteStart = minutesStart;
        this.minuteEnd = minutesEnd;
        this.transformType = -1;
        this.setOpaque(true);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public int getDayStart() {
        return this.dayStart;
    }

    public int getDayEnd() {
        return this.dayEnd;
    }

    public int getMinuteStart() {
        return this.minuteStart;
    }

    public int getMinuteEnd() {
        return this.minuteEnd;
    }

    public void reposition() {
        this.setBounds(this.editor.getPanelBoundsForTimeinterval(this.dayStart, this.dayEnd + 1, this.minuteStart, this.minuteEnd));
        this.editor.contentPanel.repaint();
    }

    private boolean isZeroMinuteInterval() {
        return this.minuteStart == this.minuteEnd;
    }

    private boolean isOpenEndInterval() {
        return this.minuteEnd == 1441;
    }

    private void updateTimeInterval(int newDayStart, int newDayEnd, int newMinuteStart, int newMinuteEnd) {
        this.dayStart = newDayStart;
        this.dayEnd = newDayEnd;
        this.minuteStart = newMinuteStart;
        this.minuteEnd = newMinuteEnd;
        this.editor.dialog.updateValueField(this.editor.timeRects);
        this.reposition();
    }

    public void paintComponent(Graphics g) {
        TimeRect.drawTimeRect((Graphics2D)g, new Rectangle(0, 0, this.getWidth(), this.getHeight()), this.isZeroMinuteInterval(), this.isOpenEndInterval());
    }

    public static void drawTimeRect(Graphics2D g2D, Rectangle bounds, boolean isZeroMinuteInterval, boolean isOpenEndInterval) {
        Color innerColor = new Color(135, 135, 234);
        if (isOpenEndInterval) {
            innerColor = new Color(234, 135, 135);
        }
        int tmpRoundCornerSize = 8;
        int verticalNonFilledBorder = 1;
        if (isZeroMinuteInterval) {
            innerColor = new Color(135, 234, 135);
            tmpRoundCornerSize = 0;
            verticalNonFilledBorder = 5;
        }
        g2D.setColor(innerColor);
        g2D.setComposite(AlphaComposite.getInstance(3, 0.6f));
        g2D.fillRoundRect(bounds.x + 1, bounds.y + verticalNonFilledBorder, bounds.width - 2, bounds.height - 1 - 2 * verticalNonFilledBorder, tmpRoundCornerSize, tmpRoundCornerSize);
        g2D.setColor(new Color(255, 0, 0));
        g2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
        g2D.drawRoundRect(bounds.x + 1, bounds.y + verticalNonFilledBorder, bounds.width - 2, bounds.height - 1 - 2 * verticalNonFilledBorder, tmpRoundCornerSize, tmpRoundCornerSize);
    }

    private int getTransformType(MouseEvent evt) {
        boolean isInWesternTransformClickArea;
        int tmpClickAreaWidth = Math.min(16, this.getWidth() / 3);
        int tmpClickAreaHeight = Math.min(16, this.getHeight() / 3);
        boolean isInNorthernTransformClickArea = evt.getY() < tmpClickAreaHeight;
        boolean isInEasternTransformClickArea = evt.getX() > this.getWidth() - tmpClickAreaWidth;
        boolean isInSouthernTransformClickArea = evt.getY() > this.getHeight() - tmpClickAreaHeight;
        boolean bl = isInWesternTransformClickArea = evt.getX() < tmpClickAreaWidth;
        if (this.isZeroMinuteInterval()) {
            isInNorthernTransformClickArea = false;
            isInSouthernTransformClickArea = false;
        }
        int tType = 0;
        for (int i = 1; i < transformDirections.length && tType == 0; ++i) {
            if (isInNorthernTransformClickArea != transformDirections[i][0] || isInEasternTransformClickArea != transformDirections[i][1] || isInSouthernTransformClickArea != transformDirections[i][2] || isInWesternTransformClickArea != transformDirections[i][3]) continue;
            tType = i;
        }
        return tType;
    }

    public void showMenu(MouseEvent evt) {
        JPopupMenu menu = new JPopupMenu();
        final JCheckBoxMenuItem cbMenuItem = new JCheckBoxMenuItem(I18n.tr((String)"open end", (Object[])new Object[0]), this.isOpenEndInterval());
        menu.add(cbMenuItem);
        cbMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (cbMenuItem.isSelected()) {
                    TimeRect.this.updateTimeInterval(TimeRect.this.dayStart, TimeRect.this.dayEnd, TimeRect.this.minuteStart, 1441);
                } else {
                    TimeRect.this.updateTimeInterval(TimeRect.this.dayStart, TimeRect.this.dayEnd, TimeRect.this.minuteStart, 1440);
                }
            }
        });
        menu.show(this, evt.getX(), evt.getY());
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
        if (this.transformType < 0) {
            this.setCursor(new Cursor(0));
        }
    }

    public void mousePressed(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.showMenu(evt);
        } else {
            this.actualDayDrag = 0;
            this.actualMinuteDrag = 0;
            this.dragX = evt.getXOnScreen();
            this.dragY = evt.getYOnScreen();
            this.transformType = this.getTransformType(evt);
        }
    }

    public void mouseReleased(MouseEvent evt) {
        this.transformType = -1;
        if (evt.isPopupTrigger()) {
            this.showMenu(evt);
        }
    }

    public void mouseDragged(MouseEvent evt) {
        if (this.transformType >= 0) {
            int xDiff = evt.getXOnScreen() - this.dragX;
            int yDiff = evt.getYOnScreen() - this.dragY;
            xDiff = (int)Math.round((double)xDiff / this.editor.getDayWidth()) - this.actualDayDrag;
            yDiff = (int)Math.round((double)yDiff / (this.editor.getMinuteHeight() * 15.0)) * 15 - this.actualMinuteDrag;
            if (xDiff != 0) {
                int newDayStart = this.dayStart;
                int newDayEnd = this.dayEnd;
                if (transformDirections[this.transformType][3]) {
                    newDayStart += xDiff;
                }
                if (transformDirections[this.transformType][1]) {
                    newDayEnd += xDiff;
                }
                if (newDayStart > newDayEnd) {
                    this.editor.removeTimeRect(this);
                    this.transformType = -1;
                    this.setCursor(new Cursor(0));
                } else if (newDayStart >= 0 && newDayEnd <= 6) {
                    this.actualDayDrag += xDiff;
                    this.updateTimeInterval(newDayStart, newDayEnd, this.minuteStart, this.minuteEnd);
                }
            }
            if (yDiff != 0 && this.transformType >= 0) {
                int newMinutesStart = this.minuteStart;
                int newMinutesEnd = this.minuteEnd;
                if (transformDirections[this.transformType][0]) {
                    newMinutesStart += yDiff;
                }
                if (transformDirections[this.transformType][2] && !this.isOpenEndInterval()) {
                    newMinutesEnd += yDiff;
                }
                if (newMinutesStart >= 0 && (newMinutesEnd <= 1440 || this.isOpenEndInterval())) {
                    this.actualMinuteDrag += yDiff;
                    this.updateTimeInterval(this.dayStart, this.dayEnd, newMinutesStart, newMinutesEnd);
                }
            }
        }
        this.editor.mousePositionChanged(evt.getX() + this.getX(), evt.getY() + this.getY(), true);
    }

    public void mouseMoved(MouseEvent evt) {
        if (this.transformType < 0) {
            this.setCursor(new Cursor(transformCursorTypes[this.getTransformType(evt)]));
        }
        this.editor.mousePositionChanged(evt.getX() + this.getX(), evt.getY() + this.getY(), true);
    }
}

