/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.piclayer.transform;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.plugins.piclayer.transform.Matrix3D;
import org.openstreetmap.josm.plugins.piclayer.transform.NoSolutionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PictureTransform {
    private AffineTransform cachedTransform = new AffineTransform();
    private boolean modified = false;
    private List<Point2D> originPoints = new ArrayList<Point2D>(3);
    private List<Point2D> desiredPoints = new ArrayList<Point2D>(3);

    public AffineTransform getTransform() {
        return this.cachedTransform;
    }

    public List<? extends Point2D> getOriginPoints() {
        return this.originPoints;
    }

    public List<? extends Point2D> getDesiredPoints() {
        return this.desiredPoints;
    }

    public void addDesiredPoint(Point2D picturePoint) {
        if (this.desiredPoints.size() < 3) {
            this.desiredPoints.add(picturePoint);
        }
        this.trySolve();
    }

    private AffineTransform solveEquation() throws NoSolutionException {
        Matrix3D X = new Matrix3D(this.originPoints);
        Matrix3D Y = new Matrix3D(this.desiredPoints);
        Matrix3D result = Y.multiply(X.inverse());
        return result.toAffineTransform();
    }

    public void addOriginPoint(Point2D originPoint) {
        if (this.originPoints.size() < 3) {
            this.originPoints.add(originPoint);
        }
        this.trySolve();
    }

    public void resetCalibration() {
        this.originPoints.clear();
        this.desiredPoints.clear();
        this.modified = false;
        this.cachedTransform = new AffineTransform();
    }

    private void trySolve() {
        if (this.desiredPoints.size() == 3 && this.originPoints.size() == 3) {
            try {
                this.cachedTransform.concatenate(this.solveEquation());
                this.modified = true;
                this.desiredPoints.clear();
            }
            catch (NoSolutionException e) {
                System.err.println(e.getMessage());
            }
        }
    }

    public void updatePair(Point2D originPoint, Point2D desiredPoint) {
        if (this.originPoints.size() < 3) {
            return;
        }
        if (originPoint == null) {
            return;
        }
        this.desiredPoints.clear();
        for (Point2D origin : this.originPoints) {
            if (origin.equals(originPoint)) {
                this.desiredPoints.add(desiredPoint);
                continue;
            }
            this.desiredPoints.add(origin);
        }
        this.trySolve();
    }

    public void replaceOriginPoint(Point2D originPoint, Point2D newOriginPoint) {
        if (originPoint == null || newOriginPoint == null) {
            return;
        }
        int index = this.originPoints.indexOf(originPoint);
        if (index < 0) {
            return;
        }
        this.originPoints.set(index, newOriginPoint);
    }

    public void concatenateTransformPoint(AffineTransform transform, Point2D trans) {
        AffineTransform centered = AffineTransform.getTranslateInstance(trans.getX(), trans.getY());
        centered.concatenate(transform);
        centered.translate(-trans.getX(), -trans.getY());
        this.cachedTransform.concatenate(centered);
        for (int i = 0; i < this.originPoints.size(); ++i) {
            Point2D point = this.originPoints.get(i);
            transform.transform(point, point);
        }
        this.modified = true;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified() {
        this.modified = true;
    }

    public void resetModified() {
        this.modified = false;
    }
}

