/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.piclayer.actions.transform.affine;

import java.awt.event.MouseEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.plugins.piclayer.actions.GenericPicTransformAction;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class MovePointAction
extends GenericPicTransformAction {
    public MovePointAction(MapFrame frame) {
        super(I18n.tr((String)"PicLayer Move point", (Object[])new Object[0]), "movepoint", I18n.tr((String)"Drag or create point on the picture", (Object[])new Object[0]), frame, ImageProvider.getCursor((String)"crosshair", null));
    }

    protected void doAction(MouseEvent e) {
        try {
            Point2D pressed = this.currentLayer.transformPoint(e.getPoint());
            if (this.selectedPoint != null) {
                this.currentLayer.getTransformer().replaceOriginPoint(this.selectedPoint, pressed);
                this.selectedPoint = pressed;
            }
        }
        catch (NoninvertibleTransformException e1) {
            e1.printStackTrace();
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (this.currentLayer == null) {
            return;
        }
        try {
            Point2D pressed = this.currentLayer.transformPoint(e.getPoint());
            if (this.selectedPoint == null) {
                this.currentLayer.getTransformer().addOriginPoint(pressed);
            }
        }
        catch (NoninvertibleTransformException e1) {
            e1.printStackTrace();
        }
        Main.map.mapView.repaint();
    }

    public void enterMode() {
        super.enterMode();
        this.updateDrawPoints(true);
    }

    public void exitMode() {
        super.exitMode();
        this.updateDrawPoints(false);
    }
}

