/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.piclayer.actions.newlayer;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.piclayer.layer.PicLayerFromFile;
import org.openstreetmap.josm.tools.I18n;

public class NewLayerFromFileAction
extends JosmAction {
    String m_lastdirprefname = "piclayer.lastdir";

    public NewLayerFromFileAction() {
        super(I18n.tr((String)"New picture layer from file...", (Object[])new Object[0]), "layericon24", null, null, false);
    }

    public void actionPerformed(ActionEvent arg0) {
        JFileChooser fc = new JFileChooser(Main.pref.get(this.m_lastdirprefname));
        fc.setAcceptAllFileFilterUsed(true);
        fc.setFileFilter(new ImageFileFilter());
        fc.setMultiSelectionEnabled(true);
        int result = fc.showOpenDialog(Main.parent);
        if (result == 0) {
            int newLayerPos = Main.map.mapView.getAllLayers().size();
            for (PicLayerFromFile l : Main.map.mapView.getLayersOfType(PicLayerFromFile.class)) {
                int pos = Main.map.mapView.getLayerPos((Layer)l);
                if (pos >= newLayerPos) continue;
                newLayerPos = pos;
            }
            for (File file : fc.getSelectedFiles()) {
                PicLayerFromFile layer = new PicLayerFromFile(file);
                try {
                    layer.initialize();
                }
                catch (IOException e) {
                    System.out.println("NewLayerFromFileAction::actionPerformed - " + e.getMessage());
                    JOptionPane.showMessageDialog(null, e.getMessage());
                    return;
                }
                Main.pref.put(this.m_lastdirprefname, file.getParent());
                Main.main.addLayer((Layer)layer);
                Main.map.mapView.moveLayer((Layer)layer, newLayerPos++);
                if (fc.getSelectedFiles().length != 1 || Main.pref.getInteger("piclayer.zoom-on-load", 1) == 0) continue;
                BoundingXYVisitor v = new BoundingXYVisitor();
                layer.visitBoundingBox(v);
                Main.map.mapView.recalculateCenterScale(v);
            }
        }
    }

    private class AllFilesFilter
    extends FileFilter {
        private AllFilesFilter() {
        }

        public String getDescription() {
            return I18n.tr((String)"All Files", (Object[])new Object[0]);
        }

        public boolean accept(File f) {
            return true;
        }
    }

    private class ImageFileFilter
    extends FileFilter {
        private ImageFileFilter() {
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            int dotIdx = f.getName().lastIndexOf(46);
            if (dotIdx == -1) {
                return false;
            }
            String fileExtension = f.getName().substring(dotIdx + 1);
            String[] supportedExtensions = ImageIO.getReaderFormatNames();
            if ("zip".equalsIgnoreCase(fileExtension)) {
                return true;
            }
            for (String e : supportedExtensions) {
                if (!e.equalsIgnoreCase(fileExtension)) continue;
                return true;
            }
            return false;
        }

        public String getDescription() {
            return I18n.tr((String)"Supported image files + *.zip", (Object[])new Object[0]);
        }
    }
}

