/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.piclayer.actions;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.piclayer.layer.PicLayerAbstract;
import org.openstreetmap.josm.tools.Shortcut;

public abstract class GenericPicTransformAction
extends MapMode
implements MouseListener,
MouseMotionListener {
    protected boolean isDragging = false;
    protected PicLayerAbstract currentLayer = null;
    protected Point2D selectedPoint = null;
    protected EastNorth prevEastNorth = null;
    protected Point2D prevMousePoint = null;

    public GenericPicTransformAction(String name, String iconName, String tooltip, Shortcut shortcut, MapFrame mapFrame, Cursor cursor) {
        super(name, iconName, tooltip, shortcut, mapFrame, cursor);
    }

    public GenericPicTransformAction(String name, String iconName, String tooltip, MapFrame mapFrame, Cursor cursor) {
        super(name, iconName, tooltip, mapFrame, cursor);
    }

    public void enterMode() {
        super.enterMode();
        Main.map.mapView.addMouseListener((MouseListener)this);
        Main.map.mapView.addMouseMotionListener((MouseMotionListener)this);
    }

    public void exitMode() {
        super.exitMode();
        Main.map.mapView.removeMouseListener((MouseListener)this);
        Main.map.mapView.removeMouseMotionListener((MouseMotionListener)this);
    }

    public void mousePressed(MouseEvent e) {
        if (Main.map.mapView.getActiveLayer() instanceof PicLayerAbstract) {
            this.currentLayer = (PicLayerAbstract)Main.map.mapView.getActiveLayer();
            if (this.currentLayer != null && e.getButton() == 1) {
                this.isDragging = true;
                this.prevMousePoint = new Point(e.getPoint());
                this.prevEastNorth = Main.map.mapView.getEastNorth(e.getX(), e.getY());
                this.selectedPoint = this.currentLayer.findSelectedPoint(e.getPoint());
            }
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.isDragging && this.currentLayer != null) {
            this.doAction(e);
            this.prevMousePoint = new Point(e.getPoint());
            this.prevEastNorth = Main.map.mapView.getEastNorth(e.getX(), e.getY());
            Main.map.mapView.repaint();
        }
    }

    protected abstract void doAction(MouseEvent var1);

    public void mouseReleased(MouseEvent e) {
        this.isDragging = false;
    }

    public boolean layerIsSupported(Layer l) {
        return l instanceof PicLayerAbstract;
    }

    protected void updateDrawPoints(boolean value) {
        Layer active = Main.map.mapView.getActiveLayer();
        if (active instanceof PicLayerAbstract) {
            ((PicLayerAbstract)active).setDrawPoints(value);
        }
        Main.map.mapView.repaint();
    }
}

