/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.piclayer.layer;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import org.openstreetmap.josm.plugins.piclayer.layer.PicLayerAbstract;
import org.openstreetmap.josm.tools.I18n;

public class PicLayerFromClipboard
extends PicLayerAbstract {
    protected Image createImage() throws IOException {
        Image image = null;
        Transferable t = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        if (t == null) {
            throw new IOException(I18n.tr((String)"Nothing in clipboard", (Object[])new Object[0]));
        }
        try {
            if (!t.isDataFlavorSupported(DataFlavor.imageFlavor)) {
                throw new IOException(I18n.tr((String)"The clipboard data is not an image", (Object[])new Object[0]));
            }
            image = (Image)t.getTransferData(DataFlavor.imageFlavor);
        }
        catch (UnsupportedFlavorException e) {
            throw new IOException(e.getMessage());
        }
        return image;
    }

    public String getPicLayerName() {
        return "Clipboard";
    }

    protected void lookForCalibration() throws IOException {
    }
}

