/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.licensechange;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.plugins.licensechange.LicenseChangePlugin;
import org.openstreetmap.josm.plugins.licensechange.LicenseProblem;
import org.openstreetmap.josm.tools.GBC;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Check
extends AbstractVisitor {
    protected final String name;
    protected final String description;
    protected boolean enabled = true;
    protected JCheckBox checkEnabled;
    protected JCheckBox checkBeforeUpload;
    protected boolean testBeforeUpload = true;
    protected boolean isBeforeUpload;
    protected List<LicenseProblem> errors = new ArrayList<LicenseProblem>(30);
    protected ProgressMonitor progressMonitor;

    public Check(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public Check(String name) {
        this(name, null);
    }

    public void initialize(LicenseChangePlugin plugin) throws Exception {
    }

    public void startCheck(ProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor == null ? NullProgressMonitor.INSTANCE : progressMonitor;
        this.errors = new ArrayList<LicenseProblem>(30);
    }

    public List<LicenseProblem> getProblems() {
        return this.errors;
    }

    public void endCheck() {
        this.progressMonitor.finishTask();
        this.progressMonitor = null;
    }

    public void visit(Collection<OsmPrimitive> selection) {
        this.progressMonitor.setTicksCount(selection.size());
        for (OsmPrimitive p : selection) {
            if (p.isUsable()) {
                p.visit((Visitor)this);
            }
            this.progressMonitor.worked(1);
        }
    }

    public void visit(Node n) {
    }

    public void visit(Way w) {
    }

    public void visit(Relation r) {
    }

    public void addGui(JPanel testPanel) {
        this.checkEnabled = new JCheckBox(this.name, this.enabled);
        this.checkEnabled.setToolTipText(this.description);
        testPanel.add((Component)this.checkEnabled, GBC.std());
        GBC a = GBC.eol();
        a.anchor = 13;
        this.checkBeforeUpload = new JCheckBox();
        this.checkBeforeUpload.setSelected(this.testBeforeUpload);
        testPanel.add((Component)this.checkBeforeUpload, a);
    }

    public boolean ok() {
        this.enabled = this.checkEnabled.isSelected();
        this.testBeforeUpload = this.checkBeforeUpload.isSelected();
        return false;
    }

    public boolean testBeforeUpload() {
        return this.testBeforeUpload;
    }

    public void setBeforeUpload(boolean isUpload) {
        this.isBeforeUpload = isUpload;
    }
}

