/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.piclayer;

import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenu;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.IconToggleButton;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.piclayer.ActionVisibilityChangeMenu;
import org.openstreetmap.josm.plugins.piclayer.PicToggleButton;
import org.openstreetmap.josm.plugins.piclayer.actions.newlayer.NewLayerFromClipboardAction;
import org.openstreetmap.josm.plugins.piclayer.actions.newlayer.NewLayerFromFileAction;
import org.openstreetmap.josm.plugins.piclayer.actions.transform.MovePictureAction;
import org.openstreetmap.josm.plugins.piclayer.actions.transform.RotatePictureAction;
import org.openstreetmap.josm.plugins.piclayer.actions.transform.ScaleXPictureAction;
import org.openstreetmap.josm.plugins.piclayer.actions.transform.ScaleXYPictureAction;
import org.openstreetmap.josm.plugins.piclayer.actions.transform.ScaleYPictureAction;
import org.openstreetmap.josm.plugins.piclayer.actions.transform.ShearPictureAction;
import org.openstreetmap.josm.plugins.piclayer.actions.transform.affine.MovePointAction;
import org.openstreetmap.josm.plugins.piclayer.actions.transform.affine.TransformPointAction;
import org.openstreetmap.josm.plugins.piclayer.layer.PicLayerAbstract;
import org.openstreetmap.josm.tools.I18n;

public class PicLayerPlugin
extends Plugin
implements MapView.LayerChangeListener {
    public static List<PicToggleButton> buttonList = null;
    private JMenu menu = null;
    private ActionVisibilityChangeMenu actionVisibility;

    public PicLayerPlugin(PluginInformation info) {
        super(info);
        if (Main.main.menu != null) {
            MainMenu mainMenu = Main.main.menu;
            String string = I18n.marktr((String)"PicLayer");
            Main.main.menu.getClass();
            this.menu = mainMenu.addMenu(string, 89, 7, HelpUtil.ht((String)"/Plugin/PicLayer"));
        }
        if (this.menu != null) {
            this.menu.add((Action)((Object)new NewLayerFromFileAction()));
            this.menu.add((Action)((Object)new NewLayerFromClipboardAction()));
            this.menu.setEnabled(false);
        }
        MapView.addLayerChangeListener((MapView.LayerChangeListener)this);
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (newFrame != null) {
            MovePictureAction movePictureAction = new MovePictureAction(newFrame);
            MovePointAction movePointAction = new MovePointAction(newFrame);
            TransformPointAction transformPointAction = new TransformPointAction(newFrame);
            RotatePictureAction rotatePictureAction = new RotatePictureAction(newFrame);
            ScaleXYPictureAction scaleXYPictureAction = new ScaleXYPictureAction(newFrame);
            ScaleXPictureAction scaleXPictureAction = new ScaleXPictureAction(newFrame);
            ScaleYPictureAction scaleYPictureAction = new ScaleYPictureAction(newFrame);
            ShearPictureAction shearPictureAction = new ShearPictureAction(newFrame);
            buttonList = new ArrayList<PicToggleButton>(7);
            buttonList.add(new PicToggleButton((Action)((Object)movePictureAction), "Move Picture", "piclayer.actionvisibility.move", true));
            buttonList.add(new PicToggleButton((Action)((Object)movePointAction), "Move Point", "piclayer.actionvisibility.movepoint", true));
            buttonList.add(new PicToggleButton((Action)((Object)transformPointAction), "Transform Point", "piclayer.actionvisibility.transformpoint", true));
            buttonList.add(new PicToggleButton((Action)((Object)rotatePictureAction), "Rotate", "piclayer.actionvisibility.rotate", false));
            buttonList.add(new PicToggleButton((Action)((Object)scaleXYPictureAction), "Scale", "piclayer.actionvisibility.scale", false));
            buttonList.add(new PicToggleButton((Action)((Object)scaleXPictureAction), "Scale X", "piclayer.actionvisibility.scalex", false));
            buttonList.add(new PicToggleButton((Action)((Object)scaleYPictureAction), "Scale Y", "piclayer.actionvisibility.scaley", false));
            buttonList.add(new PicToggleButton((Action)((Object)shearPictureAction), "Shear", "piclayer.actionvisibility.shear", false));
            for (PicToggleButton btn : buttonList) {
                newFrame.addMapMode((IconToggleButton)btn);
            }
            if (this.actionVisibility == null) {
                this.actionVisibility = new ActionVisibilityChangeMenu();
                this.menu.add(this.actionVisibility);
            }
        }
    }

    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
        boolean oldPic = oldLayer instanceof PicLayerAbstract;
        boolean newPic = newLayer instanceof PicLayerAbstract;
        if (oldPic && !newPic || oldLayer == null && !newPic) {
            for (PicToggleButton btn : buttonList) {
                btn.setVisible(false);
            }
        }
        if (!oldPic && newPic) {
            for (PicToggleButton btn : buttonList) {
                btn.readVisible();
            }
        }
    }

    public void layerAdded(Layer arg0) {
        this.menu.setEnabled(true);
    }

    public void layerRemoved(Layer arg0) {
        boolean enable = Main.map.mapView.getAllLayers().size() != 0;
        this.menu.setEnabled(enable);
    }
}

