/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.piclayer;

import javax.swing.Action;
import javax.swing.JMenu;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.IconToggleButton;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.piclayer.ActionVisibilityChangeMenu;
import org.openstreetmap.josm.plugins.piclayer.actions.newlayer.NewLayerFromClipboardAction;
import org.openstreetmap.josm.plugins.piclayer.actions.newlayer.NewLayerFromFileAction;
import org.openstreetmap.josm.plugins.piclayer.actions.transform.MovePictureAction;
import org.openstreetmap.josm.plugins.piclayer.actions.transform.RotatePictureAction;
import org.openstreetmap.josm.plugins.piclayer.actions.transform.ScaleXPictureAction;
import org.openstreetmap.josm.plugins.piclayer.actions.transform.ScaleXYPictureAction;
import org.openstreetmap.josm.plugins.piclayer.actions.transform.ScaleYPictureAction;
import org.openstreetmap.josm.plugins.piclayer.actions.transform.ShearPictureAction;
import org.openstreetmap.josm.plugins.piclayer.actions.transform.affine.MovePointAction;
import org.openstreetmap.josm.plugins.piclayer.actions.transform.affine.TransformPointAction;
import org.openstreetmap.josm.tools.I18n;

public class PicLayerPlugin
extends Plugin
implements MapView.LayerChangeListener {
    static IconToggleButton movePictureButton = null;
    static IconToggleButton movePointButton = null;
    static IconToggleButton transformPointButton = null;
    static IconToggleButton rotatePictureButton = null;
    static IconToggleButton scalexPictureButton = null;
    static IconToggleButton scaleyPictureButton = null;
    static IconToggleButton scalexyPictureButton = null;
    static IconToggleButton shearPictureButton = null;
    private JMenu menu = null;
    private ActionVisibilityChangeMenu actionVisibility;

    public PicLayerPlugin(PluginInformation info) {
        super(info);
        if (Main.main.menu != null) {
            MainMenu mainMenu = Main.main.menu;
            String string = I18n.marktr((String)"PicLayer");
            Main.main.menu.getClass();
            this.menu = mainMenu.addMenu(string, 73, 7, HelpUtil.ht((String)"/Plugin/PicLayer"));
        }
        if (this.menu != null) {
            this.menu.add((Action)((Object)new NewLayerFromFileAction()));
            this.menu.add((Action)((Object)new NewLayerFromClipboardAction()));
            this.menu.setEnabled(false);
        }
        MapView.addLayerChangeListener((MapView.LayerChangeListener)this);
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (newFrame != null) {
            MovePictureAction movePictureAction = new MovePictureAction(newFrame);
            MovePointAction movePointAction = new MovePointAction(newFrame);
            TransformPointAction transformPointAction = new TransformPointAction(newFrame);
            RotatePictureAction rotatePictureAction = new RotatePictureAction(newFrame);
            ScaleXYPictureAction scaleXYPictureAction = new ScaleXYPictureAction(newFrame);
            ScaleXPictureAction scaleXPictureAction = new ScaleXPictureAction(newFrame);
            ScaleYPictureAction scaleYPictureAction = new ScaleYPictureAction(newFrame);
            ShearPictureAction shearPictureAction = new ShearPictureAction(newFrame);
            movePictureButton = new IconToggleButton((Action)((Object)movePictureAction));
            movePointButton = new IconToggleButton((Action)((Object)movePointAction));
            transformPointButton = new IconToggleButton((Action)((Object)transformPointAction));
            rotatePictureButton = new IconToggleButton((Action)((Object)rotatePictureAction));
            scalexyPictureButton = new IconToggleButton((Action)((Object)scaleXYPictureAction));
            scalexPictureButton = new IconToggleButton((Action)((Object)scaleXPictureAction));
            scaleyPictureButton = new IconToggleButton((Action)((Object)scaleYPictureAction));
            shearPictureButton = new IconToggleButton((Action)((Object)shearPictureAction));
            newFrame.addMapMode(movePictureButton);
            newFrame.addMapMode(movePointButton);
            newFrame.addMapMode(transformPointButton);
            newFrame.addMapMode(rotatePictureButton);
            newFrame.addMapMode(scalexyPictureButton);
            newFrame.addMapMode(scalexPictureButton);
            newFrame.addMapMode(scaleyPictureButton);
            newFrame.addMapMode(shearPictureButton);
            if (this.actionVisibility == null) {
                this.actionVisibility = new ActionVisibilityChangeMenu();
                this.menu.add(this.actionVisibility);
            }
        }
    }

    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
    }

    public void layerAdded(Layer arg0) {
        this.menu.setEnabled(true);
    }

    public void layerRemoved(Layer arg0) {
        boolean enable = Main.map.mapView.getAllLayers().size() != 0;
        this.menu.setEnabled(enable);
    }
}

