/*
 * Decompiled with CFR 0.152.
 */
package reverter.corehacks;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.history.HistoryNode;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.data.osm.history.HistoryRelation;
import org.openstreetmap.josm.data.osm.history.HistoryWay;
import org.openstreetmap.josm.data.osm.history.RelationMember;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmDataParsingException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.DateUtils;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import reverter.corehacks.ChangesetDataSet;

public class OsmChangesetContentParser {
    private final InputSource source;
    private final ChangesetDataSet data;

    public OsmChangesetContentParser(InputStream source) throws UnsupportedEncodingException {
        CheckParameterUtil.ensureParameterNotNull((Object)source, (String)"source");
        this.source = new InputSource(new InputStreamReader(source, "UTF-8"));
        this.data = new ChangesetDataSet();
    }

    public OsmChangesetContentParser(String source) {
        CheckParameterUtil.ensureParameterNotNull((Object)source, (String)"source");
        this.source = new InputSource(new StringReader(source));
        this.data = new ChangesetDataSet();
    }

    public ChangesetDataSet parse(ProgressMonitor progressMonitor) throws OsmDataParsingException {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        try {
            progressMonitor.beginTask("");
            progressMonitor.indeterminateSubTask(I18n.tr((String)"Parsing changeset content ...", (Object[])new Object[0]));
            SAXParserFactory.newInstance().newSAXParser().parse(this.source, (DefaultHandler)new Parser());
        }
        catch (OsmDataParsingException e) {
            throw e;
        }
        catch (ParserConfigurationException e) {
            throw new OsmDataParsingException((Exception)e);
        }
        catch (SAXException e) {
            throw new OsmDataParsingException((Exception)e);
        }
        catch (IOException e) {
            throw new OsmDataParsingException((Exception)e);
        }
        finally {
            progressMonitor.finishTask();
        }
        return this.data;
    }

    public ChangesetDataSet parse() throws OsmDataParsingException {
        return this.parse(null);
    }

    private class Parser
    extends DefaultHandler {
        private HistoryOsmPrimitive currentPrimitive;
        private ChangesetDataSet.ChangesetModificationType currentModificationType;
        private Locator locator;

        private Parser() {
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        protected void throwException(String message) throws OsmDataParsingException {
            throw new OsmDataParsingException(message).rememberLocation(this.locator);
        }

        protected void throwException(Exception e) throws OsmDataParsingException {
            throw new OsmDataParsingException(e).rememberLocation(this.locator);
        }

        protected long getMandatoryAttributeLong(Attributes attr, String name) throws SAXException {
            String v = attr.getValue(name);
            if (v == null) {
                this.throwException(I18n.tr((String)"Missing mandatory attribute ''{0}''.", (Object[])new Object[]{name}));
            }
            Long l = 0L;
            try {
                l = Long.parseLong(v);
            }
            catch (NumberFormatException e) {
                this.throwException(I18n.tr((String)"Illegal value for mandatory attribute ''{0}'' of type long. Got ''{1}''.", (Object[])new Object[]{name, v}));
            }
            if (l < 0L) {
                this.throwException(I18n.tr((String)"Illegal value for mandatory attribute ''{0}'' of type long (>=0). Got ''{1}''.", (Object[])new Object[]{name, v}));
            }
            return l;
        }

        protected long getAttributeLong(Attributes attr, String name, long defaultValue) throws SAXException {
            String v = attr.getValue(name);
            if (v == null) {
                return defaultValue;
            }
            Long l = 0L;
            try {
                l = Long.parseLong(v);
            }
            catch (NumberFormatException e) {
                this.throwException(I18n.tr((String)"Illegal value for mandatory attribute ''{0}'' of type long. Got ''{1}''.", (Object[])new Object[]{name, v}));
            }
            if (l < 0L) {
                this.throwException(I18n.tr((String)"Illegal value for mandatory attribute ''{0}'' of type long (>=0). Got ''{1}''.", (Object[])new Object[]{name, v}));
            }
            return l;
        }

        protected Double getMandatoryAttributeDouble(Attributes attr, String name) throws SAXException {
            String v = attr.getValue(name);
            if (v == null) {
                this.throwException(I18n.tr((String)"Missing mandatory attribute ''{0}''.", (Object[])new Object[]{name}));
            }
            double d = 0.0;
            try {
                d = Double.parseDouble(v);
            }
            catch (NumberFormatException e) {
                this.throwException(I18n.tr((String)"Illegal value for mandatory attribute ''{0}'' of type double. Got ''{1}''.", (Object[])new Object[]{name, v}));
            }
            return d;
        }

        protected String getMandatoryAttributeString(Attributes attr, String name) throws SAXException {
            String v = attr.getValue(name);
            if (v == null) {
                this.throwException(I18n.tr((String)"Missing mandatory attribute ''{0}''.", (Object[])new Object[]{name}));
            }
            return v;
        }

        protected String getAttributeString(Attributes attr, String name, String defaultValue) {
            String v = attr.getValue(name);
            if (v == null) {
                return defaultValue;
            }
            return v;
        }

        protected boolean getMandatoryAttributeBoolean(Attributes attr, String name) throws SAXException {
            String v = attr.getValue(name);
            if (v == null) {
                this.throwException(I18n.tr((String)"Missing mandatory attribute ''{0}''.", (Object[])new Object[]{name}));
            }
            if ("true".equals(v)) {
                return true;
            }
            if ("false".equals(v)) {
                return false;
            }
            this.throwException(I18n.tr((String)"Illegal value for mandatory attribute ''{0}'' of type boolean. Got ''{1}''.", (Object[])new Object[]{name, v}));
            return false;
        }

        protected HistoryOsmPrimitive createPrimitive(Attributes atts, OsmPrimitiveType type) throws SAXException {
            long id = this.getMandatoryAttributeLong(atts, "id");
            long version = this.getMandatoryAttributeLong(atts, "version");
            long changesetId = this.getMandatoryAttributeLong(atts, "changeset");
            boolean visible = this.getMandatoryAttributeBoolean(atts, "visible");
            long uid = this.getAttributeLong(atts, "uid", -1L);
            String user = this.getAttributeString(atts, "user", I18n.tr((String)"<anonymous>", (Object[])new Object[0]));
            String v = this.getMandatoryAttributeString(atts, "timestamp");
            Date timestamp = DateUtils.fromString((String)v);
            HistoryWay primitive = null;
            if (type.equals((Object)OsmPrimitiveType.NODE)) {
                double lat = this.getMandatoryAttributeDouble(atts, "lat");
                double lon = this.getMandatoryAttributeDouble(atts, "lon");
                primitive = new HistoryNode(id, version, visible, user, uid, changesetId, timestamp, new LatLon(lat, lon));
            } else if (type.equals((Object)OsmPrimitiveType.WAY)) {
                primitive = new HistoryWay(id, version, visible, user, uid, changesetId, timestamp);
            }
            if (type.equals((Object)OsmPrimitiveType.RELATION)) {
                primitive = new HistoryRelation(id, version, visible, user, uid, changesetId, timestamp);
            }
            return primitive;
        }

        protected void startNode(Attributes atts) throws SAXException {
            this.currentPrimitive = this.createPrimitive(atts, OsmPrimitiveType.NODE);
        }

        protected void startWay(Attributes atts) throws SAXException {
            this.currentPrimitive = this.createPrimitive(atts, OsmPrimitiveType.WAY);
        }

        protected void startRelation(Attributes atts) throws SAXException {
            this.currentPrimitive = this.createPrimitive(atts, OsmPrimitiveType.RELATION);
        }

        protected void handleTag(Attributes atts) throws SAXException {
            String key = this.getMandatoryAttributeString(atts, "k");
            String value = this.getMandatoryAttributeString(atts, "v");
            this.currentPrimitive.put(key, value);
        }

        protected void handleNodeReference(Attributes atts) throws SAXException {
            long ref = this.getMandatoryAttributeLong(atts, "ref");
            ((HistoryWay)this.currentPrimitive).addNode(ref);
        }

        protected void handleMember(Attributes atts) throws SAXException {
            long ref = this.getMandatoryAttributeLong(atts, "ref");
            String v = this.getMandatoryAttributeString(atts, "type");
            OsmPrimitiveType type = null;
            try {
                type = OsmPrimitiveType.fromApiTypeName((String)v);
            }
            catch (IllegalArgumentException e) {
                this.throwException(I18n.tr((String)"Illegal value for mandatory attribute ''{0}'' of type OsmPrimitiveType. Got ''{1}''.", (Object[])new Object[]{"type", v}));
            }
            String role = this.getMandatoryAttributeString(atts, "role");
            RelationMember member = new RelationMember(role, type, ref);
            ((HistoryRelation)this.currentPrimitive).addMember(member);
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (qName.equals("node")) {
                this.startNode(atts);
            } else if (qName.equals("way")) {
                this.startWay(atts);
            } else if (qName.equals("relation")) {
                this.startRelation(atts);
            } else if (qName.equals("tag")) {
                this.handleTag(atts);
            } else if (qName.equals("nd")) {
                this.handleNodeReference(atts);
            } else if (qName.equals("member")) {
                this.handleMember(atts);
            } else if (!qName.equals("osmChange")) {
                if (qName.equals("create")) {
                    this.currentModificationType = ChangesetDataSet.ChangesetModificationType.CREATED;
                } else if (qName.equals("modify")) {
                    this.currentModificationType = ChangesetDataSet.ChangesetModificationType.UPDATED;
                } else if (qName.equals("delete")) {
                    this.currentModificationType = ChangesetDataSet.ChangesetModificationType.DELETED;
                } else {
                    System.err.println(I18n.tr((String)"Warning: unsupported start element ''{0}'' in changeset content at position ({1},{2}). Skipping.", (Object[])new Object[]{qName, this.locator.getLineNumber(), this.locator.getColumnNumber()}));
                }
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals("node") || qName.equals("way") || qName.equals("relation")) {
                if (this.currentModificationType == null) {
                    this.throwException(I18n.tr((String)"Illegal document structure. Found node, way, or relation outside of ''create'', ''modify'', or ''delete''.", (Object[])new Object[0]));
                }
                OsmChangesetContentParser.this.data.put(this.currentPrimitive, this.currentModificationType);
            } else if (!qName.equals("osmChange")) {
                if (qName.equals("create")) {
                    this.currentModificationType = null;
                } else if (qName.equals("modify")) {
                    this.currentModificationType = null;
                } else if (qName.equals("delete")) {
                    this.currentModificationType = null;
                } else if (!(qName.equals("tag") || qName.equals("nd") || qName.equals("member"))) {
                    System.err.println(I18n.tr((String)"Warning: unsupported end element ''{0}'' in changeset content at position ({1},{2}). Skipping.", (Object[])new Object[]{qName, this.locator.getLineNumber(), this.locator.getColumnNumber()}));
                }
            }
        }

        public void error(SAXParseException e) throws SAXException {
            this.throwException(e);
        }

        public void fatalError(SAXParseException e) throws SAXException {
            this.throwException(e);
        }
    }
}

