/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.print;

import java.awt.event.ActionEvent;
import java.awt.print.PrinterAbortException;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.plugins.print.PrintPlugin;
import org.openstreetmap.josm.plugins.print.PrintableMapView;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class PrintAction
extends JosmAction {
    public PrintAction() {
        super(I18n.tr((String)"Print...", (Object[])new Object[0]), null, I18n.tr((String)"Print the map", (Object[])new Object[0]), Shortcut.registerShortcut((String)"print:print", (String)I18n.tr((String)"File: {0}", (Object[])new Object[]{I18n.tr((String)"Print...", (Object[])new Object[0])}), (int)80, (int)2), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent e) {
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPrintable(new PrintableMapView());
        if (job.printDialog()) {
            try {
                PrintPlugin.adjustPrefs();
                job.print();
            }
            catch (PrinterAbortException ex) {
                String msg = ex.getLocalizedMessage();
                if (msg.length() == 0) {
                    msg = I18n.tr((String)"Printing has been cancelled.", (Object[])new Object[0]);
                }
                JOptionPane.showMessageDialog(Main.parent, msg, I18n.tr((String)"Printing stopped", (Object[])new Object[0]), 2);
            }
            catch (PrinterException ex) {
                String msg = ex.getLocalizedMessage();
                if (msg.length() == 0) {
                    msg = I18n.tr((String)"Printing has failed.", (Object[])new Object[0]);
                }
                JOptionPane.showMessageDialog(Main.parent, msg, I18n.tr((String)"Printing stopped", (Object[])new Object[0]), 0);
            }
            finally {
                PrintPlugin.restorePrefs();
            }
        }
    }
}

