/*
 * Decompiled with CFR 0.152.
 */
package toms.seamarks.buoys;

import java.util.Map;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import toms.Messages;
import toms.dialogs.SmpDialogAction;
import toms.seamarks.buoys.Buoy;

public class BuoyCard
extends Buoy {
    public BuoyCard(SmpDialogAction dia, Node node) {
        super(dia);
        Map keys = node.getKeys();
        this.setNode(node);
        this.resetMask();
        this.dlg.cbM01TypeOfMark.setSelectedIndex(2);
        this.dlg.cbM01CatOfMark.removeAllItems();
        this.dlg.cbM01CatOfMark.addItem(Messages.getString("SmpDialogAction.157"));
        this.dlg.cbM01CatOfMark.addItem(Messages.getString("SmpDialogAction.158"));
        this.dlg.cbM01CatOfMark.addItem(Messages.getString("SmpDialogAction.159"));
        this.dlg.cbM01CatOfMark.addItem(Messages.getString("SmpDialogAction.160"));
        this.dlg.cbM01CatOfMark.addItem(Messages.getString("SmpDialogAction.161"));
        this.dlg.cbM01CatOfMark.setEnabled(true);
        this.dlg.cbM01CatOfMark.setVisible(true);
        this.dlg.lM01CatOfMark.setVisible(true);
        this.dlg.cbM01StyleOfMark.removeAllItems();
        this.dlg.cbM01StyleOfMark.addItem(Messages.getString("SmpDialogAction.212"));
        this.dlg.cbM01StyleOfMark.addItem(Messages.getString("Buoy.01"));
        this.dlg.cbM01StyleOfMark.addItem(Messages.getString("Buoy.04"));
        this.dlg.cbM01StyleOfMark.addItem(Messages.getString("Buoy.05"));
        this.dlg.cbM01StyleOfMark.addItem(Messages.getString("Buoy.06"));
        this.dlg.cbM01StyleOfMark.addItem(Messages.getString("Buoy.07"));
        this.dlg.cbM01StyleOfMark.setVisible(true);
        this.dlg.lM01StyleOfMark.setVisible(true);
        this.setRegion(Main.pref.get("tomsplugin.IALA").equals("B"));
        if (keys.containsKey("name")) {
            this.setName((String)keys.get("name"));
        }
        if (keys.containsKey("seamark:name")) {
            this.setName((String)keys.get("seamark:name"));
        }
        if (keys.containsKey("seamark:longname")) {
            this.setLongname((String)keys.get("seamark:longname"));
        }
        if (keys.containsKey("seamark:fixme")) {
            this.setFixme((String)keys.get("seamark:fixme"));
        }
        if (keys.containsKey("seamark:buoy_cardinal:name")) {
            this.setName((String)keys.get("seamark:buoy_cardinal:name"));
        } else if (keys.containsKey("seamark:beacon_cardinal:name")) {
            this.setName((String)keys.get("seamark:beacon_cardinal:name"));
        } else if (keys.containsKey("seamark:light_float:name")) {
            this.setName((String)keys.get("seamark:light_float:name"));
        }
        String cat = "";
        String col = "";
        if (keys.containsKey("seamark:buoy_cardinal:category")) {
            cat = (String)keys.get("seamark:buoy_cardinal:category");
        } else if (keys.containsKey("seamark:beacon_cardinal:category")) {
            cat = (String)keys.get("seamark:beacon_cardinal:category");
        }
        if (keys.containsKey("seamark:buoy_cardinal:colour")) {
            col = (String)keys.get("seamark:buoy_cardinal:colour");
        } else if (keys.containsKey("seamark:beacon_cardinal:colour")) {
            col = (String)keys.get("seamark:beacon_cardinal:colour");
        } else if (keys.containsKey("seamark:light_float:colour")) {
            col = (String)keys.get("seamark:light_float:colour");
        }
        if (cat.isEmpty()) {
            if (col.equals("black;yellow")) {
                this.setBuoyIndex(1);
                this.setColour(6);
            } else if (col.equals("black;yellow;black")) {
                this.setBuoyIndex(2);
                this.setColour(7);
            } else if (col.equals("yellow;black")) {
                this.setBuoyIndex(3);
                this.setColour(8);
            } else if (col.equals("yellow;black;yellow")) {
                this.setBuoyIndex(4);
                this.setColour(9);
            }
        } else if (cat.equals("north")) {
            this.setBuoyIndex(1);
            this.setColour(6);
        } else if (cat.equals("east")) {
            this.setBuoyIndex(2);
            this.setColour(7);
        } else if (cat.equals("south")) {
            this.setBuoyIndex(3);
            this.setColour(8);
        } else if (cat.equals("west")) {
            this.setBuoyIndex(4);
            this.setColour(9);
        }
        if (keys.containsKey("seamark:buoy_cardinal:shape")) {
            String str = (String)keys.get("seamark:buoy_cardinal:shape");
            if (str.equals("pillar")) {
                this.setStyleIndex(1);
            } else if (str.equals("spar")) {
                this.setStyleIndex(2);
            }
        } else if (keys.containsKey("seamark:beacon_cardinal:colour")) {
            if (keys.containsKey("seamark:beacon_cardinal:shape")) {
                String str = (String)keys.get("seamark:beacon_cardinal:shape");
                if (str.equals("tower")) {
                    this.setStyleIndex(4);
                } else {
                    this.setStyleIndex(3);
                }
            } else {
                this.setStyleIndex(3);
            }
        } else if (keys.containsKey("seamark:type") && ((String)keys.get("seamark:type")).equals("light_float")) {
            this.setStyleIndex(5);
        }
        if (this.getStyleIndex() >= this.dlg.cbM01StyleOfMark.getItemCount()) {
            this.setStyleIndex(0);
        }
        this.refreshLights();
        this.parseLights(keys);
        this.parseFogRadar(keys);
        this.dlg.cbM01CatOfMark.setSelectedIndex(this.getBuoyIndex());
        this.dlg.cbM01StyleOfMark.setSelectedIndex(this.getStyleIndex());
        this.dlg.tfM01Name.setText(this.getName());
        this.dlg.cM01TopMark.setSelected(this.hasTopMark());
    }

    public void refreshLights() {
        this.dlg.cbM01Kennung.removeAllItems();
        this.dlg.cbM01Kennung.addItem(Messages.getString("SmpDialogAction.212"));
        this.dlg.cbM01Kennung.setSelectedIndex(0);
        switch (this.getBuoyIndex()) {
            case 1: {
                this.dlg.cbM01Kennung.addItem("Q");
                this.dlg.cbM01Kennung.addItem("VQ");
                break;
            }
            case 2: {
                this.dlg.cbM01Kennung.addItem("Q(3)");
                this.dlg.cbM01Kennung.addItem("VQ(3)");
                break;
            }
            case 3: {
                this.dlg.cbM01Kennung.addItem("Q(6)+LFl");
                this.dlg.cbM01Kennung.addItem("VQ(6)+LFl");
                break;
            }
            case 4: {
                this.dlg.cbM01Kennung.addItem("Q(9)");
                this.dlg.cbM01Kennung.addItem("VQ(9)");
            }
        }
    }

    public boolean isValid() {
        return this.getBuoyIndex() > 0 && this.getStyleIndex() > 0;
    }

    public void setLightColour() {
        super.setLightColour("W");
    }

    public void paintSign() {
        if (this.dlg.paintlock) {
            return;
        }
        super.paintSign();
        this.dlg.sM01StatusBar.setText(this.getErrMsg());
        if (this.isValid()) {
            this.dlg.tfM01Name.setEnabled(true);
            this.dlg.tfM01Name.setText(this.getName());
            this.dlg.cM01TopMark.setSelected(true);
            this.dlg.cM01TopMark.setVisible(true);
            this.dlg.cM01TopMark.setEnabled(false);
            this.dlg.cM01Radar.setVisible(true);
            this.dlg.cM01Racon.setVisible(true);
            this.dlg.cM01Fog.setVisible(true);
            this.dlg.cM01Fired.setEnabled(true);
            this.dlg.cM01Fired.setVisible(true);
            this.dlg.tfM01Group.setVisible(false);
            this.dlg.lM01Group.setVisible(false);
            if (!this.isSectored()) {
                this.dlg.cbM01Colour.setVisible(false);
                this.dlg.lM01Colour.setVisible(false);
            }
            this.dlg.rbM01Fired1.setVisible(false);
            this.dlg.rbM01FiredN.setVisible(false);
            this.dlg.lM01Height.setVisible(false);
            this.dlg.tfM01Height.setVisible(false);
            this.dlg.lM01Range.setVisible(false);
            this.dlg.tfM01Range.setVisible(false);
            if (this.isFired()) {
                switch (this.getStyleIndex()) {
                    case 3: 
                    case 4: 
                    case 5: {
                        this.dlg.lM01Height.setVisible(true);
                        this.dlg.tfM01Height.setVisible(true);
                        this.dlg.lM01Range.setVisible(true);
                        this.dlg.tfM01Range.setVisible(true);
                        break;
                    }
                }
            }
            String image = "/images/Cardinal";
            switch (this.getStyleIndex()) {
                case 1: {
                    image = image + "_Pillar";
                    break;
                }
                case 2: {
                    image = image + "_Spar";
                    break;
                }
                case 3: {
                    image = image + "_Beacon";
                    break;
                }
                case 4: {
                    image = image + "_Tower";
                    break;
                }
                case 5: {
                    image = image + "_Float";
                    break;
                }
                default: {
                    return;
                }
            }
            switch (this.getBuoyIndex()) {
                case 1: {
                    image = image + "_North";
                    break;
                }
                case 2: {
                    image = image + "_East";
                    break;
                }
                case 3: {
                    image = image + "_South";
                    break;
                }
                case 4: {
                    image = image + "_West";
                    break;
                }
                default: {
                    return;
                }
            }
            if (!image.equals("/images/Cardinal")) {
                image = image + ".png";
                this.dlg.lM01Icon.setIcon(new ImageIcon(this.getClass().getResource(image)));
            } else {
                this.dlg.lM01Icon.setIcon(null);
            }
        }
    }

    public void saveSign() {
        Node node = this.getNode();
        if (node == null) {
            return;
        }
        String shape = "";
        switch (this.getStyleIndex()) {
            case 1: {
                super.saveSign("buoy_cardinal");
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_cardinal:shape", "pillar"));
                break;
            }
            case 2: {
                super.saveSign("buoy_cardinal");
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_cardinal:shape", "spar"));
                break;
            }
            case 3: {
                super.saveSign("beacon_cardinal");
                break;
            }
            case 4: {
                super.saveSign("beacon_cardinal");
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_cardinal:shape", "tower"));
                break;
            }
            case 5: {
                super.saveSign("light_float");
                break;
            }
        }
        switch (this.getStyleIndex()) {
            case 1: 
            case 2: {
                switch (this.getBuoyIndex()) {
                    case 1: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_cardinal:category", "north"));
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_cardinal:colour", "black;yellow"));
                        shape = "2 cones up";
                        break;
                    }
                    case 2: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_cardinal:category", "east"));
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_cardinal:colour", "black;yellow;black"));
                        shape = "2 cones base together";
                        break;
                    }
                    case 3: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_cardinal:category", "south"));
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_cardinal:colour", "yellow;black"));
                        shape = "2 cones down";
                        break;
                    }
                    case 4: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_cardinal:category", "west"));
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_cardinal:colour", "yellow;black;yellow"));
                        shape = "2 cones point together";
                    }
                }
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_cardinal:colour_pattern", "horizontal"));
                break;
            }
            case 3: 
            case 4: {
                switch (this.getBuoyIndex()) {
                    case 1: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_cardinal:category", "north"));
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_cardinal:colour", "black;yellow"));
                        shape = "2 cones up";
                        break;
                    }
                    case 2: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_cardinal:category", "east"));
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_cardinal:colour", "black;yellow;black"));
                        shape = "2 cones base together";
                        break;
                    }
                    case 3: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_cardinal:category", "south"));
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_cardinal:colour", "yellow;black"));
                        shape = "2 cones down";
                        break;
                    }
                    case 4: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_cardinal:category", "west"));
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_cardinal:colour", "yellow;black;yellow"));
                        shape = "2 cones point together";
                    }
                }
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_cardinal:colour_pattern", "horizontal"));
                break;
            }
            case 5: {
                switch (this.getBuoyIndex()) {
                    case 1: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:light_float:colour", "black;yellow"));
                        shape = "2 cones up";
                        break;
                    }
                    case 2: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:light_float:colour", "black;yellow;black"));
                        shape = "2 cones base together";
                        break;
                    }
                    case 3: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:light_float:colour", "yellow;black"));
                        shape = "2 cones down";
                        break;
                    }
                    case 4: {
                        Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:light_float:colour", "yellow;black;yellow"));
                        shape = "2 cones point together";
                    }
                }
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:light_float:colour_pattern", "horizontal"));
            }
        }
        this.saveTopMarkData(shape, "black");
        this.saveLightData();
        this.saveRadarFogData();
    }
}

